/*
 * Decompiled with CFR 0.152.
 */
package nxt.util.bbh;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.util.bbh.LengthRw;
import nxt.util.bbh.ObjectRw;

class ByteArrayRw
implements ObjectRw<byte[]> {
    private final LengthRw lengthRw;

    ByteArrayRw(LengthRw lengthRw) {
        this.lengthRw = lengthRw;
    }

    @Override
    public int getSize(byte[] byArray) {
        return this.lengthRw.getSize() + byArray.length;
    }

    @Override
    public byte[] readFromBuffer(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        int n = this.lengthRw.readFromBuffer(byteBuffer);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public void writeToBuffer(byte[] byArray, ByteBuffer byteBuffer) {
        this.lengthRw.writeToBuffer(byteBuffer, byArray.length);
        byteBuffer.put(byArray);
    }

    @Override
    public boolean validate(byte[] byArray) {
        return this.lengthRw.validate(byArray.length);
    }
}

