/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteUpdateLock {
    private final ReentrantReadWriteLock sharedLock = new ReentrantReadWriteLock();
    private final ReentrantLock mutexLock = new ReentrantLock();
    private final ThreadLocal<LockCount> lockCount = ThreadLocal.withInitial(() -> new LockCount());
    private final ReadLock readLock = new ReadLock();
    private final UpdateLock updateLock = new UpdateLock();
    private final WriteLock writeLock = new WriteLock();

    public Lock readLock() {
        return this.readLock;
    }

    public Lock updateLock() {
        return this.updateLock;
    }

    public Lock writeLock() {
        return this.writeLock;
    }

    private class LockCount {
        private int readCount;
        private int updateCount;
        private int writeCount;

        private LockCount() {
        }
    }

    private class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            LockCount lockCount = ReadWriteUpdateLock.this.lockCount.get();
            if (lockCount.readCount != 0) {
                throw new IllegalStateException("Write lock cannot be obtained while holding the read lock");
            }
            boolean bl = false;
            try {
                ReadWriteUpdateLock.this.mutexLock.lock();
                ++lockCount.updateCount;
                bl = true;
                ReadWriteUpdateLock.this.sharedLock.writeLock().lock();
                ++lockCount.writeCount;
            }
            catch (Exception exception) {
                if (bl) {
                    ReadWriteUpdateLock.this.mutexLock.unlock();
                    --lockCount.updateCount;
                }
                throw exception;
            }
        }

        @Override
        public void unlock() {
            LockCount lockCount = ReadWriteUpdateLock.this.lockCount.get();
            ReadWriteUpdateLock.this.sharedLock.writeLock().unlock();
            --lockCount.writeCount;
            ReadWriteUpdateLock.this.mutexLock.unlock();
            --lockCount.updateCount;
        }

        @Override
        public boolean hasLock() {
            return ReadWriteUpdateLock.this.lockCount.get().writeCount != 0;
        }
    }

    private class UpdateLock
    implements Lock {
        private UpdateLock() {
        }

        @Override
        public void lock() {
            LockCount lockCount = ReadWriteUpdateLock.this.lockCount.get();
            if (lockCount.readCount != 0) {
                throw new IllegalStateException("Update lock cannot be obtained while holding the read lock");
            }
            if (lockCount.writeCount != 0) {
                throw new IllegalStateException("Update lock cannot be obtained while holding the write lock");
            }
            ReadWriteUpdateLock.this.mutexLock.lock();
            ++lockCount.updateCount;
        }

        @Override
        public void unlock() {
            ReadWriteUpdateLock.this.mutexLock.unlock();
            --ReadWriteUpdateLock.this.lockCount.get().updateCount;
        }

        @Override
        public boolean hasLock() {
            return ReadWriteUpdateLock.this.lockCount.get().updateCount != 0;
        }
    }

    private class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() {
            ReadWriteUpdateLock.this.sharedLock.readLock().lock();
            ++ReadWriteUpdateLock.this.lockCount.get().readCount;
        }

        @Override
        public void unlock() {
            ReadWriteUpdateLock.this.sharedLock.readLock().unlock();
            --ReadWriteUpdateLock.this.lockCount.get().readCount;
        }

        @Override
        public boolean hasLock() {
            return ReadWriteUpdateLock.this.lockCount.get().readCount != 0;
        }
    }

    public static interface Lock {
        public void lock();

        public void unlock();

        public boolean hasLock();
    }
}

