/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class QueuedThreadPool
extends ThreadPoolExecutor {
    private int coreSize;
    private int maxSize;
    private final LinkedBlockingQueue<Runnable> pendingQueue = new LinkedBlockingQueue();

    public QueuedThreadPool(int n, int n2) {
        super(n, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.coreSize = n;
        this.maxSize = n2;
    }

    @Override
    public int getCorePoolSize() {
        return this.coreSize;
    }

    @Override
    public void setCorePoolSize(int n) {
        super.setCorePoolSize(n);
        this.coreSize = n;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxSize;
    }

    @Override
    public void setMaximumPoolSize(int n) {
        this.maxSize = n;
    }

    @Override
    public void execute(Runnable runnable) throws RejectedExecutionException {
        if (runnable == null) {
            throw new NullPointerException("Null runnable passed to execute()");
        }
        try {
            if (this.getActiveCount() >= this.maxSize) {
                this.pendingQueue.put(runnable);
            } else {
                super.execute(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RejectedExecutionException("Unable to queue task", interruptedException);
        }
    }

    @Override
    public Future<?> submit(Runnable runnable) throws RejectedExecutionException {
        if (runnable == null) {
            throw new NullPointerException("Null runnable passed to submit()");
        }
        FutureTask<Object> futureTask = new FutureTask<Object>(runnable, null);
        this.execute(futureTask);
        return futureTask;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) throws RejectedExecutionException {
        if (runnable == null) {
            throw new NullPointerException("Null runnable passed to submit()");
        }
        FutureTask<T> futureTask = new FutureTask<T>(runnable, t);
        this.execute(futureTask);
        return futureTask;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) throws RejectedExecutionException {
        if (callable == null) {
            throw new NullPointerException("Null callable passed to submit()");
        }
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        this.execute(futureTask);
        return futureTask;
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        Runnable runnable2 = this.pendingQueue.poll();
        if (runnable2 != null) {
            super.execute(runnable2);
        }
    }
}

