/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import nxt.Genesis;
import nxt.NxtException;
import nxt.crypto.Crypto;

public final class Convert {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long[] multipliers = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L};
    public static final BigInteger two64 = new BigInteger("18446744073709551616");
    public static final long[] EMPTY_LONG = new long[0];
    public static final byte[] EMPTY_BYTE = new byte[0];
    public static final byte[][] EMPTY_BYTES = new byte[0][];
    public static final String[] EMPTY_STRING = new String[0];
    private static final boolean BIG_INTEGER_HAS_LONG_VALUE_EXACT;
    public static final Comparator<byte[]> byteArrayComparator;

    private Convert() {
    }

    public static byte[] parseHexString(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = string.charAt(i * 2);
            n = n > 96 ? n - 87 : n - 48;
            int n2 = string.charAt(i * 2 + 1);
            int n3 = n2 = n2 > 96 ? n2 - 87 : n2 - 48;
            if (n < 0 || n2 < 0 || n > 15 || n2 > 15) {
                throw new NumberFormatException("Invalid hex number: " + string);
            }
            byArray[i] = (byte)((n << 4) + n2);
        }
        return byArray;
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i * 2] = hexChars[byArray[i] >> 4 & 0xF];
            cArray[i * 2 + 1] = hexChars[byArray[i] & 0xF];
        }
        return String.valueOf(cArray);
    }

    public static long parseUnsignedLong(String string) {
        if (string == null) {
            return 0L;
        }
        return Long.parseUnsignedLong(string);
    }

    public static long parseLong(Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        throw new IllegalArgumentException("Not a long: " + object);
    }

    public static long parseAccountId(String string) {
        if (string == null || (string = string.trim()).isEmpty()) {
            return 0L;
        }
        int n = (string = string.toUpperCase(Locale.ROOT)).indexOf(45);
        if (n > 0) {
            return Crypto.rsDecode(string.substring(n + 1));
        }
        if (n == 0) {
            return Long.valueOf(string);
        }
        return Long.parseUnsignedLong(string);
    }

    public static String rsAccount(long l) {
        return "GMD-" + Crypto.rsEncode(l);
    }

    public static long fullHashToId(byte[] byArray) {
        if (byArray == null || byArray.length < 8) {
            throw new IllegalArgumentException("Invalid hash: " + Arrays.toString(byArray));
        }
        BigInteger bigInteger = new BigInteger(1, new byte[]{byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]});
        return bigInteger.longValue();
    }

    public static long fromEpochTime(int n) {
        return (long)n * 1000L + Genesis.EPOCH_BEGINNING - 500L;
    }

    public static int toEpochTime(long l) {
        return (int)((l - Genesis.EPOCH_BEGINNING + 500L) / 1000L);
    }

    public static String emptyToNull(String string) {
        return string == null || string.length() == 0 ? null : string;
    }

    public static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static byte[] emptyToNull(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        for (byte by : byArray) {
            if (by == 0) continue;
            return byArray;
        }
        return null;
    }

    public static byte[][] nullToEmpty(byte[][] byArray) {
        return byArray == null ? EMPTY_BYTES : byArray;
    }

    public static long[] nullToEmpty(long[] lArray) {
        return lArray == null ? EMPTY_LONG : lArray;
    }

    public static long nullToZero(Long l) {
        return l == null ? 0L : l;
    }

    public static long[] toArray(List<Long> list) {
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get(i);
        }
        return lArray;
    }

    public static List<Long> toList(long[] lArray) {
        ArrayList<Long> arrayList = new ArrayList<Long>(lArray.length);
        for (long l : lArray) {
            arrayList.add(l);
        }
        return arrayList;
    }

    public static Long[] toArray(long[] lArray) {
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            longArray[i] = lArray[i];
        }
        return longArray;
    }

    public static long[] toArray(Long[] longArray) {
        long[] lArray = new long[longArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            lArray[i] = longArray[i];
        }
        return lArray;
    }

    public static Set<Long> toSet(long[] lArray) {
        if (lArray == null || lArray.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Long> hashSet = new HashSet<Long>(lArray.length);
        for (long l : lArray) {
            hashSet.add(l);
        }
        return hashSet;
    }

    public static byte[] toBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString(), unsupportedEncodingException);
        }
    }

    public static byte[] toBytes(String string, boolean bl) {
        return bl ? Convert.toBytes(string) : Convert.parseHexString(string);
    }

    public static String toString(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString(), unsupportedEncodingException);
        }
    }

    public static String toString(byte[] byArray, boolean bl) {
        return bl ? Convert.toString(byArray) : Convert.toHexString(byArray);
    }

    public static byte[] toBytes(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l >> 8 * i);
        }
        return byArray;
    }

    public static String readString(ByteBuffer byteBuffer, int n, int n2) throws NxtException.NotValidException {
        if (n > Convert.getMaxStringSize(n2)) {
            throw new NxtException.NotValidException("Max parameter length exceeded");
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return Convert.toString(byArray);
    }

    public static int getMaxStringSize(int n) {
        return 3 * n;
    }

    public static String truncate(String string, String string2, int n, boolean bl) {
        return string == null ? string2 : (string.length() > n ? string.substring(0, bl ? n - 3 : n) + (bl ? "..." : "") : string);
    }

    public static long parseNXT(String string) {
        return Convert.parseStringFraction(string, 8, 1000000000L);
    }

    private static long parseStringFraction(String string, int n, long l) {
        String[] stringArray = string.trim().split("\\.");
        if (stringArray.length == 0 || stringArray.length > 2) {
            throw new NumberFormatException("Invalid number: " + string);
        }
        long l2 = Long.parseLong(stringArray[0]);
        if (l2 > l) {
            throw new IllegalArgumentException("Whole part of value exceeds maximum possible");
        }
        if (stringArray.length == 1) {
            return l2 * multipliers[n];
        }
        long l3 = Long.parseLong(stringArray[1]);
        if (l3 >= multipliers[n] || stringArray[1].length() > n) {
            throw new IllegalArgumentException("Fractional part exceeds maximum allowed divisibility");
        }
        for (int i = stringArray[1].length(); i < n; ++i) {
            l3 *= 10L;
        }
        return l2 * multipliers[n] + l3;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] byArray) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray2;
            try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gZIPOutputStream.write(byArray);
                gZIPOutputStream.flush();
                gZIPOutputStream.close();
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            return byArray2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] uncompress(byte[] var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long longValueExact(BigInteger bigInteger) {
        if (BIG_INTEGER_HAS_LONG_VALUE_EXACT) {
            return bigInteger.longValueExact();
        }
        long l = bigInteger.longValue();
        if (BigInteger.valueOf(l).equals(bigInteger)) {
            return l;
        }
        throw new ArithmeticException("BigInteger out of long range");
    }

    static {
        boolean bl = true;
        try {
            BigInteger.class.getMethod("longValueExact", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = false;
        }
        BIG_INTEGER_HAS_LONG_VALUE_EXACT = bl;
        byteArrayComparator = (byArray, byArray2) -> {
            int n = Math.min(((byte[])byArray).length, ((byte[])byArray2).length);
            for (int i = 0; i < n; ++i) {
                int n2 = Byte.compare(byArray[i], byArray2[i]);
                if (n2 == 0) continue;
                return n2;
            }
            return ((byte[])byArray).length - ((byte[])byArray2).length;
        };
    }
}

