/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class BriefLogFormatter
extends Formatter {
    private static final ThreadLocal<MessageFormat> messageFormat = ThreadLocal.withInitial(() -> new MessageFormat("{0,date,yyyy-MM-dd HH:mm:ss} {1}: {2}\n{3}"));
    private static final Logger logger = Logger.getLogger("");
    private static final BriefLogFormatter briefLogFormatter = new BriefLogFormatter();

    static void init() {
        Handler[] handlerArray;
        for (Handler handler : handlerArray = logger.getHandlers()) {
            handler.setFormatter(briefLogFormatter);
        }
    }

    @Override
    public String format(LogRecord logRecord) {
        Object[] objectArray = new Object[4];
        objectArray[0] = new Date(logRecord.getMillis());
        objectArray[1] = logRecord.getLevel().getName();
        objectArray[2] = logRecord.getMessage();
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            objectArray[3] = ((Object)stringWriter).toString();
        } else {
            objectArray[3] = "";
        }
        return messageFormat.get().format(objectArray);
    }

    private BriefLogFormatter() {
    }
}

