/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nxt.Genesis;
import nxt.util.Convert;

public final class VerifyTraceFile {
    private static final List<String> balanceHeaders = Arrays.asList("balance", "unconfirmed balance");
    private static final List<String> deltaHeaders = Arrays.asList("transaction amount", "transaction fee", "dividend", "generation fee", "trade cost", "purchase cost", "discount", "refund", "exchange cost", "currency cost");
    private static final List<String> assetQuantityHeaders = Arrays.asList("asset balance", "unconfirmed asset balance");
    private static final List<String> deltaAssetQuantityHeaders = Arrays.asList("asset quantity", "trade quantity");
    private static final List<String> currencyBalanceHeaders = Arrays.asList("currency balance", "unconfirmed currency balance");
    private static final List<String> deltaCurrencyUnitHeaders = Arrays.asList("currency units", "exchange quantity");
    private static final String beginQuote = "^\"";
    private static final String endQuote = "\"$";

    private static boolean isBalance(String string) {
        return balanceHeaders.contains(string);
    }

    private static boolean isDelta(String string) {
        return deltaHeaders.contains(string);
    }

    private static boolean isAssetQuantity(String string) {
        return assetQuantityHeaders.contains(string);
    }

    private static boolean isDeltaAssetQuantity(String string) {
        return deltaAssetQuantityHeaders.contains(string);
    }

    private static boolean isCurrencyBalance(String string) {
        return currencyBalanceHeaders.contains(string);
    }

    private static boolean isDeltaCurrencyUnits(String string) {
        return deltaCurrencyUnitHeaders.contains(string);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        String string2 = stringArray.length == 1 ? stringArray[0] : "nxt-trace.csv";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));){
            Object object4;
            Object object2;
            HashSet<String> hashSet2;
            String[] stringArray2;
            String string3 = bufferedReader.readLine();
            String[] stringArray3 = VerifyTraceFile.unquote(string3.split("\t"));
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            HashMap<String, Map> hashMap2 = new HashMap<String, Map>();
            HashMap<String, Long> hashMap3 = new HashMap<String, Long>();
            HashMap<Object, Long> hashMap4 = new HashMap<Object, Long>();
            HashMap<String, Map> hashMap5 = new HashMap<String, Map>();
            HashMap<String, Long> hashMap6 = new HashMap<String, Long>();
            HashMap<Object, Long> hashMap7 = new HashMap<Object, Long>();
            while ((string3 = bufferedReader.readLine()) != null) {
                long l;
                long l2;
                void var14_19;
                stringArray2 = VerifyTraceFile.unquote(string3.split("\t"));
                hashSet2 = new HashMap();
                boolean i = false;
                while (var14_19 < stringArray3.length) {
                    hashSet2.put(stringArray3[var14_19], stringArray2[var14_19]);
                    ++var14_19;
                }
                String hashSet3 = (String)hashSet2.get("account");
                Map map = hashMap.computeIfAbsent(hashSet3, string -> new HashMap());
                Map map2 = hashMap2.computeIfAbsent(hashSet3, string -> new HashMap());
                String string4 = (String)hashSet2.get("event");
                if ("asset issuance".equals(string4)) {
                    String string5 = (String)hashSet2.get("asset");
                    hashMap3.put(string5, Long.parseLong((String)hashSet2.get("asset quantity")));
                }
                if ("asset transfer".equals(string4) && Genesis.CREATOR_ID == Convert.parseUnsignedLong(hashSet3)) {
                    String string6 = (String)hashSet2.get("asset");
                    l2 = Long.parseLong((String)hashSet2.get("asset quantity"));
                    l = (Long)hashMap3.get(string6);
                    hashMap3.put(string6, l - l2);
                }
                if ("asset quantity change".equals(string4)) {
                    String string7 = (String)hashSet2.get("asset");
                    l2 = Long.parseLong((String)hashSet2.get("asset quantity"));
                    l = (Long)hashMap3.get(string7);
                    hashMap3.put(string7, l + l2);
                }
                Map map3 = hashMap5.computeIfAbsent(hashSet3, string -> new HashMap());
                if ("currency issuance".equals(string4)) {
                    String string8 = (String)hashSet2.get("currency");
                    hashMap6.put(string8, Long.parseLong((String)hashSet2.get("currency units")));
                }
                if ("crowdfunding".equals(string4)) {
                    String string9 = (String)hashSet2.get("currency");
                    hashMap6.put(string9, Long.parseLong((String)hashSet2.get("crowdfunding")));
                }
                if ("currency mint".equals(string4)) {
                    String string10 = (String)hashSet2.get("currency");
                    hashMap6.put(string10, Math.addExact(VerifyTraceFile.nullToZero((Long)hashMap6.get(string10)), Long.parseLong((String)hashSet2.get("currency units"))));
                }
                if ("currency claim".equals(string4)) {
                    String string11 = (String)hashSet2.get("currency");
                    hashMap6.put(string11, Math.addExact(VerifyTraceFile.nullToZero((Long)hashMap6.get(string11)), Long.parseLong((String)hashSet2.get("currency units"))));
                }
                if ("currency delete".equals(string4) || "undo crowdfunding".equals(string4)) {
                    String string12 = (String)hashSet2.get("currency");
                    hashMap6.put(string12, 0L);
                }
                for (Map.Entry entry : hashSet2.entrySet()) {
                    long l3;
                    String string13 = (String)entry.getKey();
                    object2 = (String)entry.getValue();
                    if (object2 == null || "".equals(((String)object2).trim())) continue;
                    if (VerifyTraceFile.isBalance(string13)) {
                        map.put(string13, Long.parseLong((String)object2));
                        continue;
                    }
                    if (VerifyTraceFile.isDelta(string13)) {
                        long l4 = VerifyTraceFile.nullToZero((Long)map.get(string13));
                        map.put(string13, Math.addExact(l4, Long.parseLong((String)object2)));
                        continue;
                    }
                    if (VerifyTraceFile.isAssetQuantity(string13)) {
                        String string14 = (String)hashSet2.get("asset");
                        object4 = map2.computeIfAbsent(string14, string -> new HashMap());
                        object4.put(string13, Long.parseLong((String)object2));
                        continue;
                    }
                    if (VerifyTraceFile.isDeltaAssetQuantity(string13)) {
                        String string15 = (String)hashSet2.get("asset");
                        object4 = map2.computeIfAbsent(string15, string -> new HashMap());
                        l3 = VerifyTraceFile.nullToZero((Long)object4.get(string13));
                        object4.put(string13, Math.addExact(l3, Long.parseLong((String)object2)));
                        continue;
                    }
                    if (VerifyTraceFile.isCurrencyBalance(string13)) {
                        String string16 = (String)hashSet2.get("currency");
                        object4 = map3.computeIfAbsent(string16, string -> new HashMap());
                        object4.put(string13, Long.parseLong((String)object2));
                        continue;
                    }
                    if (!VerifyTraceFile.isDeltaCurrencyUnits(string13)) continue;
                    String string17 = (String)hashSet2.get("currency");
                    object4 = map3.computeIfAbsent(string17, string -> new HashMap());
                    l3 = VerifyTraceFile.nullToZero((Long)object4.get(string13));
                    object4.put(string13, Math.addExact(l3, Long.parseLong((String)object2)));
                }
            }
            stringArray2 = new HashSet();
            for (Map.Entry entry : hashMap.entrySet()) {
                Object object3;
                String string18 = (String)entry.getKey();
                Map map = (Map)entry.getValue();
                System.out.println("account: " + string18);
                for (String string19 : balanceHeaders) {
                    System.out.println(string19 + ": " + VerifyTraceFile.nullToZero((Long)map.get(string19)));
                }
                System.out.println("totals:");
                long l = 0L;
                for (String string20 : deltaHeaders) {
                    long l5 = VerifyTraceFile.nullToZero((Long)map.get(string20));
                    l = Math.addExact(l, l5);
                    System.out.println(string20 + ": " + l5);
                }
                System.out.println("total confirmed balance change: " + l);
                long l6 = VerifyTraceFile.nullToZero((Long)map.get("balance"));
                if (l6 != l) {
                    System.out.println("ERROR: balance doesn't match total change!!!");
                    stringArray2.add(string18);
                }
                Map map4 = (Map)hashMap2.get(string18);
                for (Map.Entry entry2 : map4.entrySet()) {
                    long l7;
                    object4 = (String)entry2.getKey();
                    object3 = (Map)entry2.getValue();
                    System.out.println("asset: " + (String)object4);
                    for (Map.Entry entry3 : object3.entrySet()) {
                        System.out.println((String)entry3.getKey() + ": " + entry3.getValue());
                    }
                    long l8 = 0L;
                    for (String string21 : deltaAssetQuantityHeaders) {
                        l7 = VerifyTraceFile.nullToZero((Long)object3.get(string21));
                        l8 = Math.addExact(l8, l7);
                    }
                    System.out.println("total confirmed asset quantity change: " + l8);
                    long l9 = VerifyTraceFile.nullToZero((Long)object3.get("asset balance"));
                    if (l9 != l8 && (Genesis.CREATOR_ID != Convert.parseUnsignedLong(string18) || l9 != 0L)) {
                        System.out.println("ERROR: asset balance doesn't match total asset quantity change!!!");
                        stringArray2.add(string18);
                    }
                    l7 = VerifyTraceFile.nullToZero((Long)hashMap4.get(object4));
                    hashMap4.put(object4, Math.addExact(l7, l9));
                }
                object2 = (Map)hashMap5.get(string18);
                for (Object object4 : object2.entrySet()) {
                    long l10;
                    object3 = (String)object4.getKey();
                    Map map5 = (Map)object4.getValue();
                    System.out.println("currency: " + (String)object3);
                    for (Map.Entry entry4 : map5.entrySet()) {
                        System.out.println((String)entry4.getKey() + ": " + entry4.getValue());
                    }
                    long l11 = 0L;
                    for (String string22 : deltaCurrencyUnitHeaders) {
                        l10 = VerifyTraceFile.nullToZero((Long)map5.get(string22));
                        l11 = Math.addExact(l11, l10);
                    }
                    System.out.println("total confirmed currency units change: " + l11);
                    long l12 = VerifyTraceFile.nullToZero((Long)map5.get("currency balance"));
                    if (l12 != l11) {
                        System.out.println("ERROR: currency balance doesn't match total currency units change!!!");
                        stringArray2.add(string18);
                    }
                    l10 = VerifyTraceFile.nullToZero((Long)hashMap7.get(object3));
                    hashMap7.put(object3, Math.addExact(l10, l12));
                }
                System.out.println();
            }
            hashSet2 = new HashSet<String>();
            for (Map.Entry entry : hashMap3.entrySet()) {
                String string23 = (String)entry.getKey();
                long l = (Long)entry.getValue();
                if (l == VerifyTraceFile.nullToZero((Long)hashMap4.get(string23))) continue;
                System.out.println("ERROR: asset " + string23 + " balances don't match, issued: " + l + ", total of account balances: " + hashMap4.get(string23));
                hashSet2.add(string23);
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry entry : hashMap6.entrySet()) {
                String string24 = (String)entry.getKey();
                long l = (Long)entry.getValue();
                if (l == VerifyTraceFile.nullToZero((Long)hashMap7.get(string24))) continue;
                System.out.println("ERROR: currency " + string24 + " balances don't match, issued: " + l + ", total of account balances: " + hashMap7.get(string24));
                hashSet.add(string24);
            }
            if (stringArray2.size() > 0) {
                System.out.println("ERROR: " + stringArray2.size() + " accounts have incorrect balances");
                System.out.println(stringArray2);
            } else {
                System.out.println("SUCCESS: all " + hashMap.size() + " account balances and asset balances match the transaction and trade totals!");
            }
            if (hashSet2.size() > 0) {
                System.out.println("ERROR: " + hashSet2.size() + " assets have incorrect balances");
                System.out.println(hashSet2);
            } else {
                System.out.println("SUCCESS: all " + hashMap3.size() + " assets quantities are correct!");
            }
            if (hashSet.size() > 0) {
                System.out.println("ERROR: " + hashSet.size() + " currencies have incorrect balances");
                System.out.println(hashSet);
            } else {
                System.out.println("SUCCESS: all " + hashMap6.size() + " currency units are correct!");
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            throw new RuntimeException(iOException);
        }
    }

    private static String[] unquote(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].replaceFirst(beginQuote, "").replaceFirst(endQuote, "");
        }
        return stringArray2;
    }

    private static long nullToZero(Long l) {
        return l == null ? 0L : l;
    }
}

