/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import nxt.Nxt;
import nxt.Transaction;
import nxt.util.Convert;

public final class SignTransactions {
    public static void main(String[] stringArray) {
        try {
            String string;
            Console console;
            File file;
            File file2;
            if (stringArray.length != 2) {
                System.out.println("Usage: SignTransactions <unsigned transaction bytes file> <signed transaction bytes file>");
                System.exit(1);
            }
            if (!(file2 = new File(stringArray[0])).exists()) {
                System.out.println("File not found: " + file2.getAbsolutePath());
                System.exit(1);
            }
            if ((file = new File(stringArray[1])).exists()) {
                System.out.println("File already exists: " + file.getAbsolutePath());
                System.exit(1);
            }
            if ((console = System.console()) == null) {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));){
                    string = bufferedReader.readLine();
                }
            } else {
                string = new String(console.readPassword("Secret phrase: ", new Object[0]));
            }
            int n = 0;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                 BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    byte[] byArray = Convert.parseHexString(string2);
                    Transaction.Builder builder = Nxt.newTransactionBuilder(byArray);
                    Transaction transaction = builder.build(string);
                    bufferedWriter.write(Convert.toHexString(transaction.getBytes()));
                    bufferedWriter.newLine();
                    ++n;
                }
            }
            System.out.println("Signed " + n + " transactions");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

