/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import nxt.Nxt;
import nxt.Transaction;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class SignTransactionJSON {
    public static void main(String[] stringArray) {
        try {
            File file;
            File file2;
            Logger.setLevel(Logger.Level.ERROR);
            if (stringArray.length == 0 || stringArray.length > 2) {
                System.out.println("Usage: SignTransactionJSON <unsigned transaction json file> <signed transaction json file>");
                System.exit(1);
            }
            if (!(file2 = new File(stringArray[0])).exists()) {
                System.out.println("File not found: " + file2.getAbsolutePath());
                System.exit(1);
            }
            if ((file = stringArray.length == 2 ? new File(stringArray[1]) : (file2.getName().startsWith("unsigned.") ? new File(file2.getParentFile(), file2.getName().substring(2)) : new File(file2.getParentFile(), "signed." + file2.getName()))).exists()) {
                System.out.println("File already exists: " + file.getAbsolutePath());
                System.exit(1);
            }
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                 BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
                String string;
                Object object;
                JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)bufferedReader);
                byte[] byArray = Crypto.sha256().digest(Convert.parseHexString((String)jSONObject.get((Object)"senderPublicKey")));
                String string2 = Convert.rsAccount(Convert.fullHashToId(byArray));
                Console console = System.console();
                if (console == null) {
                    object = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        string = ((BufferedReader)object).readLine();
                    }
                    finally {
                        ((BufferedReader)object).close();
                    }
                } else {
                    string = new String(console.readPassword("Secret phrase for account " + string2 + ": ", new Object[0]));
                }
                object = Nxt.newTransactionBuilder(jSONObject);
                Transaction transaction = object.build(string);
                bufferedWriter.write(transaction.getJSONObject().toJSONString());
                bufferedWriter.newLine();
                System.out.println("Signed transaction JSON saved as: " + file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

