/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import nxt.Account;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.http.API;
import nxt.http.APIEnum;
import nxt.peer.Hallmark;
import nxt.peer.Peer;
import nxt.peer.PeerWebSocket;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.CountingInputReader;
import nxt.util.CountingInputStream;
import nxt.util.CountingOutputWriter;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

final class PeerImpl
implements Peer {
    private final String host;
    private final PeerWebSocket webSocket;
    private volatile PeerWebSocket inboundSocket;
    private volatile boolean useWebSocket;
    private volatile String announcedAddress;
    private volatile int port;
    private volatile boolean shareAddress;
    private volatile Hallmark hallmark;
    private volatile String platform;
    private volatile String application;
    private volatile int apiPort;
    private volatile int apiSSLPort;
    private volatile EnumSet<APIEnum> disabledAPIs;
    private volatile int apiServerIdleTimeout;
    private volatile String version;
    private volatile boolean isOldVersion;
    private volatile long adjustedWeight;
    private volatile int blacklistingTime;
    private volatile String blacklistingCause;
    private volatile Peer.State state;
    private volatile long downloadedVolume;
    private volatile long uploadedVolume;
    private volatile int lastUpdated;
    private volatile int lastConnectAttempt;
    private volatile int lastInboundRequest;
    private volatile long hallmarkBalance = -1L;
    private volatile int hallmarkBalanceHeight;
    private volatile long services;
    private volatile Peer.BlockchainState blockchainState;

    PeerImpl(String string, String string2) {
        this.host = string;
        this.announcedAddress = string2;
        try {
            this.port = new URI("http://" + string2).getPort();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.state = Peer.State.NON_CONNECTED;
        this.shareAddress = true;
        this.webSocket = new PeerWebSocket();
        this.useWebSocket = Peers.useWebSockets && !Peers.useProxy;
        this.disabledAPIs = EnumSet.noneOf(APIEnum.class);
        this.apiServerIdleTimeout = API.apiServerIdleTimeout;
        this.blockchainState = Peer.BlockchainState.UP_TO_DATE;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Peer.State getState() {
        return this.state;
    }

    void setState(Peer.State state) {
        if (state != Peer.State.CONNECTED) {
            this.webSocket.close();
        }
        if (this.state == state) {
            return;
        }
        if (this.state == Peer.State.NON_CONNECTED) {
            this.state = state;
            Peers.notifyListeners(this, Peers.Event.ADDED_ACTIVE_PEER);
        } else if (state != Peer.State.NON_CONNECTED) {
            this.state = state;
            Peers.notifyListeners(this, Peers.Event.CHANGED_ACTIVE_PEER);
        } else {
            this.state = state;
        }
    }

    @Override
    public long getDownloadedVolume() {
        return this.downloadedVolume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDownloadedVolume(long l) {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            this.downloadedVolume += l;
        }
        Peers.notifyListeners(this, Peers.Event.DOWNLOADED_VOLUME);
    }

    @Override
    public long getUploadedVolume() {
        return this.uploadedVolume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUploadedVolume(long l) {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            this.uploadedVolume += l;
        }
        Peers.notifyListeners(this, Peers.Event.UPLOADED_VOLUME);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    void setVersion(String string) {
        if (string != null && string.length() > 10) {
            throw new IllegalArgumentException("Invalid version length: " + string.length());
        }
        boolean bl = string == null || !string.equals(this.version);
        this.version = string;
        this.isOldVersion = false;
        if ("CoopNetwork".equals(this.application)) {
            this.isOldVersion = Peers.isOldVersion(string, Constants.MIN_VERSION);
            if (this.isOldVersion) {
                if (bl) {
                    Logger.logDebugMessage(String.format("Blacklisting %s version %s", this.host, string));
                }
                this.blacklistingCause = "Old version: " + string;
                this.lastInboundRequest = 0;
                this.setState(Peer.State.NON_CONNECTED);
                Peers.notifyListeners(this, Peers.Event.BLACKLIST);
            }
        }
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    void setApplication(String string) {
        if (string == null || string.length() > 20) {
            throw new IllegalArgumentException("Invalid application");
        }
        this.application = string;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    void setPlatform(String string) {
        if (string != null && string.length() > 30) {
            throw new IllegalArgumentException("Invalid platform length: " + string.length());
        }
        this.platform = string;
    }

    @Override
    public String getSoftware() {
        return Convert.truncate(this.application, "?", 10, false) + " (" + Convert.truncate(this.version, "?", 10, false) + ") @ " + Convert.truncate(this.platform, "?", 10, false);
    }

    @Override
    public int getApiPort() {
        return this.apiPort;
    }

    void setApiPort(Object object) {
        if (object != null) {
            try {
                this.apiPort = ((Long)object).intValue();
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Invalid peer apiPort " + object);
            }
        }
    }

    @Override
    public int getApiSSLPort() {
        return this.apiSSLPort;
    }

    void setApiSSLPort(Object object) {
        if (object != null) {
            try {
                this.apiSSLPort = ((Long)object).intValue();
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Invalid peer apiSSLPort " + object);
            }
        }
    }

    @Override
    public Set<APIEnum> getDisabledAPIs() {
        return Collections.unmodifiableSet(this.disabledAPIs);
    }

    void setDisabledAPIs(Object object) {
        if (object instanceof String) {
            this.disabledAPIs = APIEnum.base64StringToEnumSet((String)object);
        }
    }

    @Override
    public int getApiServerIdleTimeout() {
        return this.apiServerIdleTimeout;
    }

    void setApiServerIdleTimeout(Object object) {
        if (object instanceof Integer) {
            this.apiServerIdleTimeout = (Integer)object;
        }
    }

    @Override
    public Peer.BlockchainState getBlockchainState() {
        return this.blockchainState;
    }

    void setBlockchainState(Object object) {
        Peer.BlockchainState blockchainState = null;
        if (object instanceof Number) {
            blockchainState = Peer.BlockchainState.get((Number)object);
        }
        if (blockchainState != null) {
            this.blockchainState = blockchainState;
        } else {
            Logger.logDebugMessage("Invalid blockchain state " + object + " " + this.getHost());
        }
    }

    @Override
    public boolean shareAddress() {
        return this.shareAddress;
    }

    void setShareAddress(boolean bl) {
        this.shareAddress = bl;
    }

    @Override
    public String getAnnouncedAddress() {
        return this.announcedAddress;
    }

    void setAnnouncedAddress(String string) {
        if (string != null && string.length() > 100) {
            throw new IllegalArgumentException("Announced address too long: " + string.length());
        }
        this.announcedAddress = string;
        if (string != null) {
            try {
                this.port = new URI("http://" + string).getPort();
            }
            catch (URISyntaxException uRISyntaxException) {
                this.port = -1;
            }
        } else {
            this.port = -1;
        }
    }

    @Override
    public int getPort() {
        return this.port <= 0 ? Peers.getDefaultPeerPort() : this.port;
    }

    @Override
    public Hallmark getHallmark() {
        return this.hallmark;
    }

    @Override
    public int getWeight() {
        if (this.hallmark == null) {
            return 0;
        }
        if (this.hallmarkBalance == -1L || this.hallmarkBalanceHeight < Nxt.getBlockchain().getHeight() - 60) {
            long l = this.hallmark.getAccountId();
            Account account = Account.getAccount(l);
            this.hallmarkBalance = account == null ? 0L : account.getBalanceNQT();
            this.hallmarkBalanceHeight = Nxt.getBlockchain().getHeight();
        }
        return (int)(this.adjustedWeight * (this.hallmarkBalance / 100000000L) / 1000000000L);
    }

    @Override
    public boolean isBlacklisted() {
        return this.blacklistingTime > 0 || this.isOldVersion || Peers.knownBlacklistedPeers.contains(this.host) || this.announcedAddress != null && Peers.knownBlacklistedPeers.contains(this.announcedAddress);
    }

    @Override
    public void blacklist(Exception exception) {
        if (exception instanceof NxtException.NotCurrentlyValidException || exception instanceof BlockchainProcessor.BlockOutOfOrderException || exception instanceof SQLException || exception.getCause() instanceof SQLException) {
            return;
        }
        if (exception instanceof ParseException && "Unexpected token END OF FILE at position 0.".equals(exception.toString())) {
            return;
        }
        if (!this.isBlacklisted()) {
            if (exception instanceof IOException || exception instanceof ParseException || exception instanceof IllegalArgumentException) {
                Logger.logDebugMessage("Blacklisting " + this.host + " because of: " + exception.toString());
            } else {
                Logger.logDebugMessage("Blacklisting " + this.host + " because of: " + exception.toString(), exception);
            }
        }
        this.blacklist(exception.toString() == null || Peers.hideErrorDetails ? exception.getClass().getName() : exception.toString());
    }

    @Override
    public void blacklist(String string) {
        this.blacklistingTime = Nxt.getEpochTime();
        this.blacklistingCause = string;
        this.setState(Peer.State.NON_CONNECTED);
        this.lastInboundRequest = 0;
        Peers.notifyListeners(this, Peers.Event.BLACKLIST);
    }

    @Override
    public void unBlacklist() {
        if (this.blacklistingTime == 0) {
            return;
        }
        Logger.logDebugMessage("Unblacklisting " + this.host);
        this.setState(Peer.State.NON_CONNECTED);
        this.blacklistingTime = 0;
        this.blacklistingCause = null;
        Peers.notifyListeners(this, Peers.Event.UNBLACKLIST);
    }

    void updateBlacklistedStatus(int n) {
        if (this.blacklistingTime > 0 && this.blacklistingTime + Peers.blacklistingPeriod <= n) {
            this.unBlacklist();
        }
        if (this.isOldVersion && this.lastUpdated < n - 3600) {
            this.isOldVersion = false;
        }
    }

    @Override
    public void deactivate() {
        if (this.state == Peer.State.CONNECTED) {
            this.setState(Peer.State.DISCONNECTED);
        } else {
            this.setState(Peer.State.NON_CONNECTED);
        }
        Peers.notifyListeners(this, Peers.Event.DEACTIVATE);
    }

    @Override
    public void remove() {
        this.webSocket.close();
        Peers.removePeer(this);
        Peers.notifyListeners(this, Peers.Event.REMOVE);
    }

    @Override
    public int getLastUpdated() {
        return this.lastUpdated;
    }

    void setLastUpdated(int n) {
        this.lastUpdated = n;
    }

    @Override
    public boolean isInbound() {
        return this.lastInboundRequest != 0;
    }

    int getLastInboundRequest() {
        return this.lastInboundRequest;
    }

    void setLastInboundRequest(int n) {
        this.lastInboundRequest = n;
    }

    void setInboundWebSocket(PeerWebSocket peerWebSocket) {
        this.inboundSocket = peerWebSocket;
    }

    @Override
    public boolean isInboundWebSocket() {
        PeerWebSocket peerWebSocket = this.inboundSocket;
        return peerWebSocket != null && peerWebSocket.isOpen();
    }

    @Override
    public boolean isOutboundWebSocket() {
        return this.webSocket.isOpen();
    }

    @Override
    public String getBlacklistingCause() {
        return this.blacklistingCause == null ? "unknown" : this.blacklistingCause;
    }

    @Override
    public int getLastConnectAttempt() {
        return this.lastConnectAttempt;
    }

    @Override
    public JSONObject send(JSONStreamAware jSONStreamAware) {
        return this.send(jSONStreamAware, Peers.MAX_RESPONSE_SIZE);
    }

    @Override
    public JSONObject send(JSONStreamAware jSONStreamAware, int n) {
        boolean bl;
        String string;
        JSONObject jSONObject;
        block48: {
            jSONObject = null;
            string = null;
            bl = false;
            HttpURLConnection httpURLConnection = null;
            int n2 = Peers.communicationLoggingMask;
            try {
                Object object;
                if (this.useWebSocket && !this.webSocket.isOpen()) {
                    this.useWebSocket = this.webSocket.startClient(URI.create("ws://" + this.host + ":" + this.getPort() + "/nxt"));
                }
                if (this.useWebSocket) {
                    object = new StringWriter(1000);
                    jSONStreamAware.writeJSONString((Writer)object);
                    String string2 = ((StringWriter)object).toString();
                    if (n2 != 0) {
                        string = "WebSocket " + this.host + ": " + string2;
                    }
                    String string3 = this.webSocket.doPost(string2);
                    this.updateUploadedVolume(string2.length());
                    if (n > 0) {
                        if ((n2 & 4) != 0) {
                            string = (String)string + " >>> " + string3;
                            bl = true;
                        }
                        if (string3.length() > n) {
                            throw new NxtException.NxtIOException("Maximum size exceeded: " + string3.length());
                        }
                        jSONObject = (JSONObject)JSONValue.parseWithException((String)string3);
                        this.updateDownloadedVolume(string3.length());
                    }
                } else {
                    Closeable closeable;
                    object = new URL("http://" + this.host + ":" + this.getPort() + "/nxt");
                    if (n2 != 0) {
                        string = "\"" + ((URL)object).toString() + "\": " + JSON.toString(jSONStreamAware);
                    }
                    httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setConnectTimeout(Peers.connectTimeout);
                    httpURLConnection.setReadTimeout(Peers.readTimeout);
                    httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
                    httpURLConnection.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
                    try (Closeable closeable2 = new BufferedWriter(new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8"));){
                        closeable = new CountingOutputWriter((Writer)closeable2);
                        jSONStreamAware.writeJSONString((Writer)closeable);
                        this.updateUploadedVolume(((CountingOutputWriter)closeable).getCount());
                    }
                    if (httpURLConnection.getResponseCode() == 200) {
                        if (n > 0) {
                            if ((n2 & 4) != 0) {
                                closeable = closeable2 = new CountingInputStream(httpURLConnection.getInputStream(), n);
                                if ("gzip".equals(httpURLConnection.getHeaderField("Content-Encoding"))) {
                                    closeable = new GZIPInputStream((InputStream)closeable2);
                                }
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                byte[] byArray = new byte[1024];
                                try (Object object2 = closeable;){
                                    int n3;
                                    while ((n3 = ((InputStream)object2).read(byArray, 0, byArray.length)) > 0) {
                                        byteArrayOutputStream.write(byArray, 0, n3);
                                    }
                                }
                                object2 = byteArrayOutputStream.toString("UTF-8");
                                if (((String)object2).length() > 0 && closeable instanceof GZIPInputStream) {
                                    string = (String)string + String.format("[length: %d, compression ratio: %.2f]", ((CountingInputStream)closeable2).getCount(), (double)((CountingInputStream)closeable2).getCount() / (double)((String)object2).length());
                                }
                                string = (String)string + " >>> " + (String)object2;
                                bl = true;
                                jSONObject = (JSONObject)JSONValue.parseWithException((String)object2);
                                this.updateDownloadedVolume(((String)object2).length());
                            } else {
                                closeable2 = httpURLConnection.getInputStream();
                                if ("gzip".equals(httpURLConnection.getHeaderField("Content-Encoding"))) {
                                    closeable2 = new GZIPInputStream((InputStream)closeable2);
                                }
                                closeable = new BufferedReader(new InputStreamReader((InputStream)closeable2, "UTF-8"));
                                try {
                                    CountingInputReader countingInputReader = new CountingInputReader((Reader)closeable, n);
                                    jSONObject = (JSONObject)JSONValue.parseWithException((Reader)countingInputReader);
                                    this.updateDownloadedVolume(countingInputReader.getCount());
                                }
                                finally {
                                    ((Reader)closeable).close();
                                }
                            }
                        }
                    } else {
                        if ((n2 & 2) != 0) {
                            string = (String)string + " >>> Peer responded with HTTP " + httpURLConnection.getResponseCode() + " code!";
                            bl = true;
                        }
                        Logger.logDebugMessage("Peer " + this.host + " responded with HTTP " + httpURLConnection.getResponseCode());
                        this.deactivate();
                        httpURLConnection.disconnect();
                    }
                }
                if (jSONObject != null && jSONObject.get((Object)"error") != null) {
                    object = jSONObject.get((Object)"error");
                    if ("Peer request received before 'getInfo' request".equals(object) && jSONStreamAware != Peers.getMyPeerInfoRequest()) {
                        Logger.logDebugMessage("Sequence error, reconnecting to " + this.host);
                        this.deactivate();
                        this.connect();
                    } else if (!"Blockchain download in progress".equals(object) && !"Peer is in light mode".equals(object)) {
                        this.deactivate();
                        Logger.logDebugMessage("Peer " + this.host + " version " + this.version + " returned error: " + jSONObject.toJSONString() + ", request was: " + JSON.toString(jSONStreamAware) + ", disconnecting");
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                    }
                }
            }
            catch (NxtException.NxtIOException nxtIOException) {
                this.blacklist(nxtIOException);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (IOException | RuntimeException | ParseException throwable) {
                if (!(throwable instanceof UnknownHostException || throwable instanceof SocketTimeoutException || throwable instanceof SocketException || "Unexpected token END OF FILE at position 0.".equals(throwable.getMessage()))) {
                    Logger.logDebugMessage(String.format("Error sending request to peer %s: %s", this.host, throwable.getMessage() != null ? throwable.getMessage() : throwable.toString()));
                }
                if ((n2 & 1) != 0) {
                    string = string + " >>> " + throwable.toString();
                    bl = true;
                }
                this.deactivate();
                if (httpURLConnection == null) break block48;
                httpURLConnection.disconnect();
            }
        }
        if (bl) {
            Logger.logMessage(string + "\n");
        }
        return jSONObject;
    }

    @Override
    public int compareTo(Peer peer) {
        if (this.getWeight() > peer.getWeight()) {
            return -1;
        }
        if (this.getWeight() < peer.getWeight()) {
            return 1;
        }
        return this.getHost().compareTo(peer.getHost());
    }

    void connect() {
        this.lastConnectAttempt = Nxt.getEpochTime();
        try {
            Object object;
            Object object2;
            if (!Peers.ignorePeerAnnouncedAddress && this.announcedAddress != null) {
                try {
                    object2 = new URI("http://" + this.announcedAddress);
                    object = InetAddress.getByName(((URI)object2).getHost());
                    if (!((InetAddress)object).equals(InetAddress.getByName(this.host))) {
                        Logger.logDebugMessage("Connect: announced address " + this.announcedAddress + " now points to " + ((InetAddress)object).getHostAddress() + ", replacing peer " + this.host);
                        Peers.removePeer(this);
                        PeerImpl peerImpl = Peers.findOrCreatePeer((InetAddress)object, this.announcedAddress, true);
                        if (peerImpl != null) {
                            Peers.addPeer(peerImpl);
                            peerImpl.connect();
                        }
                        return;
                    }
                }
                catch (URISyntaxException | UnknownHostException exception) {
                    this.blacklist(exception);
                    return;
                }
            }
            if ((object2 = this.send(Peers.getMyPeerInfoRequest())) != null) {
                if (object2.get((Object)"error") != null) {
                    this.setState(Peer.State.NON_CONNECTED);
                    return;
                }
                object = (String)object2.get((Object)"services");
                long l = this.services;
                this.services = object != null ? Long.parseUnsignedLong((String)object) : 0L;
                this.setApplication((String)object2.get((Object)"application"));
                this.setApiPort(object2.get((Object)"apiPort"));
                this.setApiSSLPort(object2.get((Object)"apiSSLPort"));
                this.setDisabledAPIs(object2.get((Object)"disabledAPIs"));
                this.setApiServerIdleTimeout(object2.get((Object)"apiServerIdleTimeout"));
                this.setBlockchainState(object2.get((Object)"blockchainState"));
                this.lastUpdated = this.lastConnectAttempt;
                this.setVersion((String)object2.get((Object)"version"));
                this.setPlatform((String)object2.get((Object)"platform"));
                this.shareAddress = Boolean.TRUE.equals(object2.get((Object)"shareAddress"));
                this.analyzeHallmark((String)object2.get((Object)"hallmark"));
                if (!Peers.ignorePeerAnnouncedAddress) {
                    String string = Convert.emptyToNull((String)object2.get((Object)"announcedAddress"));
                    if (string != null) {
                        if ((string = Peers.addressWithPort(string.toLowerCase())) != null) {
                            if (!this.verifyAnnouncedAddress(string)) {
                                Logger.logDebugMessage("Connect: new announced address for " + this.host + " not accepted");
                                if (!this.verifyAnnouncedAddress(this.announcedAddress)) {
                                    Logger.logDebugMessage("Connect: old announced address for " + this.host + " no longer valid");
                                    Peers.setAnnouncedAddress(this, this.host);
                                }
                                this.setState(Peer.State.NON_CONNECTED);
                                return;
                            }
                            if (!string.equals(this.announcedAddress)) {
                                Logger.logDebugMessage("Connect: peer " + this.host + " has new announced address " + string + ", old is " + this.announcedAddress);
                                int n = this.getPort();
                                Peers.setAnnouncedAddress(this, string);
                                if (this.getPort() != n) {
                                    this.setState(Peer.State.NON_CONNECTED);
                                    return;
                                }
                            }
                        }
                    } else {
                        Peers.setAnnouncedAddress(this, this.host);
                    }
                }
                if (this.announcedAddress == null) {
                    if (this.hallmark == null || this.hallmark.getPort() == Peers.getDefaultPeerPort()) {
                        Peers.setAnnouncedAddress(this, this.host);
                        Logger.logDebugMessage("Connected to peer without announced address, setting to " + this.host);
                    } else {
                        this.setState(Peer.State.NON_CONNECTED);
                        return;
                    }
                }
                if (!this.isOldVersion) {
                    this.setState(Peer.State.CONNECTED);
                    if (this.services != l) {
                        Peers.notifyListeners(this, Peers.Event.CHANGED_SERVICES);
                    }
                } else if (!this.isBlacklisted()) {
                    this.blacklist("Old version: " + this.version);
                }
            } else {
                this.setState(Peer.State.NON_CONNECTED);
            }
        }
        catch (RuntimeException runtimeException) {
            this.blacklist(runtimeException);
        }
    }

    boolean verifyAnnouncedAddress(String string) {
        if (string == null) {
            return true;
        }
        try {
            int n;
            URI uRI = new URI("http://" + string);
            int n2 = n = uRI.getPort() == -1 ? Peers.getDefaultPeerPort() : uRI.getPort();
            if (this.hallmark != null && n != this.hallmark.getPort()) {
                Logger.logDebugMessage("Announced port " + n + " does not match hallmark " + this.hallmark.getPort() + ", ignoring hallmark for " + this.host);
                this.unsetHallmark();
            }
            InetAddress inetAddress = InetAddress.getByName(this.host);
            for (InetAddress inetAddress2 : InetAddress.getAllByName(uRI.getHost())) {
                if (!inetAddress2.equals(inetAddress)) continue;
                return true;
            }
            Logger.logDebugMessage("Announced address " + string + " does not resolve to " + this.host);
        }
        catch (URISyntaxException | UnknownHostException exception) {
            Logger.logDebugMessage(exception.toString());
            this.blacklist(exception);
        }
        return false;
    }

    boolean analyzeHallmark(String string) {
        if (Constants.isLightClient) {
            return true;
        }
        if (string == null && this.hallmark == null) {
            return true;
        }
        if (this.hallmark != null && this.hallmark.getHallmarkString().equals(string)) {
            return true;
        }
        if (string == null) {
            this.unsetHallmark();
            return true;
        }
        try {
            Hallmark hallmark = Hallmark.parseHallmark(string);
            if (!hallmark.isValid()) {
                Logger.logDebugMessage("Invalid hallmark " + string + " for " + this.host);
                this.unsetHallmark();
                return false;
            }
            if (!hallmark.getHost().equals(this.host)) {
                InetAddress inetAddress = InetAddress.getByName(this.host);
                boolean bl = false;
                for (InetAddress inetAddress2 : InetAddress.getAllByName(hallmark.getHost())) {
                    if (!inetAddress.equals(inetAddress2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    Logger.logDebugMessage("Hallmark host " + hallmark.getHost() + " doesn't match " + this.host);
                    this.unsetHallmark();
                    return false;
                }
            }
            this.setHallmark(hallmark);
            long l = Account.getId(hallmark.getPublicKey());
            ArrayList arrayList = new ArrayList();
            int n = 0;
            long l2 = 0L;
            for (PeerImpl peerImpl : Peers.allPeers) {
                if (peerImpl.hallmark == null || l != peerImpl.hallmark.getAccountId()) continue;
                arrayList.add(peerImpl);
                if (peerImpl.hallmark.getDate() > n) {
                    n = peerImpl.hallmark.getDate();
                    l2 = peerImpl.getHallmarkWeight(n);
                    continue;
                }
                l2 += (long)peerImpl.getHallmarkWeight(n);
            }
            Iterator<PeerImpl> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                PeerImpl peerImpl;
                peerImpl = iterator.next();
                peerImpl.adjustedWeight = 1000000000L * (long)peerImpl.getHallmarkWeight(n) / l2;
                Peers.notifyListeners(peerImpl, Peers.Event.WEIGHT);
            }
            return true;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (RuntimeException runtimeException) {
            Logger.logDebugMessage("Failed to analyze hallmark for peer " + this.host + ", " + runtimeException.toString(), runtimeException);
        }
        this.unsetHallmark();
        return false;
    }

    private int getHallmarkWeight(int n) {
        if (this.hallmark == null || !this.hallmark.isValid() || this.hallmark.getDate() != n) {
            return 0;
        }
        return this.hallmark.getWeight();
    }

    private void unsetHallmark() {
        this.removeService(Peer.Service.HALLMARK, false);
        this.hallmark = null;
    }

    private void setHallmark(Hallmark hallmark) {
        this.hallmark = hallmark;
        this.addService(Peer.Service.HALLMARK, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addService(Peer.Service service, boolean bl) {
        boolean bl2;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            bl2 = (this.services & service.getCode()) == 0L;
            this.services |= service.getCode();
        }
        if (bl2 && bl) {
            Peers.notifyListeners(this, Peers.Event.CHANGED_SERVICES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeService(Peer.Service service, boolean bl) {
        boolean bl2;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            bl2 = (this.services & service.getCode()) != 0L;
            this.services &= service.getCode() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (bl2 && bl) {
            Peers.notifyListeners(this, Peers.Event.CHANGED_SERVICES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getServices() {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            return this.services;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServices(long l) {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            this.services = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean providesService(Peer.Service service) {
        boolean bl;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            bl = (this.services & service.getCode()) != 0L;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean providesServices(long l) {
        boolean bl;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            bl = (l & this.services) == l;
        }
        return bl;
    }

    @Override
    public boolean isOpenAPI() {
        return this.providesService(Peer.Service.API) || this.providesService(Peer.Service.API_SSL);
    }

    @Override
    public boolean isApiConnectable() {
        return this.isOpenAPI() && this.state == Peer.State.CONNECTED && !Peers.isOldVersion(this.version, Constants.MIN_PROXY_VERSION) && !Peers.isNewVersion(this.version) && (this.blockchainState == Peer.BlockchainState.UP_TO_DATE || this.blockchainState == Peer.BlockchainState.FORK);
    }

    @Override
    public StringBuilder getPeerApiUri() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.providesService(Peer.Service.API_SSL)) {
            stringBuilder.append("https://");
        } else {
            stringBuilder.append("http://");
        }
        stringBuilder.append(this.host).append(":");
        if (this.providesService(Peer.Service.API_SSL)) {
            stringBuilder.append(this.apiSSLPort);
        } else {
            stringBuilder.append(this.apiPort);
        }
        return stringBuilder;
    }

    public String toString() {
        return "Peer{state=" + this.state + ", announcedAddress='" + this.announcedAddress + "', services=" + this.services + ", host='" + this.host + "', version='" + this.version + "'}";
    }
}

