/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.util.Set;
import nxt.http.APIEnum;
import nxt.peer.Hallmark;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public interface Peer
extends Comparable<Peer> {
    public boolean providesService(Service var1);

    public boolean providesServices(long var1);

    public String getHost();

    public int getPort();

    public String getAnnouncedAddress();

    public State getState();

    public String getVersion();

    public String getApplication();

    public String getPlatform();

    public String getSoftware();

    public int getApiPort();

    public int getApiSSLPort();

    public Set<APIEnum> getDisabledAPIs();

    public int getApiServerIdleTimeout();

    public BlockchainState getBlockchainState();

    public Hallmark getHallmark();

    public int getWeight();

    public boolean shareAddress();

    public boolean isBlacklisted();

    public void blacklist(Exception var1);

    public void blacklist(String var1);

    public void unBlacklist();

    public void deactivate();

    public void remove();

    public long getDownloadedVolume();

    public long getUploadedVolume();

    public int getLastUpdated();

    public int getLastConnectAttempt();

    public boolean isInbound();

    public boolean isInboundWebSocket();

    public boolean isOutboundWebSocket();

    public boolean isOpenAPI();

    public boolean isApiConnectable();

    public StringBuilder getPeerApiUri();

    public String getBlacklistingCause();

    public JSONObject send(JSONStreamAware var1);

    public JSONObject send(JSONStreamAware var1, int var2);

    public static enum BlockchainState {
        UP_TO_DATE,
        DOWNLOADING,
        LIGHT_CLIENT,
        FORK;


        public static BlockchainState get(Number number) {
            int n = number.intValue();
            if (n >= 0 && n < BlockchainState.values().length) {
                return BlockchainState.values()[n];
            }
            return null;
        }

        public static BlockchainState get(String string) {
            try {
                return BlockchainState.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public static enum Service {
        HALLMARK(1),
        PRUNABLE(2),
        API(4),
        API_SSL(8),
        CORS(16);

        private final long code;

        private Service(int n2) {
            this.code = n2;
        }

        public long getCode() {
            return this.code;
        }
    }

    public static enum State {
        NON_CONNECTED,
        CONNECTED,
        DISCONNECTED;

    }
}

