/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import nxt.Nxt;
import nxt.peer.Peer;
import nxt.peer.PeerImpl;
import nxt.peer.PeerServlet;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

final class GetInfo
extends PeerServlet.PeerRequestHandler {
    static final GetInfo instance = new GetInfo();
    private static final JSONStreamAware INVALID_ANNOUNCED_ADDRESS;

    private GetInfo() {
    }

    @Override
    JSONStreamAware processRequest(JSONObject jSONObject, Peer peer) {
        String string;
        PeerImpl peerImpl = (PeerImpl)peer;
        peerImpl.setLastUpdated(Nxt.getEpochTime());
        long l = peerImpl.getServices();
        String string2 = (String)jSONObject.get((Object)"services");
        peerImpl.setServices(string2 != null ? Long.parseUnsignedLong(string2) : 0L);
        peerImpl.analyzeHallmark((String)jSONObject.get((Object)"hallmark"));
        if (!Peers.ignorePeerAnnouncedAddress && (string = Convert.emptyToNull((String)jSONObject.get((Object)"announcedAddress"))) != null) {
            if ((string = Peers.addressWithPort(string.toLowerCase())) != null) {
                if (!peerImpl.verifyAnnouncedAddress(string)) {
                    Logger.logDebugMessage("GetInfo: ignoring invalid announced address for " + peerImpl.getHost());
                    if (!peerImpl.verifyAnnouncedAddress(peerImpl.getAnnouncedAddress())) {
                        Logger.logDebugMessage("GetInfo: old announced address for " + peerImpl.getHost() + " no longer valid");
                        Peers.setAnnouncedAddress(peerImpl, null);
                    }
                    peerImpl.setState(Peer.State.NON_CONNECTED);
                    return INVALID_ANNOUNCED_ADDRESS;
                }
                if (!string.equals(peerImpl.getAnnouncedAddress())) {
                    Logger.logDebugMessage("GetInfo: peer " + peer.getHost() + " changed announced address from " + peer.getAnnouncedAddress() + " to " + string);
                    int n = peerImpl.getPort();
                    Peers.setAnnouncedAddress(peerImpl, string);
                    if (peerImpl.getPort() != n) {
                        peerImpl.setState(Peer.State.NON_CONNECTED);
                    }
                }
            } else {
                Peers.setAnnouncedAddress(peerImpl, null);
            }
        }
        if ((string = (String)jSONObject.get((Object)"application")) == null) {
            string = "?";
        }
        peerImpl.setApplication(string.trim());
        String string3 = (String)jSONObject.get((Object)"version");
        if (string3 == null) {
            string3 = "?";
        }
        peerImpl.setVersion(string3.trim());
        String string4 = (String)jSONObject.get((Object)"platform");
        if (string4 == null) {
            string4 = "?";
        }
        peerImpl.setPlatform(string4.trim());
        peerImpl.setShareAddress(Boolean.TRUE.equals(jSONObject.get((Object)"shareAddress")));
        peerImpl.setApiPort(jSONObject.get((Object)"apiPort"));
        peerImpl.setApiSSLPort(jSONObject.get((Object)"apiSSLPort"));
        peerImpl.setDisabledAPIs(jSONObject.get((Object)"disabledAPIs"));
        peerImpl.setApiServerIdleTimeout(jSONObject.get((Object)"apiServerIdleTimeout"));
        peerImpl.setBlockchainState(jSONObject.get((Object)"blockchainState"));
        if (peerImpl.getServices() != l) {
            Peers.notifyListeners(peerImpl, Peers.Event.CHANGED_SERVICES);
        }
        return Peers.getMyPeerInfoResponse();
    }

    @Override
    boolean rejectWhileDownloading() {
        return false;
    }

    static {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"error", (Object)"Invalid announced address");
        INVALID_ANNOUNCED_ADDRESS = JSON.prepare(jSONObject);
    }
}

