/*
 * Decompiled with CFR 0.152.
 */
package nxt.mint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.HttpsURLConnection;
import nxt.Attachment;
import nxt.Constants;
import nxt.CurrencyMinting;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.crypto.Crypto;
import nxt.crypto.HashFunction;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.TrustAllSSLProvider;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class MintWorker {
    public static void main(String[] stringArray) {
        MintWorker mintWorker = new MintWorker();
        mintWorker.mint();
    }

    private void mint() {
        int n;
        String string = Convert.emptyToNull(Nxt.getStringProperty("nxt.mint.currencyCode"));
        if (string == null) {
            throw new IllegalArgumentException("nxt.mint.currencyCode not specified");
        }
        String string2 = Convert.emptyToNull(Nxt.getStringProperty("nxt.mint.secretPhrase", null, true));
        if (string2 == null) {
            throw new IllegalArgumentException("nxt.mint.secretPhrase not specified");
        }
        boolean bl = Nxt.getBooleanProperty("nxt.mint.isSubmitted");
        boolean bl2 = Nxt.getBooleanProperty("nxt.mint.stopOnError");
        byte[] byArray = Crypto.sha256().digest(Crypto.getPublicKey(string2));
        long l = Convert.fullHashToId(byArray);
        String string3 = Convert.rsAccount(l);
        JSONObject jSONObject = this.getCurrency(string);
        if (jSONObject.get((Object)"currency") == null) {
            throw new IllegalArgumentException("Invalid currency code " + string);
        }
        long l2 = Convert.parseUnsignedLong((String)jSONObject.get((Object)"currency"));
        if (jSONObject.get((Object)"algorithm") == null) {
            throw new IllegalArgumentException("Minting algorithm not specified, currency " + string + " is not mintable");
        }
        byte by = (byte)((Long)jSONObject.get((Object)"algorithm")).longValue();
        byte by2 = (byte)((Long)jSONObject.get((Object)"decimals")).longValue();
        String string4 = Nxt.getStringProperty("nxt.mint.unitsPerMint");
        double d = 1.0;
        if (string4 != null && string4.length() > 0) {
            d = Double.parseDouble(string4);
        }
        long l3 = (long)(d * Math.pow(10.0, by2));
        JSONObject jSONObject2 = this.getMintingTarget(l2, string3, l3);
        long l4 = (Long)jSONObject2.get((Object)"counter");
        byte[] byArray2 = Convert.parseHexString((String)jSONObject2.get((Object)"targetBytes"));
        BigInteger bigInteger = new BigInteger((String)jSONObject2.get((Object)"difficulty"));
        long l5 = Nxt.getIntProperty("nxt.mint.initialNonce");
        if (l5 == 0L) {
            l5 = new Random().nextLong();
        }
        if ((n = Nxt.getIntProperty("nxt.mint.threadPoolSize")) == 0) {
            n = Runtime.getRuntime().availableProcessors();
            Logger.logDebugMessage("Thread pool size " + n);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        Logger.logInfoMessage("Mint worker started");
        while (true) {
            ++l4;
            try {
                JSONObject jSONObject3 = this.mintImpl(string2, l, l3, l2, by, l4, byArray2, l5, n, executorService, bigInteger, bl);
                Logger.logInfoMessage("currency mint response:" + jSONObject3.toJSONString());
            }
            catch (Exception exception) {
                Logger.logInfoMessage("mint error", exception);
                if (bl2) {
                    Logger.logInfoMessage("stopping on error");
                    break;
                }
                Logger.logInfoMessage("continue");
            }
            jSONObject2 = this.getMintingTarget(l2, string3, l3);
            byArray2 = Convert.parseHexString((String)jSONObject2.get((Object)"targetBytes"));
            bigInteger = new BigInteger((String)jSONObject2.get((Object)"difficulty"));
        }
    }

    private JSONObject mintImpl(String string, long l, long l2, long l3, byte by, long l4, byte[] byArray, long l5, int n, ExecutorService executorService, BigInteger bigInteger, boolean bl) {
        JSONObject jSONObject;
        long l6 = System.currentTimeMillis();
        ArrayList<Callable<Long>> arrayList = new ArrayList<Callable<Long>>();
        for (int i = 0; i < n; ++i) {
            HashSolver hashSolver = new HashSolver(by, l3, l, l4, l2, l5 + (long)i, byArray, n);
            arrayList.add(hashSolver);
        }
        long l7 = this.solve(executorService, arrayList);
        long l8 = System.currentTimeMillis() - l6;
        if (l8 == 0L) {
            l8 = 1L;
        }
        long l9 = l7 - l5;
        float f = BigInteger.valueOf(-1L).equals(bigInteger) ? 0.0f : (float)l9 / bigInteger.floatValue();
        Logger.logInfoMessage("solution nonce %d unitsNQT %d counter %d computed hashes %d time [sec] %.2f hash rate [KH/Sec] %d actual time vs. expected %.2f is submitted %b", l7, l2, l4, l9, Float.valueOf((float)l8 / 1000.0f), l9 / l8, Float.valueOf(f), bl);
        if (bl) {
            jSONObject = this.currencyMint(string, l3, l7, l2, l4);
        } else {
            jSONObject = new JSONObject();
            jSONObject.put((Object)"message", (Object)"nxt.mint.isSubmitted=false therefore currency mint transaction is not submitted");
        }
        return jSONObject;
    }

    private long solve(Executor executor, Collection<Callable<Long>> collection) {
        ExecutorCompletionService executorCompletionService = new ExecutorCompletionService(executor);
        ArrayList arrayList = new ArrayList(collection.size());
        collection.forEach(callable -> arrayList.add(executorCompletionService.submit(callable)));
        try {
            long l = (Long)executorCompletionService.take().get();
            return l;
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            for (Future future : arrayList) {
                future.cancel(true);
            }
        }
    }

    private JSONObject currencyMint(String string, long l, long l2, long l3, long l4) {
        JSONObject jSONObject = this.getECBlock();
        Attachment.MonetarySystemCurrencyMinting monetarySystemCurrencyMinting = new Attachment.MonetarySystemCurrencyMinting(l2, l, l3, l4);
        Transaction.Builder builder = Nxt.newTransactionBuilder(Crypto.getPublicKey(string), 0L, 100000000L, (short)120, monetarySystemCurrencyMinting).timestamp(((Long)jSONObject.get((Object)"timestamp")).intValue()).ecBlockHeight(((Long)jSONObject.get((Object)"ecBlockHeight")).intValue()).ecBlockId(Convert.parseUnsignedLong((String)jSONObject.get((Object)"ecBlockId")));
        try {
            Transaction transaction = builder.build(string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("requestType", "broadcastTransaction");
            hashMap.put("transactionBytes", Convert.toHexString(transaction.getBytes()));
            return this.getJsonResponse(hashMap);
        }
        catch (NxtException.NotValidException notValidException) {
            Logger.logInfoMessage("local signing failed", notValidException);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put((Object)"error", (Object)notValidException.toString());
            return jSONObject2;
        }
    }

    private JSONObject getCurrency(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("requestType", "getCurrency");
        hashMap.put("code", string);
        return this.getJsonResponse(hashMap);
    }

    private JSONObject getMintingTarget(long l, String string, long l2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("requestType", "getMintingTarget");
        hashMap.put("currency", Long.toUnsignedString(l));
        hashMap.put("account", string);
        hashMap.put("units", Long.toString(l2));
        return this.getJsonResponse(hashMap);
    }

    private JSONObject getECBlock() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("requestType", "getECBlock");
        return this.getJsonResponse(hashMap);
    }

    private JSONObject getJsonResponse(Map<String, String> map) {
        JSONObject jSONObject;
        URL uRL;
        block18: {
            HttpURLConnection httpURLConnection = null;
            String string = Convert.emptyToNull(Nxt.getStringProperty("nxt.mint.serverAddress"));
            if (string == null) {
                try {
                    string = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "localhost";
                }
            }
            String string2 = "http";
            boolean bl = Nxt.getBooleanProperty("nxt.mint.useHttps");
            if (bl) {
                string2 = "https";
                HttpsURLConnection.setDefaultSSLSocketFactory(TrustAllSSLProvider.getSslSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(TrustAllSSLProvider.getHostNameVerifier());
            }
            int n = Constants.isTestnet ? 6876 : Nxt.getIntProperty("nxt.apiServerPort");
            String string3 = MintWorker.getUrlParams(map);
            try {
                uRL = new URL(string2, string, n, "/nxt?" + string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalStateException(malformedURLException);
            }
            try {
                Logger.logDebugMessage("Sending request to server: " + uRL.toString());
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                if (httpURLConnection.getResponseCode() == 200) {
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));){
                        jSONObject = (JSONObject)JSONValue.parse((Reader)bufferedReader);
                        break block18;
                    }
                }
                jSONObject = null;
            }
            catch (IOException | RuntimeException exception) {
                Logger.logInfoMessage("Error connecting to server", exception);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                throw new IllegalStateException(exception);
            }
        }
        if (jSONObject == null) {
            throw new IllegalStateException(String.format("Request %s response error", uRL));
        }
        if (jSONObject.get((Object)"errorCode") != null) {
            throw new IllegalStateException(String.format("Request %s produced error response code %s message \"%s\"", uRL, jSONObject.get((Object)"errorCode"), jSONObject.get((Object)"errorDescription")));
        }
        if (jSONObject.get((Object)"error") != null) {
            throw new IllegalStateException(String.format("Request %s produced error %s", uRL, jSONObject.get((Object)"error")));
        }
        return jSONObject;
    }

    private static String getUrlParams(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : map.keySet()) {
            try {
                stringBuilder.append(string).append("=").append(URLEncoder.encode(map.get(string), "utf8")).append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException(unsupportedEncodingException);
            }
        }
        Object object = stringBuilder.toString();
        if (((String)object).endsWith("&")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return object;
    }

    private static class HashSolver
    implements Callable<Long> {
        private final HashFunction hashFunction;
        private final long currencyId;
        private final long accountId;
        private final long counter;
        private final long units;
        private final long nonce;
        private final byte[] target;
        private final int poolSize;

        private HashSolver(byte by, long l, long l2, long l3, long l4, long l5, byte[] byArray, int n) {
            this.hashFunction = HashFunction.getHashFunction(by);
            this.currencyId = l;
            this.accountId = l2;
            this.counter = l3;
            this.units = l4;
            this.nonce = l5;
            this.target = byArray;
            this.poolSize = n;
        }

        @Override
        public Long call() {
            long l = this.nonce;
            while (!Thread.currentThread().isInterrupted()) {
                byte[] byArray = CurrencyMinting.getHash(this.hashFunction, l, this.currencyId, this.units, this.counter, this.accountId);
                if (CurrencyMinting.meetsTarget(byArray, this.target)) {
                    Logger.logDebugMessage("%s found solution hash %s nonce %d currencyId %d units %d counter %d accountId %d hash %s meets target %s", new Object[]{Thread.currentThread().getName(), this.hashFunction, l, this.currencyId, this.units, this.counter, this.accountId, Arrays.toString(byArray), Arrays.toString(this.target)});
                    return l;
                }
                if (((l += (long)this.poolSize) - this.nonce) % (long)(this.poolSize * 1000000) != 0L) continue;
                Logger.logInfoMessage("%s computed %d [MH]", Thread.currentThread().getName(), (l - this.nonce) / (long)this.poolSize / 1000000L);
            }
            return null;
        }
    }
}

