/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Asset;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class PlaceBidOrder
extends CreateTransaction {
    static final PlaceBidOrder instance = new PlaceBidOrder();

    private PlaceBidOrder() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "asset", "quantityQNT", "priceNQT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        long l = ParameterParser.getPriceNQT(httpServletRequest);
        long l2 = ParameterParser.getQuantityQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.ColoredCoinsBidOrderPlacement coloredCoinsBidOrderPlacement = new Attachment.ColoredCoinsBidOrderPlacement(asset.getId(), l2, l);
        try {
            return this.createTransaction(httpServletRequest, account, coloredCoinsBidOrderPlacement);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }
}

