/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Asset;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class PlaceAskOrder
extends CreateTransaction {
    static final PlaceAskOrder instance = new PlaceAskOrder();

    private PlaceAskOrder() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "asset", "quantityQNT", "priceNQT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        long l = ParameterParser.getPriceNQT(httpServletRequest);
        long l2 = ParameterParser.getQuantityQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.ColoredCoinsAskOrderPlacement coloredCoinsAskOrderPlacement = new Attachment.ColoredCoinsAskOrderPlacement(asset.getId(), l2, l);
        try {
            return this.createTransaction(httpServletRequest, account, coloredCoinsAskOrderPlacement);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_ASSETS;
        }
    }
}

