/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.peer.Hallmark;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class MarkHost
extends APIServlet.APIRequestHandler {
    static final MarkHost instance = new MarkHost();

    private MarkHost() {
        super(new APITag[]{APITag.TOKENS}, "secretPhrase", "host", "weight", "date");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        int n;
        String string = ParameterParser.getSecretPhrase(httpServletRequest, true);
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("host"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("weight"));
        String string4 = Convert.emptyToNull(httpServletRequest.getParameter("date"));
        if (string2 == null) {
            return JSONResponses.MISSING_HOST;
        }
        if (string3 == null) {
            return JSONResponses.MISSING_WEIGHT;
        }
        if (string4 == null) {
            return JSONResponses.MISSING_DATE;
        }
        if (string2.length() > 100) {
            return JSONResponses.INCORRECT_HOST;
        }
        try {
            n = Integer.parseInt(string3);
            if (n <= 0 || (long)n > 1000000000L) {
                return JSONResponses.INCORRECT_WEIGHT;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return JSONResponses.INCORRECT_WEIGHT;
        }
        try {
            String string5 = Hallmark.generateHallmark(string, string2, n, Hallmark.parseDate(string4));
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"hallmark", (Object)string5);
            return jSONObject;
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_DATE;
        }
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }
}

