/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.Transaction;
import nxt.db.DbIterator;
import nxt.db.FilteringIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetUnconfirmedTransactions
extends APIServlet.APIRequestHandler {
    static final GetUnconfirmedTransactions instance = new GetUnconfirmedTransactions();

    private GetUnconfirmedTransactions() {
        super(new APITag[]{APITag.TRANSACTIONS, APITag.ACCOUNTS}, "account", "account", "account", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        AutoCloseable autoCloseable;
        Set<Long> set = Convert.toSet(ParameterParser.getAccountIds(httpServletRequest, false));
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        JSONArray jSONArray = new JSONArray();
        if (set.isEmpty()) {
            autoCloseable = Nxt.getTransactionProcessor().getAllUnconfirmedTransactions(n, n2);
            try {
                while (((DbIterator)autoCloseable).hasNext()) {
                    Transaction transaction2 = ((DbIterator)autoCloseable).next();
                    jSONArray.add((Object)JSONData.unconfirmedTransaction(transaction2));
                }
            }
            finally {
                if (autoCloseable != null) {
                    ((DbIterator)autoCloseable).close();
                }
            }
        }
        autoCloseable = new FilteringIterator<Transaction>(Nxt.getTransactionProcessor().getAllUnconfirmedTransactions(0, -1), transaction -> set.contains(transaction.getSenderId()) || set.contains(transaction.getRecipientId()), n, n2);
        try {
            while (((FilteringIterator)autoCloseable).hasNext()) {
                Transaction transaction3 = (Transaction)((FilteringIterator)autoCloseable).next();
                jSONArray.add((Object)JSONData.unconfirmedTransaction(transaction3));
            }
        }
        finally {
            ((FilteringIterator)autoCloseable).close();
        }
        autoCloseable = new JSONObject();
        autoCloseable.put("unconfirmedTransactions", jSONArray);
        return autoCloseable;
    }
}

