/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import nxt.Db;
import nxt.Nxt;
import nxt.crypto.Crypto;
import nxt.db.TransactionalDb;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetLastInboundTxHeightBulk
extends APIServlet.APIRequestHandler {
    static final String ACCOUNT_PREFIX = "GMD-";
    static final GetLastInboundTxHeightBulk instance = new GetLastInboundTxHeightBulk();
    protected static final TransactionalDb db = Db.db;

    private GetLastInboundTxHeightBulk() {
        super(new APITag[]{APITag.TRANSACTIONS}, "listOfAccounts");
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string;
        String string2 = httpServletRequest.getParameter("listOfAccounts");
        if (string2 == null) {
            throw new ParameterException(JSONResponses.INCORRECT_INPUT_LIST_PARAMETER);
        }
        String[] stringArray = string2.split(",");
        if (stringArray.length == 0) {
            throw new ParameterException(JSONResponses.INCORRECT_INPUT_LIST_PARAMETER);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string3 : stringArray) {
            string = this.rsToLongId(string3);
            if (string == null) continue;
            linkedList.add(string);
        }
        if (linkedList.size() == 0) {
            throw new ParameterException(JSONResponses.INCORRECT_INPUT_LIST_PARAMETER);
        }
        String string4 = String.join((CharSequence)",", linkedList);
        String string5 = "SELECT MAX(TRANSACTION.HEIGHT) AS HEIGHT_LAST_TRANSACTION, ACCOUNT.ID, ACCOUNT.UNCONFIRMED_BALANCE FROM TRANSACTION LEFT JOIN ACCOUNT ON TRANSACTION.RECIPIENT_ID=ACCOUNT.ID WHERE ACCOUNT.ID IN (" + string4 + ") AND ACCOUNT.LATEST=TRUE GROUP BY TRANSACTION.RECIPIENT_ID ORDER BY HEIGHT_LAST_TRANSACTION DESC";
        try (Connection connection = db.getConnection();){
            String string6;
            block18: {
                PreparedStatement preparedStatement = connection.prepareStatement(string5);
                try {
                    string = new JSONObject();
                    string.put((Object)"results", (Object)this.executePreparedStatement(preparedStatement));
                    string.put((Object)"currentHeight", (Object)Nxt.getBlockchain().getHeight());
                    string6 = string;
                    if (preparedStatement == null) break block18;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return string6;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private String rsToLongId(String string) {
        try {
            return "" + Crypto.rsDecode(string.toUpperCase().startsWith(ACCOUNT_PREFIX) ? string.substring(4) : string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private JSONArray executePreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        JSONArray jSONArray = new JSONArray();
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"account", (Object)(ACCOUNT_PREFIX + Crypto.rsEncode(resultSet.getLong("ID"))));
                jSONObject.put((Object)"height", (Object)resultSet.getInt("HEIGHT_LAST_TRANSACTION"));
                jSONObject.put((Object)"balance", (Object)("" + resultSet.getLong("UNCONFIRMED_BALANCE")));
                jSONArray.add((Object)jSONObject);
            }
        }
        return jSONArray;
    }
}

