/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nxt.Constants;
import nxt.CurrencyMinting;
import nxt.CurrencyType;
import nxt.Genesis;
import nxt.HoldingType;
import nxt.Nxt;
import nxt.PhasingPoll;
import nxt.Shuffling;
import nxt.ShufflingParticipant;
import nxt.TransactionType;
import nxt.VoteWeighting;
import nxt.crypto.HashFunction;
import nxt.http.API;
import nxt.http.APIProxy;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.peer.Peer;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetConstants
extends APIServlet.APIRequestHandler {
    static final GetConstants instance = new GetConstants();

    private GetConstants() {
        super(new APITag[]{APITag.INFO}, new String[0]);
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        return Holder.CONSTANTS;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    public static JSONStreamAware getConstants() {
        return Holder.CONSTANTS;
    }

    private static final class Holder {
        private static final JSONStreamAware CONSTANTS;

        private Holder() {
        }

        static {
            try {
                Peer.State state2;
                JSONObject jSONObject2;
                JSONObject jSONObject3 = new JSONObject();
                jSONObject3.put((Object)"coinSymbol", (Object)"GMD");
                jSONObject3.put((Object)"accountPrefix", (Object)"GMD");
                jSONObject3.put((Object)"projectName", (Object)"CoopNetwork");
                jSONObject3.put((Object)"genesisBlockId", (Object)Long.toUnsignedString(Nxt.getBlockchainProcessor().getGenesisBlockId()));
                jSONObject3.put((Object)"genesisAccountId", (Object)Long.toUnsignedString(Genesis.CREATOR_ID));
                jSONObject3.put((Object)"epochBeginning", (Object)Genesis.EPOCH_BEGINNING);
                jSONObject3.put((Object)"maxBlockPayloadLength", (Object)Constants.MAX_PAYLOAD_LENGTH);
                jSONObject3.put((Object)"maxArbitraryMessageLength", (Object)160);
                jSONObject3.put((Object)"maxPrunableMessageLength", (Object)43008);
                JSONObject jSONObject4 = new JSONObject();
                JSONObject jSONObject5 = new JSONObject();
                int n = 0;
                block4: while (true) {
                    jSONObject2 = new JSONObject();
                    JSONObject jSONObject6 = new JSONObject();
                    int n2 = 0;
                    while (true) {
                        block20: {
                            Object object;
                            try {
                                object = TransactionType.findTransactionType((byte)n, (byte)n2);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                break block20;
                            }
                            if (object == null) {
                                if (n2 != 0) break;
                                break block4;
                            }
                            Object object2 = new JSONObject();
                            object2.put((Object)"name", (Object)((TransactionType)object).getName());
                            object2.put((Object)"canHaveRecipient", (Object)((TransactionType)object).canHaveRecipient());
                            object2.put((Object)"mustHaveRecipient", (Object)((TransactionType)object).mustHaveRecipient());
                            object2.put((Object)"isPhasingSafe", (Object)((TransactionType)object).isPhasingSafe());
                            object2.put((Object)"isPhasable", (Object)((TransactionType)object).isPhasable());
                            object2.put((Object)"type", (Object)n);
                            object2.put((Object)"subtype", (Object)n2);
                            jSONObject6.put((Object)n2, object2);
                            jSONObject5.put((Object)((TransactionType)object).getName(), object2);
                        }
                        ++n2;
                    }
                    jSONObject2.put((Object)"subtypes", (Object)jSONObject6);
                    jSONObject4.put((Object)n, (Object)jSONObject2);
                    ++n;
                }
                jSONObject3.put((Object)"transactionTypes", (Object)jSONObject4);
                jSONObject3.put((Object)"transactionSubTypes", (Object)jSONObject5);
                JSONObject jSONObject7 = new JSONObject();
                for (Object object : CurrencyType.values()) {
                    jSONObject7.put((Object)((Enum)object).toString(), (Object)((CurrencyType)((Object)object)).getCode());
                }
                jSONObject3.put((Object)"currencyTypes", (Object)jSONObject7);
                jSONObject2 = new JSONObject();
                for (Object object2 : VoteWeighting.VotingModel.values()) {
                    jSONObject2.put((Object)((Enum)object2).toString(), (Object)((VoteWeighting.VotingModel)((Object)object2)).getCode());
                }
                jSONObject3.put((Object)"votingModels", (Object)jSONObject2);
                JSONObject jSONObject8 = new JSONObject();
                for (VoteWeighting.MinBalanceModel minBalanceModel : VoteWeighting.MinBalanceModel.values()) {
                    jSONObject8.put((Object)minBalanceModel.toString(), (Object)minBalanceModel.getCode());
                }
                jSONObject3.put((Object)"minBalanceModels", (Object)jSONObject8);
                JSONObject jSONObject9 = new JSONObject();
                for (HashFunction jSONObject10 : HashFunction.values()) {
                    jSONObject9.put((Object)jSONObject10.toString(), (Object)jSONObject10.getId());
                }
                jSONObject3.put((Object)"hashAlgorithms", (Object)jSONObject9);
                JSONObject jSONObject11 = new JSONObject();
                for (HashFunction hashFunction : PhasingPoll.acceptedHashFunctions) {
                    jSONObject11.put((Object)hashFunction.toString(), (Object)hashFunction.getId());
                }
                jSONObject3.put((Object)"phasingHashAlgorithms", (Object)jSONObject11);
                jSONObject3.put((Object)"maxPhasingDuration", (Object)20160);
                JSONObject jSONObject12 = new JSONObject();
                for (HashFunction hashFunction : CurrencyMinting.acceptedHashFunctions) {
                    jSONObject12.put((Object)hashFunction.toString(), (Object)hashFunction.getId());
                }
                jSONObject3.put((Object)"mintingHashAlgorithms", (Object)jSONObject12);
                JSONObject jSONObject13 = new JSONObject();
                for (Peer.State state2 : Peer.State.values()) {
                    jSONObject13.put((Object)state2.toString(), (Object)state2.ordinal());
                }
                jSONObject3.put((Object)"peerStates", (Object)jSONObject13);
                jSONObject3.put((Object)"maxTaggedDataDataLength", (Object)43008);
                JSONObject jSONObject = new JSONObject();
                for (Map.Entry<String, APIServlet.APIRequestHandler> entry : APIServlet.apiRequestHandlers.entrySet()) {
                    state2 = JSONData.apiRequestHandler(entry.getValue());
                    state2.put("enabled", true);
                    jSONObject.put((Object)entry.getKey(), (Object)state2);
                }
                for (Map.Entry<String, APIServlet.APIRequestHandler> entry : APIServlet.disabledRequestHandlers.entrySet()) {
                    state2 = JSONData.apiRequestHandler(entry.getValue());
                    state2.put("enabled", false);
                    jSONObject.put((Object)entry.getKey(), (Object)state2);
                }
                jSONObject3.put((Object)"requestTypes", (Object)jSONObject);
                JSONObject jSONObject6 = new JSONObject();
                for (HoldingType holdingType : HoldingType.values()) {
                    jSONObject6.put((Object)holdingType.toString(), (Object)holdingType.getCode());
                }
                jSONObject3.put((Object)"holdingTypes", (Object)jSONObject6);
                JSONObject jSONObject10 = new JSONObject();
                for (Shuffling.Stage stage : Shuffling.Stage.values()) {
                    jSONObject10.put((Object)stage.toString(), (Object)stage.getCode());
                }
                jSONObject3.put((Object)"shufflingStages", (Object)jSONObject10);
                JSONObject jSONObject14 = new JSONObject();
                for (ShufflingParticipant.State state3 : ShufflingParticipant.State.values()) {
                    jSONObject14.put((Object)state3.toString(), (Object)state3.getCode());
                }
                jSONObject3.put((Object)"shufflingParticipantStates", (Object)jSONObject14);
                JSONObject jSONObject15 = new JSONObject();
                for (APITag aPITag2 : APITag.values()) {
                    JSONObject jSONObject16 = new JSONObject();
                    jSONObject16.put((Object)"name", (Object)aPITag2.getDisplayName());
                    jSONObject16.put((Object)"enabled", (Object)(!API.getDisabledApiTags().contains((Object)aPITag2) ? 1 : 0));
                    jSONObject15.put((Object)aPITag2.name(), (Object)jSONObject16);
                }
                jSONObject3.put((Object)"apiTags", (Object)jSONObject15);
                JSONArray jSONArray = new JSONArray();
                Collections.addAll(jSONArray, new List[]{API.getDisabledApis()});
                jSONObject3.put((Object)"disabledAPIs", (Object)jSONArray);
                JSONArray jSONArray2 = new JSONArray();
                API.getDisabledApiTags().forEach(aPITag -> jSONArray2.add((Object)aPITag.getDisplayName()));
                jSONObject3.put((Object)"disabledAPITags", (Object)jSONArray2);
                JSONArray jSONArray3 = new JSONArray();
                jSONArray3.addAll(APIProxy.NOT_FORWARDED_REQUESTS);
                jSONObject3.put((Object)"proxyNotForwardedRequests", (Object)jSONArray3);
                jSONObject3.put((Object)"initialBaseTarget", (Object)Long.toUnsignedString(Constants.INITIAL_BASE_TARGET));
                CONSTANTS = JSON.prepare(jSONObject3);
            }
            catch (Exception exception) {
                Logger.logErrorMessage(exception.toString(), exception);
                throw exception;
            }
        }
    }
}

