/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Attachment;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Order;
import nxt.Transaction;
import nxt.TransactionType;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetBidOrders
extends APIServlet.APIRequestHandler {
    static final GetBidOrders instance = new GetBidOrders();

    private GetBidOrders() {
        super(new APITag[]{APITag.AE}, "asset", "firstIndex", "lastIndex", "showExpectedCancellations");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        Iterable<Object> iterable;
        JSONArray jSONArray;
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", true);
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("showExpectedCancellations"));
        long[] lArray = null;
        if (bl) {
            jSONArray = transaction -> transaction.getType() == TransactionType.ColoredCoins.BID_ORDER_CANCELLATION;
            iterable = Nxt.getBlockchain().getExpectedTransactions((Filter<Transaction>)jSONArray);
            lArray = new long[iterable.size()];
            for (int i = 0; i < iterable.size(); ++i) {
                object = (Attachment.ColoredCoinsOrderCancellation)((Transaction)iterable.get(i)).getAttachment();
                lArray[i] = ((Attachment.ColoredCoinsOrderCancellation)object).getOrderId();
            }
            Arrays.sort(lArray);
        }
        jSONArray = new JSONArray();
        iterable = Order.Bid.getSortedOrders(l, n, n2);
        try {
            while (((DbIterator)iterable).hasNext()) {
                Order.Bid bid = (Order.Bid)((DbIterator)iterable).next();
                object = JSONData.bidOrder(bid);
                if (bl && Arrays.binarySearch(lArray, bid.getId()) >= 0) {
                    object.put((Object)"expectedCancellation", (Object)Boolean.TRUE);
                }
                jSONArray.add(object);
            }
        }
        finally {
            if (iterable != null) {
                ((DbIterator)iterable).close();
            }
        }
        iterable = new JSONObject();
        iterable.put("bidOrders", jSONArray);
        return iterable;
    }
}

