/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Asset;
import nxt.NxtException;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetAssetProperties
extends APIServlet.APIRequestHandler {
    static final GetAssetProperties instance = new GetAssetProperties();

    private GetAssetProperties() {
        super(new APITag[]{APITag.AE}, "asset", "setter", "property", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, "setter", false);
        if (l == 0L && l2 == 0L) {
            return JSONResponses.missing("asset", "setter");
        }
        String string = Convert.emptyToNull(httpServletRequest.getParameter("property"));
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        if (l != 0L) {
            jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(l));
        }
        if (l2 != 0L) {
            JSONData.putAccount(jSONObject, "setter", l2);
        }
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"properties", (Object)jSONArray);
        try (DbIterator<Asset.AssetProperty> dbIterator = Asset.getProperties(l, l2, string, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add((Object)JSONData.assetProperty(dbIterator.next(), l == 0L, l2 == 0L));
            }
        }
        return jSONObject;
    }
}

