/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.NxtException;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAccountProperties
extends APIServlet.APIRequestHandler {
    static final GetAccountProperties instance = new GetAccountProperties();

    private GetAccountProperties() {
        super(new APITag[]{APITag.ACCOUNTS}, "recipient", "property", "setter", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, "recipient", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, "setter", false);
        if (l == 0L && l2 == 0L) {
            return JSONResponses.missing("recipient", "setter");
        }
        String string = Convert.emptyToNull(httpServletRequest.getParameter("property"));
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"properties", (Object)jSONArray);
        if (l != 0L) {
            JSONData.putAccount(jSONObject, "recipient", l);
        }
        if (l2 != 0L) {
            JSONData.putAccount(jSONObject, "setter", l2);
        }
        try (DbIterator<Account.AccountProperty> dbIterator = Account.getProperties(l, l2, string, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add((Object)JSONData.accountProperty(dbIterator.next(), l == 0L, l2 == 0L));
            }
        }
        return jSONObject;
    }
}

