/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.Nxt;
import nxt.NxtException;
import nxt.TaggedData;
import nxt.Transaction;
import nxt.TransactionType;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class ExtendTaggedData
extends CreateTransaction {
    static final ExtendTaggedData instance = new ExtendTaggedData();

    private ExtendTaggedData() {
        super("file", new APITag[]{APITag.DATA, APITag.CREATE_TRANSACTION}, "transaction", "name", "description", "tags", "type", "channel", "isText", "filename", "data");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "transaction", true);
        TaggedData taggedData = TaggedData.getData(l);
        if (taggedData == null) {
            object = Nxt.getBlockchain().getTransaction(l);
            if (object == null || object.getType() != TransactionType.Data.TAGGED_DATA_UPLOAD) {
                return JSONResponses.UNKNOWN_TRANSACTION;
            }
            Attachment.TaggedDataUpload taggedDataUpload = ParameterParser.getTaggedData(httpServletRequest);
            taggedData = new TaggedData((Transaction)object, taggedDataUpload);
        }
        object = new Attachment.TaggedDataExtend(taggedData);
        return this.createTransaction(httpServletRequest, account, (Attachment)object);
    }
}

