/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.EventListener;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class EventRegister
extends APIServlet.APIRequestHandler {
    static final EventRegister instance = new EventRegister();
    private static final JSONObject eventsRegistered = new JSONObject();
    private static final JSONObject exclusiveParams;
    private static final JSONObject incorrectEvent;
    private static final JSONObject unknownEvent;
    private static final JSONObject noEventsRegistered;

    private EventRegister() {
        super(new APITag[]{APITag.INFO}, "event", "event", "event", "add", "remove");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        JSONObject jSONObject;
        boolean bl = Boolean.valueOf(httpServletRequest.getParameter("add"));
        boolean bl2 = Boolean.valueOf(httpServletRequest.getParameter("remove"));
        if (bl && bl2) {
            return exclusiveParams;
        }
        ArrayList<EventListener.EventRegistration> arrayList = new ArrayList<EventListener.EventRegistration>();
        String[] stringArray = httpServletRequest.getParameterValues("event");
        if (stringArray == null) {
            EventListener.peerEvents.forEach(event -> arrayList.add(new EventListener.EventRegistration((Enum<? extends Enum>)event, 0L)));
            EventListener.blockEvents.forEach(event -> arrayList.add(new EventListener.EventRegistration((Enum<? extends Enum>)event, 0L)));
            EventListener.txEvents.forEach(event -> arrayList.add(new EventListener.EventRegistration((Enum<? extends Enum>)event, 0L)));
            EventListener.ledgerEvents.forEach(event -> arrayList.add(new EventListener.EventRegistration((Enum<? extends Enum>)event, 0L)));
        } else {
            for (String string : stringArray) {
                List<Enum> list;
                long l = 0L;
                String[] stringArray2 = string.split("\\.");
                if (stringArray2[0].equals("Ledger")) {
                    if (stringArray2.length == 3) {
                        try {
                            l = Convert.parseAccountId(stringArray2[2]);
                        }
                        catch (RuntimeException runtimeException) {
                            return incorrectEvent;
                        }
                    } else if (stringArray2.length != 2) {
                        return incorrectEvent;
                    }
                } else if (stringArray2.length != 2) {
                    return incorrectEvent;
                }
                switch (stringArray2[0]) {
                    case "Block": {
                        list = EventListener.blockEvents;
                        break;
                    }
                    case "Peer": {
                        list = EventListener.peerEvents;
                        break;
                    }
                    case "Transaction": {
                        list = EventListener.txEvents;
                        break;
                    }
                    case "Ledger": {
                        list = EventListener.ledgerEvents;
                        break;
                    }
                    default: {
                        return unknownEvent;
                    }
                }
                boolean bl3 = false;
                for (Enum enum_ : list) {
                    if (!enum_.name().equals(stringArray2[1])) continue;
                    arrayList.add(new EventListener.EventRegistration(enum_, l));
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                return unknownEvent;
            }
        }
        try {
            Object object;
            if (bl || bl2) {
                object = EventListener.eventListeners.get(httpServletRequest.getRemoteAddr());
                if (object != null) {
                    if (bl) {
                        ((EventListener)object).addEvents(arrayList);
                    } else {
                        ((EventListener)object).removeEvents(arrayList);
                    }
                    jSONObject = eventsRegistered;
                } else {
                    jSONObject = noEventsRegistered;
                }
            } else {
                object = new EventListener(httpServletRequest.getRemoteAddr());
                ((EventListener)object).activateListener(arrayList);
                jSONObject = eventsRegistered;
            }
        }
        catch (EventListener.EventListenerException eventListenerException) {
            jSONObject = new JSONObject();
            jSONObject.put((Object)"errorCode", (Object)7);
            jSONObject.put((Object)"errorDescription", (Object)("Unable to register events: " + eventListenerException.getMessage()));
        }
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    static {
        eventsRegistered.put((Object)"registered", (Object)true);
        exclusiveParams = new JSONObject();
        exclusiveParams.put((Object)"errorCode", (Object)4);
        exclusiveParams.put((Object)"errorDescription", (Object)"Mutually exclusive 'add' and 'remove'");
        incorrectEvent = new JSONObject();
        incorrectEvent.put((Object)"errorCode", (Object)4);
        incorrectEvent.put((Object)"errorDescription", (Object)"Incorrect event name format");
        unknownEvent = new JSONObject();
        unknownEvent.put((Object)"errorCode", (Object)5);
        unknownEvent.put((Object)"errorDescription", (Object)"Unknown event name");
        noEventsRegistered = new JSONObject();
        noEventsRegistered.put((Object)"errorCode", (Object)8);
        noEventsRegistered.put((Object)"errorDescription", (Object)"No events registered");
    }
}

