/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Nxt;
import nxt.NxtException;
import nxt.TaggedData;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class DownloadTaggedData
extends APIServlet.APIRequestHandler {
    static final DownloadTaggedData instance = new DownloadTaggedData();

    private DownloadTaggedData() {
        super(new APITag[]{APITag.DATA}, "transaction", "retrieve");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NxtException {
        URI uRI;
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "transaction", true);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("retrieve"));
        TaggedData taggedData = TaggedData.getData(l);
        if (taggedData == null && bl) {
            if (Nxt.getBlockchainProcessor().restorePrunedTransaction(l) == null) {
                return JSONResponses.PRUNED_TRANSACTION;
            }
            taggedData = TaggedData.getData(l);
        }
        if (taggedData == null) {
            return JSONResponses.incorrect("transaction", "Tagged data not found");
        }
        byte[] byArray = taggedData.getData();
        if (!taggedData.getType().equals("")) {
            httpServletResponse.setContentType(taggedData.getType());
        } else {
            httpServletResponse.setContentType("application/octet-stream");
        }
        String string = taggedData.getFilename();
        if (string == null || string.trim().isEmpty()) {
            string = taggedData.getName().trim();
        }
        Object object = "attachment";
        try {
            uRI = new URI(null, null, string, null);
            object = (String)object + "; filename*=UTF-8''" + uRI.toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        httpServletResponse.setHeader("Content-Disposition", (String)object);
        httpServletResponse.setContentLength(byArray.length);
        try {
            uRI = httpServletResponse.getOutputStream();
            try {
                try {
                    ((OutputStream)((Object)uRI)).write(byArray);
                }
                catch (IOException iOException) {
                    throw new ParameterException(JSONResponses.RESPONSE_WRITE_ERROR);
                }
            }
            finally {
                if (uRI != null) {
                    ((OutputStream)((Object)uRI)).close();
                }
            }
        }
        catch (IOException iOException) {
            throw new ParameterException(JSONResponses.RESPONSE_STREAM_ERROR);
        }
        return null;
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        throw new UnsupportedOperationException();
    }
}

