/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.sql.SQLException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Db;
import nxt.http.API;
import nxt.http.ParameterException;
import nxt.util.Convert;
import nxt.util.JSON;
import org.h2.tools.Shell;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class DbShellServlet
extends HttpServlet {
    private static final String header = "<!DOCTYPE html>\n<html>\n<head>\n    <meta charset=\"UTF-8\"/>\n    <title>Nxt H2 Database Shell</title>\n    <script type=\"text/javascript\">\n        function submitForm(form, adminPassword) {\n            var url = '/dbshell';\n            var params = '';\n            for (i = 0; i < form.elements.length; i++) {\n                if (! form.elements[i].name) {\n                    continue;\n                }\n                if (i > 0) {\n                    params += '&';\n                }\n                params += encodeURIComponent(form.elements[i].name);\n                params += '=';\n                params += encodeURIComponent(form.elements[i].value);\n            }\n            if (adminPassword && form.elements.length > 0) {\n                params += '&adminPassword=' + adminPassword;\n            }\n            var request = new XMLHttpRequest();\n            request.open(\"POST\", url, false);\n            request.setRequestHeader(\"Content-type\", \"application/x-www-form-urlencoded\");\n            request.send(params);\n            form.getElementsByClassName(\"result\")[0].textContent += request.responseText;\n            return false;\n        }\n    </script>\n</head>\n<body>\n";
    private static final String footer = "</body>\n</html>\n";
    private static final String form = "<form action=\"/dbshell\" method=\"POST\" onsubmit=\"return submitForm(this" + (API.disableAdminPassword ? "" : ", '{adminPassword}'") + ");\"><table class=\"table\" style=\"width:90%;\"><tr><td><pre class=\"result\" style=\"float:top;width:90%;\">This is a database shell. Enter SQL to be evaluated, or \"help\" for help:</pre></td></tr><tr><td><b>&gt;</b> <input type=\"text\" name=\"line\" style=\"width:90%;\"/></td></tr></table></form>";
    private static final String errorNoPasswordIsConfigured = "This page is password-protected, but no password is configured in nxt.properties. Please set nxt.adminPassword or disable the password protection with nxt.disableAdminPassword";
    private static final String passwordFormTemplate = "<form action=\"/dbshell\" method=\"POST\"><table class=\"table\"><tr><td colspan=\"3\">%s</td></tr><tr><td>Password:</td><td><input type=\"password\" name=\"adminPassword\"/><input type=\"submit\" value=\"Go!\"/></td></tr></table><input type=\"hidden\" name=\"showShell\" value=\"true\"/></form>";
    private static final String passwordForm = String.format("<form action=\"/dbshell\" method=\"POST\"><table class=\"table\"><tr><td colspan=\"3\">%s</td></tr><tr><td>Password:</td><td><input type=\"password\" name=\"adminPassword\"/><input type=\"submit\" value=\"Go!\"/></td></tr></table><input type=\"hidden\" name=\"showShell\" value=\"true\"/></form>", "<p>This page is password-protected. Please enter the administrator's password</p>");

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        if (!API.isAllowed(httpServletRequest.getRemoteHost())) {
            httpServletResponse.sendError(403);
            return;
        }
        String string = API.disableAdminPassword ? form : (API.adminPassword.isEmpty() ? errorNoPasswordIsConfigured : passwordForm);
        try (PrintStream printStream = new PrintStream((OutputStream)httpServletResponse.getOutputStream());){
            printStream.print(header);
            printStream.print(string);
            printStream.print(footer);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        if (!API.isAllowed(httpServletRequest.getRemoteHost())) {
            httpServletResponse.sendError(403);
            return;
        }
        String string = null;
        if (!API.disableAdminPassword) {
            if (API.adminPassword.isEmpty()) {
                string = errorNoPasswordIsConfigured;
            } else {
                try {
                    API.verifyPassword(httpServletRequest);
                    if ("true".equals(httpServletRequest.getParameter("showShell"))) {
                        string = form.replace("{adminPassword}", URLEncoder.encode(httpServletRequest.getParameter("adminPassword"), "UTF-8"));
                    }
                }
                catch (ParameterException parameterException) {
                    object = (String)((JSONObject)JSONValue.parse((String)JSON.toString(parameterException.getErrorResponse()))).get((Object)"errorDescription");
                    string = String.format(passwordFormTemplate, "<p style=\"color:red\">" + (String)object + "</p>");
                }
            }
        }
        if (string != null) {
            try (PrintStream printStream = new PrintStream((OutputStream)httpServletResponse.getOutputStream());){
                printStream.print(header);
                printStream.print(string);
                printStream.print(footer);
            }
            return;
        }
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("line"));
        object = new PrintStream((OutputStream)httpServletResponse.getOutputStream());
        try {
            ((PrintStream)object).println("\n> " + string2);
            try {
                Shell shell = new Shell();
                shell.setErr((PrintStream)object);
                shell.setOut((PrintStream)object);
                shell.runTool(Db.db.getConnection(), new String[]{"-sql", string2});
            }
            catch (SQLException sQLException) {
                ((PrintStream)object).println(sQLException.toString());
            }
        }
        finally {
            ((PrintStream)object).close();
        }
    }
}

