/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.DigitalGoodsStore;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class DGSFeedback
extends CreateTransaction {
    static final DGSFeedback instance = new DGSFeedback();

    private DGSFeedback() {
        super(new APITag[]{APITag.DGS, APITag.CREATE_TRANSACTION}, "purchase");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        DigitalGoodsStore.Purchase purchase = ParameterParser.getPurchase(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        if (account.getId() != purchase.getBuyerId()) {
            return JSONResponses.INCORRECT_PURCHASE;
        }
        if (purchase.getEncryptedGoods() == null) {
            return JSONResponses.GOODS_NOT_DELIVERED;
        }
        Account account2 = Account.getAccount(purchase.getSellerId());
        Attachment.DigitalGoodsFeedback digitalGoodsFeedback = new Attachment.DigitalGoodsFeedback(purchase.getId());
        return this.createTransaction(httpServletRequest, account, account2.getId(), 0L, digitalGoodsFeedback);
    }
}

