/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Appendix;
import nxt.Attachment;
import nxt.Nxt;
import nxt.NxtException;
import nxt.PhasingParams;
import nxt.Transaction;
import nxt.crypto.Crypto;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

abstract class CreateTransaction
extends APIServlet.APIRequestHandler {
    private static final String[] commonParameters = new String[]{"secretPhrase", "publicKey", "feeNQT", "deadline", "referencedTransactionFullHash", "broadcast", "message", "messageIsText", "messageIsPrunable", "messageToEncrypt", "messageToEncryptIsText", "encryptedMessageData", "encryptedMessageNonce", "encryptedMessageIsPrunable", "compressMessageToEncrypt", "messageToEncryptToSelf", "messageToEncryptToSelfIsText", "encryptToSelfMessageData", "encryptToSelfMessageNonce", "compressMessageToEncryptToSelf", "phased", "phasingFinishHeight", "phasingVotingModel", "phasingQuorum", "phasingMinBalance", "phasingHolding", "phasingMinBalanceModel", "phasingWhitelisted", "phasingWhitelisted", "phasingWhitelisted", "phasingLinkedFullHash", "phasingLinkedFullHash", "phasingLinkedFullHash", "phasingHashedSecret", "phasingHashedSecretAlgorithm", "recipientPublicKey", "ecBlockId", "ecBlockHeight"};

    private static String[] addCommonParameters(String[] stringArray) {
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length + commonParameters.length);
        System.arraycopy(commonParameters, 0, stringArray2, stringArray.length, commonParameters.length);
        return stringArray2;
    }

    CreateTransaction(APITag[] aPITagArray, String ... stringArray) {
        super(aPITagArray, CreateTransaction.addCommonParameters(stringArray));
        if (!this.getAPITags().contains((Object)APITag.CREATE_TRANSACTION)) {
            throw new RuntimeException("CreateTransaction API " + this.getClass().getName() + " is missing APITag.CREATE_TRANSACTION tag");
        }
    }

    CreateTransaction(String string, APITag[] aPITagArray, String ... stringArray) {
        super(string, aPITagArray, CreateTransaction.addCommonParameters(stringArray));
        if (!this.getAPITags().contains((Object)APITag.CREATE_TRANSACTION)) {
            throw new RuntimeException("CreateTransaction API " + this.getClass().getName() + " is missing APITag.CREATE_TRANSACTION tag");
        }
    }

    final JSONStreamAware createTransaction(HttpServletRequest httpServletRequest, Account account, Attachment attachment) throws NxtException {
        return this.createTransaction(httpServletRequest, account, 0L, 0L, attachment);
    }

    final JSONStreamAware createTransaction(HttpServletRequest httpServletRequest, Account account, long l, long l2) throws NxtException {
        return this.createTransaction(httpServletRequest, account, l, l2, Attachment.ORDINARY_PAYMENT);
    }

    private Appendix.Phasing parsePhasing(HttpServletRequest httpServletRequest) throws ParameterException {
        int n = ParameterParser.getInt(httpServletRequest, "phasingFinishHeight", Nxt.getBlockchain().getHeight() + 1, Nxt.getBlockchain().getHeight() + 20160 + 1, true);
        PhasingParams phasingParams = this.parsePhasingParams(httpServletRequest, "phasing");
        byte[][] byArrayArray = null;
        String[] stringArray = httpServletRequest.getParameterValues("phasingLinkedFullHash");
        if (stringArray != null && stringArray.length > 0) {
            byArrayArray = new byte[stringArray.length][];
            for (int i = 0; i < byArrayArray.length; ++i) {
                byArrayArray[i] = Convert.parseHexString(stringArray[i]);
                if (Convert.emptyToNull(byArrayArray[i]) != null && byArrayArray[i].length == 32) continue;
                throw new ParameterException(JSONResponses.INCORRECT_LINKED_FULL_HASH);
            }
        }
        byte[] byArray = Convert.parseHexString(Convert.emptyToNull(httpServletRequest.getParameter("phasingHashedSecret")));
        byte by = ParameterParser.getByte(httpServletRequest, "phasingHashedSecretAlgorithm", (byte)0, (byte)127, false);
        return new Appendix.Phasing(n, phasingParams, byArrayArray, byArray, by);
    }

    final PhasingParams parsePhasingParams(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        byte by = ParameterParser.getByte(httpServletRequest, string + "VotingModel", (byte)-1, (byte)5, true);
        long l = ParameterParser.getLong(httpServletRequest, string + "Quorum", 0L, Long.MAX_VALUE, false);
        long l2 = ParameterParser.getLong(httpServletRequest, string + "MinBalance", 0L, Long.MAX_VALUE, false);
        byte by2 = ParameterParser.getByte(httpServletRequest, string + "MinBalanceModel", (byte)0, (byte)3, false);
        long l3 = ParameterParser.getUnsignedLong(httpServletRequest, string + "Holding", false);
        long[] lArray = null;
        String[] stringArray = httpServletRequest.getParameterValues(string + "Whitelisted");
        if (stringArray != null && stringArray.length > 0) {
            lArray = new long[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                lArray[i] = Convert.parseAccountId(stringArray[i]);
                if (lArray[i] != 0L) continue;
                throw new ParameterException(JSONResponses.INCORRECT_WHITELIST);
            }
        }
        return new PhasingParams(by, l3, l, l2, by2, lArray);
    }

    final JSONStreamAware createTransaction(HttpServletRequest httpServletRequest, Account account, long l, long l2, Attachment attachment) throws NxtException {
        short s;
        Object object;
        String string = httpServletRequest.getParameter("deadline");
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("referencedTransactionFullHash"));
        String string3 = ParameterParser.getSecretPhrase(httpServletRequest, false);
        String string4 = Convert.emptyToNull(httpServletRequest.getParameter("publicKey"));
        boolean bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("broadcast")) && string3 != null;
        Appendix.EncryptedMessage encryptedMessage = null;
        Appendix.PrunableEncryptedMessage prunableEncryptedMessage = null;
        if (attachment.getTransactionType().canHaveRecipient() && l != 0L) {
            object = Account.getAccount(l);
            if ("true".equalsIgnoreCase(httpServletRequest.getParameter("encryptedMessageIsPrunable"))) {
                prunableEncryptedMessage = (Appendix.PrunableEncryptedMessage)ParameterParser.getEncryptedMessage(httpServletRequest, (Account)object, true);
            } else {
                encryptedMessage = (Appendix.EncryptedMessage)ParameterParser.getEncryptedMessage(httpServletRequest, (Account)object, false);
            }
        }
        object = ParameterParser.getEncryptToSelfMessage(httpServletRequest);
        Appendix.Message message = null;
        Appendix.PrunablePlainMessage prunablePlainMessage = null;
        if ("true".equalsIgnoreCase(httpServletRequest.getParameter("messageIsPrunable"))) {
            prunablePlainMessage = (Appendix.PrunablePlainMessage)ParameterParser.getPlainMessage(httpServletRequest, true);
        } else {
            message = (Appendix.Message)ParameterParser.getPlainMessage(httpServletRequest, false);
        }
        Appendix.PublicKeyAnnouncement publicKeyAnnouncement = null;
        String string5 = Convert.emptyToNull(httpServletRequest.getParameter("recipientPublicKey"));
        if (string5 != null) {
            publicKeyAnnouncement = new Appendix.PublicKeyAnnouncement(Convert.parseHexString(string5));
        }
        Appendix.Phasing phasing = null;
        boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("phased"));
        if (bl2) {
            phasing = this.parsePhasing(httpServletRequest);
        }
        if (string3 == null && string4 == null) {
            return JSONResponses.MISSING_SECRET_PHRASE;
        }
        if (string == null) {
            return JSONResponses.MISSING_DEADLINE;
        }
        try {
            s = Short.parseShort(string);
            if (s < 1) {
                return JSONResponses.INCORRECT_DEADLINE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return JSONResponses.INCORRECT_DEADLINE;
        }
        long l3 = ParameterParser.getFeeNQT(httpServletRequest);
        int n = ParameterParser.getInt(httpServletRequest, "ecBlockHeight", 0, Integer.MAX_VALUE, false);
        long l4 = Convert.parseUnsignedLong(httpServletRequest.getParameter("ecBlockId"));
        if (l4 != 0L && l4 != Nxt.getBlockchain().getBlockIdAtHeight(n)) {
            return JSONResponses.INCORRECT_EC_BLOCK;
        }
        if (l4 == 0L && n > 0) {
            l4 = Nxt.getBlockchain().getBlockIdAtHeight(n);
        }
        JSONObject jSONObject = new JSONObject();
        byte[] byArray = string3 != null ? Crypto.getPublicKey(string3) : Convert.parseHexString(string4);
        try {
            Transaction.Builder builder = Nxt.newTransactionBuilder(byArray, l2, l3, s, attachment).referencedTransactionFullHash(string2);
            if (attachment.getTransactionType().canHaveRecipient()) {
                builder.recipientId(l);
            }
            builder.appendix(encryptedMessage);
            builder.appendix(message);
            builder.appendix(publicKeyAnnouncement);
            builder.appendix((Appendix.EncryptToSelfMessage)object);
            builder.appendix(phasing);
            builder.appendix(prunablePlainMessage);
            builder.appendix(prunableEncryptedMessage);
            if (l4 != 0L) {
                builder.ecBlockId(l4);
                builder.ecBlockHeight(n);
            }
            Transaction transaction = builder.build(string3);
            try {
                if (Math.addExact(l2, transaction.getFeeNQT()) > account.getUnconfirmedBalanceNQT()) {
                    return JSONResponses.NOT_ENOUGH_FUNDS;
                }
            }
            catch (ArithmeticException arithmeticException) {
                return JSONResponses.NOT_ENOUGH_FUNDS;
            }
            JSONObject jSONObject2 = JSONData.unconfirmedTransaction(transaction);
            jSONObject.put((Object)"transactionJSON", (Object)jSONObject2);
            try {
                jSONObject.put((Object)"unsignedTransactionBytes", (Object)Convert.toHexString(transaction.getUnsignedBytes()));
            }
            catch (NxtException.NotYetEncryptedException notYetEncryptedException) {
                // empty catch block
            }
            if (string3 != null) {
                jSONObject.put((Object)"transaction", (Object)transaction.getStringId());
                jSONObject.put((Object)"fullHash", jSONObject2.get((Object)"fullHash"));
                jSONObject.put((Object)"transactionBytes", (Object)Convert.toHexString(transaction.getBytes()));
                jSONObject.put((Object)"signatureHash", jSONObject2.get((Object)"signatureHash"));
            }
            if (bl) {
                Nxt.getTransactionProcessor().broadcast(transaction);
                jSONObject.put((Object)"broadcasted", (Object)true);
            } else {
                transaction.validate();
                jSONObject.put((Object)"broadcasted", (Object)false);
            }
        }
        catch (NxtException.NotYetEnabledException notYetEnabledException) {
            return JSONResponses.FEATURE_NOT_AVAILABLE;
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            throw insufficientBalanceException;
        }
        catch (NxtException.ValidationException validationException) {
            if (bl) {
                jSONObject.clear();
            }
            jSONObject.put((Object)"broadcasted", (Object)false);
            JSONData.putException(jSONObject, validationException);
        }
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected final boolean allowRequiredBlockParameters() {
        return false;
    }

    public static List<String> getCommonParameters() {
        return Collections.unmodifiableList(Arrays.asList(commonParameters));
    }
}

