/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.peer.PeerImpl;
import nxt.peer.Peers;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class AddPeer
extends APIServlet.APIRequestHandler {
    static final AddPeer instance = new AddPeer();

    private AddPeer() {
        super(new APITag[]{APITag.NETWORK}, "peer");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("peer"));
        if (string == null) {
            return JSONResponses.MISSING_PEER;
        }
        JSONObject jSONObject = new JSONObject();
        PeerImpl peerImpl = Peers.findOrCreatePeer(string, true);
        if (peerImpl != null) {
            if (!Peers.isNetworkingEnabled()) {
                return JSONResponses.PEERS_NETWORKING_DISABLED;
            }
            boolean bl = Peers.addPeer(peerImpl, string);
            Peers.connectPeer(peerImpl);
            jSONObject = JSONData.peer(peerImpl);
            jSONObject.put((Object)"isNewlyAdded", (Object)bl);
        } else {
            jSONObject.put((Object)"errorCode", (Object)8);
            jSONObject.put((Object)"errorDescription", (Object)"Failed to add peer");
        }
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean requirePassword() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }
}

