/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.HashMap;
import java.util.Map;

public enum APITag {
    ACCOUNTS("Accounts"),
    ACCOUNT_CONTROL("Account Control"),
    ALIASES("Aliases"),
    AE("Asset Exchange"),
    BLOCKS("Blocks"),
    CREATE_TRANSACTION("Create Transaction"),
    DGS("Digital Goods Store"),
    FORGING("Forging"),
    MESSAGES("Messages"),
    MS("Monetary System"),
    NETWORK("Networking"),
    PHASING("Phasing"),
    SEARCH("Search"),
    INFO("Server Info"),
    SHUFFLING("Shuffling"),
    DATA("Tagged Data"),
    TOKENS("Tokens"),
    TRANSACTIONS("Transactions"),
    VS("Voting System"),
    UTILS("Utils"),
    DEBUG("Debug"),
    ADDONS("Add-ons");

    private static final Map<String, APITag> apiTags;
    private final String displayName;

    public static APITag fromDisplayName(String string) {
        APITag aPITag = apiTags.get(string);
        if (aPITag == null) {
            throw new IllegalArgumentException("Invalid APITag name: " + string);
        }
        return aPITag;
    }

    private APITag(String string2) {
        this.displayName = string2;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.displayName;
    }

    static {
        apiTags = new HashMap<String, APITag>();
        for (APITag aPITag : APITag.values()) {
            if (apiTags.put(aPITag.getDisplayName(), aPITag) == null) continue;
            throw new RuntimeException("Duplicate APITag name: " + aPITag.getDisplayName());
        }
    }
}

