/*
 * Decompiled with CFR 0.152.
 */
package nxt.db.pool;

import java.sql.Connection;
import java.sql.SQLException;
import nxt.db.pool.ConnectionPool;
import nxt.util.Logger;
import org.h2.jdbcx.JdbcConnectionPool;

public class H2ConnectionPool
implements ConnectionPool {
    private JdbcConnectionPool wrappedPool;
    private volatile int maxActiveConnections;

    @Override
    public void initialize(String string, String string2, String string3, int n, int n2) {
        this.wrappedPool = JdbcConnectionPool.create((String)string, (String)string2, (String)string3);
        this.wrappedPool.setMaxConnections(n);
        this.wrappedPool.setLoginTimeout(n2);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this.wrappedPool.getConnection();
        int n = this.wrappedPool.getActiveConnections();
        if (n > this.maxActiveConnections) {
            this.maxActiveConnections = n;
            Logger.logDebugMessage("Database connection pool current size: " + n);
        }
        return connection;
    }
}

