/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nxt.db.DbKey;
import nxt.db.TrimmableDbTable;

public abstract class ValuesDbTable<T, V>
extends TrimmableDbTable<T> {
    protected ValuesDbTable(String string, DbKey.Factory<T> factory) {
        this(string, factory, false);
    }

    ValuesDbTable(String string, DbKey.Factory<T> factory, boolean bl) {
        super(string, factory, bl);
    }

    protected abstract V load(Connection var1, ResultSet var2) throws SQLException;

    protected abstract void save(Connection var1, T var2, V var3) throws SQLException;

    protected void clearCache() {
        db.clearCache(this.table);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final List<V> get(DbKey dbKey) {
        List<V> list;
        if (db.isInTransaction() && (list = (List<V>)db.getCache(this.table).get(dbKey)) != null) {
            return list;
        }
        try (Connection connection = db.getConnection();){
            List<V> list2;
            block16: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + this.dbKeyFactory.getPKClause() + (this.multiversion ? " AND latest = TRUE" : "") + " ORDER BY db_id");
                try {
                    dbKey.setPK(preparedStatement);
                    list = this.get(connection, preparedStatement);
                    if (db.isInTransaction()) {
                        db.getCache(this.table).put(dbKey, list);
                    }
                    list2 = list;
                    if (preparedStatement == null) break block16;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return list2;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private List<V> get(Connection connection, PreparedStatement preparedStatement) {
        try {
            ArrayList<V> arrayList = new ArrayList<V>();
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.load(connection, resultSet));
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public final void insert(T t, List<V> list) {
        if (!db.isInTransaction()) {
            throw new IllegalStateException("Not in transaction");
        }
        DbKey dbKey = this.dbKeyFactory.newKey(t);
        if (dbKey == null) {
            throw new RuntimeException("DbKey not set");
        }
        db.getCache(this.table).put(dbKey, list);
        try (Connection connection = db.getConnection();){
            if (this.multiversion) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.table + " SET latest = FALSE " + this.dbKeyFactory.getPKClause() + " AND latest = TRUE");){
                    dbKey.setPK(preparedStatement);
                    preparedStatement.executeUpdate();
                }
            }
            for (V v : list) {
                this.save(connection, t, v);
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }
}

