/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import nxt.Constants;
import nxt.Nxt;
import nxt.db.DbKey;
import nxt.db.DerivedDbTable;
import nxt.db.VersionedEntityDbTable;
import org.h2.value.Value;

public class TrimmableDbTable<T>
extends DerivedDbTable {
    private static final boolean USE_FAST_TRIMMING = true;
    final boolean multiversion;
    protected final DbKey.Factory<T> dbKeyFactory;
    private final boolean isFastTrimEnabled;
    private String[] keyColumns;
    private final int trimFrequency;
    private int trimCounter = 0;
    private static ThreadLocal<TrimContext> trimContext = ThreadLocal.withInitial(() -> new TrimContext());

    TrimmableDbTable(String string, DbKey.Factory<T> factory, boolean bl) {
        super(string);
        this.dbKeyFactory = factory;
        this.multiversion = bl;
        this.trimFrequency = Nxt.getIntProperty("nxt.trimFrequencyMultiplier." + string, 1);
        this.trimCounter = this.trimFrequency - 1;
        this.isFastTrimEnabled = this.checkFastTrimIndex(string);
    }

    /*
     * Exception decompiling
     */
    private boolean checkFastTrimIndex(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[TRYBLOCK]], but top level block is 73[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void popOffTo(int n) {
        if (this.multiversion) {
            VersionedEntityDbTable.popOff(db, this.table, n, this.dbKeyFactory);
        } else {
            super.popOffTo(n);
        }
    }

    @Override
    public void trim(int n) {
        if (this.multiversion) {
            ++this.trimCounter;
            if (this.trimCounter >= this.trimFrequency) {
                this.trimCounter = 0;
                if (this.isFastTrimEnabled) {
                    this.fastTrim(n);
                } else {
                    VersionedEntityDbTable.trim(db, this.table, n, this.dbKeyFactory);
                }
            }
        } else {
            super.trim(n);
        }
    }

    private void fastTrim(int n) {
        TrimContext trimContext = TrimmableDbTable.trimContext.get();
        trimContext.trimHeight = n;
        trimContext.lastBatchMarker = Long.MIN_VALUE;
        try (Connection connection = db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + this.table + " WHERE " + this.keyColumns[0] + " >= ?  AND CAN_BE_TRIMMED(height, latest, " + this.dbKeyFactory.getPKColumns() + ") LIMIT " + Constants.BATCH_COMMIT_SIZE);){
            int n2;
            do {
                trimContext.isHighestRowBeforeTrimSkipped = false;
                preparedStatement.setLong(1, trimContext.lastBatchMarker);
                n2 = preparedStatement.executeUpdate();
                db.commitTransaction();
            } while (n2 >= Constants.BATCH_COMMIT_SIZE);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static boolean canBeTrimmed(int n, boolean bl, Value ... valueArray) {
        TrimContext trimContext = TrimmableDbTable.trimContext.get();
        trimContext.lastBatchMarker = valueArray[0].getLong();
        boolean bl2 = false;
        if (!Arrays.equals(trimContext.prevRowKey, valueArray)) {
            trimContext.prevRowKey = valueArray;
            trimContext.isDeleted = n < trimContext.trimHeight && !bl;
            trimContext.isHighestRowBeforeTrimSkipped = false;
        }
        if (n < trimContext.trimHeight && n >= 0) {
            if (trimContext.isDeleted) {
                bl2 = true;
            } else if (trimContext.isHighestRowBeforeTrimSkipped) {
                bl2 = true;
            } else {
                trimContext.isHighestRowBeforeTrimSkipped = true;
            }
        }
        return bl2;
    }

    private static /* synthetic */ String[] lambda$checkFastTrimIndex$0(int n) {
        return new String[n];
    }

    private static class TrimContext {
        private int trimHeight;
        private Value[] prevRowKey;
        private boolean isDeleted;
        private boolean isHighestRowBeforeTrimSkipped;
        private long lastBatchMarker;

        private TrimContext() {
        }
    }
}

