/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public interface DbKey {
    public int setPK(PreparedStatement var1) throws SQLException;

    public int setPK(PreparedStatement var1, int var2) throws SQLException;

    public static final class LinkKey
    implements DbKey {
        private final long idA;
        private final long idB;

        private LinkKey(long l, long l2) {
            this.idA = l;
            this.idB = l2;
        }

        public long[] getId() {
            return new long[]{this.idA, this.idB};
        }

        @Override
        public int setPK(PreparedStatement preparedStatement) throws SQLException {
            return this.setPK(preparedStatement, 1);
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.idA);
            preparedStatement.setLong(n + 1, this.idB);
            return n + 2;
        }

        public boolean equals(Object object) {
            return object instanceof LinkKey && ((LinkKey)object).idA == this.idA && ((LinkKey)object).idB == this.idB;
        }

        public int hashCode() {
            return (int)(this.idA ^ this.idA >>> 32) ^ (int)(this.idB ^ this.idB >>> 32);
        }
    }

    public static final class StringKey
    implements DbKey {
        private final String id;

        private StringKey(String string) {
            this.id = string;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public int setPK(PreparedStatement preparedStatement) throws SQLException {
            return this.setPK(preparedStatement, 1);
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setString(n, this.id);
            return n + 1;
        }

        public boolean equals(Object object) {
            return object instanceof StringKey && (this.id != null ? this.id.equals(((StringKey)object).id) : ((StringKey)object).id == null);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }
    }

    public static final class LongKey
    implements DbKey {
        private final long id;

        private LongKey(long l) {
            this.id = l;
        }

        public long getId() {
            return this.id;
        }

        @Override
        public int setPK(PreparedStatement preparedStatement) throws SQLException {
            return this.setPK(preparedStatement, 1);
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.id);
            return n + 1;
        }

        public boolean equals(Object object) {
            return object instanceof LongKey && ((LongKey)object).id == this.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }
    }

    public static abstract class LinkKeyFactory<T>
    extends Factory<T> {
        private final String idColumnA;
        private final String idColumnB;

        public LinkKeyFactory(String string, String string2) {
            super(" WHERE " + string + " = ? AND " + string2 + " = ? ", string + ", " + string2, " a." + string + " = b." + string + " AND a." + string2 + " = b." + string2 + " ");
            this.idColumnA = string;
            this.idColumnB = string2;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new LinkKey(resultSet.getLong(this.idColumnA), resultSet.getLong(this.idColumnB));
        }

        public DbKey newKey(long l, long l2) {
            return new LinkKey(l, l2);
        }
    }

    public static abstract class StringKeyFactory<T>
    extends Factory<T> {
        private final String idColumn;

        public StringKeyFactory(String string) {
            super(" WHERE " + string + " = ? ", string, " a." + string + " = b." + string + " ");
            this.idColumn = string;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new StringKey(resultSet.getString(this.idColumn));
        }

        @Override
        public DbKey newKey(String string) {
            return new StringKey(string);
        }
    }

    public static abstract class LongKeyFactory<T>
    extends Factory<T> {
        private final String idColumn;

        public LongKeyFactory(String string) {
            super(" WHERE " + string + " = ? ", string, " a." + string + " = b." + string + " ");
            this.idColumn = string;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new LongKey(resultSet.getLong(this.idColumn));
        }

        @Override
        public DbKey newKey(long l) {
            return new LongKey(l);
        }
    }

    public static abstract class Factory<T> {
        private final String pkClause;
        private final String pkColumns;
        private final String selfJoinClause;

        protected Factory(String string, String string2, String string3) {
            this.pkClause = string;
            this.pkColumns = string2;
            this.selfJoinClause = string3;
        }

        public abstract DbKey newKey(T var1);

        public abstract DbKey newKey(ResultSet var1) throws SQLException;

        public T newEntity(DbKey dbKey) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public final String getPKClause() {
            return this.pkClause;
        }

        public final String getPKColumns() {
            return this.pkColumns;
        }

        public final String getSelfJoinClause() {
            return this.selfJoinClause;
        }
    }
}

