/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class DbClause {
    private final String clause;
    public static final DbClause EMPTY_CLAUSE = new FixedClause(" TRUE ");

    protected DbClause(String string) {
        this.clause = string;
    }

    final String getClause() {
        return this.clause;
    }

    protected abstract int set(PreparedStatement var1, int var2) throws SQLException;

    public DbClause and(final DbClause dbClause) {
        return new DbClause(this.clause + " AND " + dbClause.clause){

            @Override
            protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
                n = DbClause.this.set(preparedStatement, n);
                n = dbClause.set(preparedStatement, n);
                return n;
            }
        };
    }

    public static final class BooleanClause
    extends DbClause {
        private final boolean value;

        public BooleanClause(String string, boolean bl) {
            super(" " + string + " = ? ");
            this.value = bl;
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setBoolean(n, this.value);
            return n + 1;
        }
    }

    public static final class ByteClause
    extends DbClause {
        private final byte value;

        public ByteClause(String string, byte by) {
            super(" " + string + " = ? ");
            this.value = by;
        }

        public ByteClause(String string, Op op, byte by) {
            super(" " + string + op.operator() + "? ");
            this.value = by;
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setByte(n, this.value);
            return n + 1;
        }
    }

    public static final class IntClause
    extends DbClause {
        private final int value;

        public IntClause(String string, int n) {
            super(" " + string + " = ? ");
            this.value = n;
        }

        public IntClause(String string, Op op, int n) {
            super(" " + string + op.operator() + "? ");
            this.value = n;
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setInt(n, this.value);
            return n + 1;
        }
    }

    public static final class LongClause
    extends DbClause {
        private final long value;

        public LongClause(String string, long l) {
            super(" " + string + " = ? ");
            this.value = l;
        }

        public LongClause(String string, Op op, long l) {
            super(" " + string + op.operator() + "? ");
            this.value = l;
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.value);
            return n + 1;
        }
    }

    public static final class LikeClause
    extends DbClause {
        private final String prefix;

        public LikeClause(String string, String string2) {
            super(" " + string + " LIKE ? ");
            this.prefix = string2.replace("%", "\\%").replace("_", "\\_") + "%";
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setString(n, this.prefix);
            return n + 1;
        }
    }

    public static final class StringClause
    extends DbClause {
        private final String value;

        public StringClause(String string, String string2) {
            super(" " + string + " = ? ");
            this.value = string2;
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setString(n, this.value);
            return n + 1;
        }
    }

    public static final class NotNullClause
    extends DbClause {
        public NotNullClause(String string) {
            super(" " + string + " IS NOT NULL ");
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) {
            return n;
        }
    }

    public static final class NullClause
    extends DbClause {
        public NullClause(String string) {
            super(" " + string + " IS NULL ");
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) {
            return n;
        }
    }

    public static final class FixedClause
    extends DbClause {
        public FixedClause(String string) {
            super(string);
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) {
            return n;
        }
    }

    public static enum Op {
        LT("<"),
        LTE("<="),
        GT(">"),
        GTE(">="),
        NE("<>");

        private final String operator;

        private Op(String string2) {
            this.operator = string2;
        }

        public String operator() {
            return this.operator;
        }
    }
}

