/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

final class ReedSolomon {
    private static final int[] initial_codeword = new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] gexp = new int[]{1, 2, 4, 8, 16, 5, 10, 20, 13, 26, 17, 7, 14, 28, 29, 31, 27, 19, 3, 6, 12, 24, 21, 15, 30, 25, 23, 11, 22, 9, 18, 1};
    private static final int[] glog = new int[]{0, 0, 1, 18, 2, 5, 19, 11, 3, 29, 6, 27, 20, 8, 12, 23, 4, 10, 30, 17, 7, 22, 28, 26, 21, 25, 9, 16, 13, 14, 24, 15};
    private static final int[] codeword_map = new int[]{3, 2, 1, 0, 7, 6, 5, 4, 13, 14, 15, 16, 12, 8, 9, 10, 11};
    private static final String alphabet = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    private static final int base_32_length = 13;
    private static final int base_10_length = 20;

    static String encode(long l) {
        int n;
        int n2;
        int n3;
        String string = Long.toUnsignedString(l);
        int n4 = string.length();
        int[] nArray = new int[20];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = string.charAt(n3) - 48;
        }
        n3 = 0;
        int[] nArray2 = new int[initial_codeword.length];
        do {
            int n5 = 0;
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                if ((n2 = n2 * 10 + nArray[n]) >= 32) {
                    nArray[n5] = n2 >> 5;
                    n2 &= 0x1F;
                    ++n5;
                    continue;
                }
                if (n5 <= 0) continue;
                nArray[n5] = 0;
                ++n5;
            }
            n4 = n5;
            nArray2[n3] = n2;
            ++n3;
        } while (n4 > 0);
        int[] nArray3 = new int[]{0, 0, 0, 0};
        for (n2 = 12; n2 >= 0; --n2) {
            n = nArray2[n2] ^ nArray3[3];
            nArray3[3] = nArray3[2] ^ ReedSolomon.gmult(30, n);
            nArray3[2] = nArray3[1] ^ ReedSolomon.gmult(6, n);
            nArray3[1] = nArray3[0] ^ ReedSolomon.gmult(9, n);
            nArray3[0] = ReedSolomon.gmult(17, n);
        }
        System.arraycopy(nArray3, 0, nArray2, 13, initial_codeword.length - 13);
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < 17; ++n) {
            int n6 = codeword_map[n];
            int n7 = nArray2[n6];
            stringBuilder.append(alphabet.charAt(n7));
            if ((n & 3) != 3 || n >= 13) continue;
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }

    static long decode(String string) throws DecodeException {
        int n;
        int n2;
        int[] nArray = new int[initial_codeword.length];
        System.arraycopy(initial_codeword, 0, nArray, 0, initial_codeword.length);
        int n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            int n4 = alphabet.indexOf(string.charAt(n2));
            if (n4 <= -1 || n4 > alphabet.length()) continue;
            if (n3 > 16) {
                throw new CodewordTooLongException();
            }
            n = codeword_map[n3];
            nArray[n] = n4;
            ++n3;
        }
        if (n3 == 17 && !ReedSolomon.is_codeword_valid(nArray) || n3 != 17) {
            throw new CodewordInvalidException();
        }
        n2 = 13;
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = nArray[n2 - n - 1];
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < n2; ++i) {
                if ((n6 = n6 * 32 + nArray2[i]) >= 10) {
                    nArray2[n5] = n6 / 10;
                    n6 %= 10;
                    ++n5;
                    continue;
                }
                if (n5 <= 0) continue;
                nArray2[n5] = 0;
                ++n5;
            }
            n2 = n5;
            stringBuilder.append((char)(n6 + 48));
        } while (n2 > 0);
        return Long.parseUnsignedLong(stringBuilder.reverse().toString());
    }

    private static int gmult(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        int n3 = (glog[n] + glog[n2]) % 31;
        return gexp[n3];
    }

    private static boolean is_codeword_valid(int[] nArray) {
        boolean bl = false;
        for (int i = 1; i < 5; ++i) {
            int n = 0;
            for (int j = 0; j < 31; ++j) {
                if (j > 12 && j < 27) continue;
                int n2 = j;
                if (j > 26) {
                    n2 -= 14;
                }
                n ^= ReedSolomon.gmult(nArray[n2], gexp[i * j % 31]);
            }
            bl |= n;
        }
        return !bl;
    }

    private ReedSolomon() {
    }

    static final class CodewordInvalidException
    extends DecodeException {
        CodewordInvalidException() {
        }
    }

    static final class CodewordTooLongException
    extends DecodeException {
        CodewordTooLongException() {
        }
    }

    static abstract class DecodeException
    extends Exception {
        DecodeException() {
        }
    }
}

