/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import nxt.crypto.Crypto;
import nxt.crypto.KNV25;
import nxt.crypto.Scrypt;

public enum HashFunction {
    SHA256(2){

        @Override
        public byte[] hash(byte[] byArray) {
            return Crypto.sha256().digest(byArray);
        }
    }
    ,
    SHA3(3){

        @Override
        public byte[] hash(byte[] byArray) {
            return Crypto.sha3().digest(byArray);
        }
    }
    ,
    SCRYPT(5){

        @Override
        public byte[] hash(byte[] byArray) {
            return threadLocalScrypt.get().hash(byArray);
        }
    }
    ,
    Keccak25(25){

        @Override
        public byte[] hash(byte[] byArray) {
            return KNV25.hash(byArray);
        }
    }
    ,
    RIPEMD160(6){

        @Override
        public byte[] hash(byte[] byArray) {
            return Crypto.ripemd160().digest(byArray);
        }
    }
    ,
    RIPEMD160_SHA256(62){

        @Override
        public byte[] hash(byte[] byArray) {
            return Crypto.ripemd160().digest(Crypto.sha256().digest(byArray));
        }
    };

    private static final ThreadLocal<Scrypt> threadLocalScrypt;
    private final byte id;

    private HashFunction(byte by) {
        this.id = by;
    }

    public static HashFunction getHashFunction(byte by) {
        for (HashFunction hashFunction : HashFunction.values()) {
            if (hashFunction.id != by) continue;
            return hashFunction;
        }
        throw new IllegalArgumentException(String.format("illegal algorithm %d", by));
    }

    public byte getId() {
        return this.id;
    }

    public abstract byte[] hash(byte[] var1);

    static {
        threadLocalScrypt = ThreadLocal.withInitial(Scrypt::new);
    }
}

