/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import nxt.NxtException;
import nxt.crypto.Crypto;
import nxt.util.Convert;

public final class EncryptedData {
    public static final EncryptedData EMPTY_DATA = new EncryptedData(new byte[0], new byte[0]);
    private final byte[] data;
    private final byte[] nonce;

    public static EncryptedData encrypt(byte[] byArray, String string, byte[] byArray2) {
        if (byArray.length == 0) {
            return EMPTY_DATA;
        }
        byte[] byArray3 = new byte[32];
        Crypto.getSecureRandom().nextBytes(byArray3);
        byte[] byArray4 = Crypto.getSharedKey(Crypto.getPrivateKey(string), byArray2, byArray3);
        byte[] byArray5 = Crypto.aesEncrypt(byArray, byArray4);
        return new EncryptedData(byArray5, byArray3);
    }

    public static EncryptedData readEncryptedData(ByteBuffer byteBuffer, int n, int n2) throws NxtException.NotValidException {
        if (n == 0) {
            return EMPTY_DATA;
        }
        if (n > n2) {
            throw new NxtException.NotValidException("Max encrypted data length exceeded: " + n);
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        byte[] byArray2 = new byte[32];
        byteBuffer.get(byArray2);
        return new EncryptedData(byArray, byArray2);
    }

    public static EncryptedData readEncryptedData(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY_DATA;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            return EncryptedData.readEncryptedData(byteBuffer, byArray.length - 32, Integer.MAX_VALUE);
        }
        catch (NxtException.NotValidException notValidException) {
            throw new RuntimeException(notValidException.toString(), notValidException);
        }
    }

    public static int getEncryptedDataLength(byte[] byArray) {
        if (byArray.length == 0) {
            return 0;
        }
        return Crypto.aesEncrypt(byArray, new byte[32]).length;
    }

    public static int getEncryptedSize(byte[] byArray) {
        if (byArray.length == 0) {
            return 0;
        }
        return EncryptedData.getEncryptedDataLength(byArray) + 32;
    }

    public EncryptedData(byte[] byArray, byte[] byArray2) {
        this.data = byArray;
        this.nonce = byArray2;
    }

    public byte[] decrypt(String string, byte[] byArray) {
        if (this.data.length == 0) {
            return this.data;
        }
        byte[] byArray2 = Crypto.getSharedKey(Crypto.getPrivateKey(string), byArray, this.nonce);
        return Crypto.aesDecrypt(this.data, byArray2);
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public int getSize() {
        return this.data.length + this.nonce.length;
    }

    public byte[] getBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.nonce.length + this.data.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(this.data);
        byteBuffer.put(this.nonce);
        return byteBuffer.array();
    }

    public String toString() {
        return "data: " + Convert.toHexString(this.data) + " nonce: " + Convert.toHexString(this.nonce);
    }
}

