/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.util.Arrays;

final class Curve25519 {
    public static final int KEY_SIZE = 32;
    public static final byte[] ZERO = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] PRIME = new byte[]{-19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 127};
    public static final byte[] ORDER = new byte[]{-19, -45, -11, 92, 26, 99, 18, 88, -42, -100, -9, -94, -34, -7, -34, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16};
    private static final int P25 = 0x1FFFFFF;
    private static final int P26 = 0x3FFFFFF;
    private static final byte[] ORDER_TIMES_8 = new byte[]{104, -97, -82, -25, -46, 24, -109, -64, -78, -26, -68, 23, -11, -50, -9, -90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128};
    private static final long10 BASE_2Y = new long10(39999547L, 18689728L, 59995525L, 1648697L, 57546132L, 24010086L, 19059592L, 5425144L, 63499247L, 16420658L);
    private static final long10 BASE_R2Y = new long10(5744L, 8160848L, 4790893L, 13779497L, 35730846L, 12541209L, 49101323L, 30047407L, 40071253L, 6226132L);

    Curve25519() {
    }

    public static void clamp(byte[] byArray) {
        byArray[31] = (byte)(byArray[31] & 0x7F);
        byArray[31] = (byte)(byArray[31] | 0x40);
        byArray[0] = (byte)(byArray[0] & 0xF8);
    }

    public static void keygen(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Curve25519.clamp(byArray3);
        Curve25519.core(byArray, byArray2, byArray3, null);
    }

    public static void curve(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Curve25519.core(byArray, null, byArray2, byArray3);
    }

    public static boolean sign(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[32];
        byte[] byArray7 = new byte[64];
        byte[] byArray8 = new byte[64];
        Curve25519.cpy32(byArray5, byArray2);
        Curve25519.cpy32(byArray6, byArray3);
        byte[] byArray9 = new byte[32];
        Curve25519.divmod(byArray9, byArray5, 32, ORDER, 32);
        Curve25519.divmod(byArray9, byArray6, 32, ORDER, 32);
        Curve25519.mula_small(byArray, byArray6, 0, byArray5, 32, -1);
        Curve25519.mula_small(byArray, byArray, 0, ORDER, 32, 1);
        Curve25519.mula32(byArray7, byArray, byArray4, 32, 1);
        Curve25519.divmod(byArray8, byArray7, 64, ORDER, 32);
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            byArray[i] = byArray7[i];
            n |= byArray[i];
        }
        return n != 0;
    }

    public static void verify(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n;
        int n2;
        byte[] byArray5 = new byte[32];
        long10[] long10Array = new long10[]{new long10(), new long10()};
        long10[] long10Array2 = new long10[]{new long10(), new long10()};
        long10[] long10Array3 = new long10[]{new long10(), new long10(), new long10()};
        long10[] long10Array4 = new long10[]{new long10(), new long10(), new long10()};
        long10[] long10Array5 = new long10[]{new long10(), new long10(), new long10()};
        long10[] long10Array6 = new long10[]{new long10(), new long10(), new long10()};
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Curve25519.set(long10Array[0], 9);
        Curve25519.unpack(long10Array[1], byArray4);
        Curve25519.x_to_y2(long10Array5[0], long10Array6[0], long10Array[1]);
        Curve25519.sqrt(long10Array5[0], long10Array6[0]);
        int n7 = Curve25519.is_negative(long10Array5[0]);
        long10Array6[0]._0 += 39420360L;
        Curve25519.mul(long10Array6[1], BASE_2Y, long10Array5[0]);
        Curve25519.sub(long10Array5[n7], long10Array6[0], long10Array6[1]);
        Curve25519.add(long10Array5[1 - n7], long10Array6[0], long10Array6[1]);
        Curve25519.cpy(long10Array6[0], long10Array[1]);
        long10Array6[0]._0 -= 9L;
        Curve25519.sqr(long10Array6[1], long10Array6[0]);
        Curve25519.recip(long10Array6[0], long10Array6[1], 0);
        Curve25519.mul(long10Array2[0], long10Array5[0], long10Array6[0]);
        Curve25519.sub(long10Array2[0], long10Array2[0], long10Array[1]);
        long10Array2[0]._0 -= 486671L;
        Curve25519.mul(long10Array2[1], long10Array5[1], long10Array6[0]);
        Curve25519.sub(long10Array2[1], long10Array2[1], long10Array[1]);
        long10Array2[1]._0 -= 486671L;
        Curve25519.mul_small(long10Array2[0], long10Array2[0], 1L);
        Curve25519.mul_small(long10Array2[1], long10Array2[1], 1L);
        for (n2 = 0; n2 < 32; ++n2) {
            n3 = n3 >> 8 ^ byArray2[n2] & 0xFF ^ (byArray2[n2] & 0xFF) << 1;
            n4 = n4 >> 8 ^ byArray3[n2] & 0xFF ^ (byArray3[n2] & 0xFF) << 1;
            n6 = ~(n3 ^ n4);
            n5 = n6 & (n5 & 0x80) >> 7 ^ n3;
            n5 ^= n6 & (n5 & 1) << 1;
            n5 ^= n6 & (n5 & 2) << 1;
            n5 ^= n6 & (n5 & 4) << 1;
            n5 ^= n6 & (n5 & 8) << 1;
            n5 ^= n6 & (n5 & 0x10) << 1;
            n5 ^= n6 & (n5 & 0x20) << 1;
            n5 ^= n6 & (n5 & 0x40) << 1;
            byArray5[n2] = (byte)n5;
        }
        n5 = (n6 & (n5 & 0x80) << 1 ^ n3) >> 8;
        Curve25519.set(long10Array3[0], 1);
        Curve25519.cpy(long10Array3[1], long10Array[n5]);
        Curve25519.cpy(long10Array3[2], long10Array2[0]);
        Curve25519.set(long10Array4[0], 0);
        Curve25519.set(long10Array4[1], 1);
        Curve25519.set(long10Array4[2], 1);
        n3 = 0;
        n4 = 0;
        n2 = 32;
        while (n2-- != 0) {
            n3 = n3 << 8 | byArray2[n2] & 0xFF;
            n4 = n4 << 8 | byArray3[n2] & 0xFF;
            n5 = n5 << 8 | byArray5[n2] & 0xFF;
            n7 = 8;
            while (n7-- != 0) {
                Curve25519.mont_prep(long10Array5[0], long10Array6[0], long10Array3[0], long10Array4[0]);
                Curve25519.mont_prep(long10Array5[1], long10Array6[1], long10Array3[1], long10Array4[1]);
                Curve25519.mont_prep(long10Array5[2], long10Array6[2], long10Array3[2], long10Array4[2]);
                n = ((n3 ^ n3 >> 1) >> n7 & 1) + ((n4 ^ n4 >> 1) >> n7 & 1);
                Curve25519.mont_dbl(long10Array3[2], long10Array4[2], long10Array5[n], long10Array6[n], long10Array3[0], long10Array4[0]);
                n = n5 >> n7 & 2 ^ (n5 >> n7 & 1) << 1;
                Curve25519.mont_add(long10Array5[1], long10Array6[1], long10Array5[n], long10Array6[n], long10Array3[1], long10Array4[1], long10Array[n5 >> n7 & 1]);
                Curve25519.mont_add(long10Array5[2], long10Array6[2], long10Array5[0], long10Array6[0], long10Array3[2], long10Array4[2], long10Array2[((n3 ^ n4) >> n7 & 2) >> 1]);
            }
        }
        n = (n3 & 1) + (n4 & 1);
        Curve25519.recip(long10Array5[0], long10Array4[n], 0);
        Curve25519.mul(long10Array5[1], long10Array3[n], long10Array5[0]);
        Curve25519.pack(long10Array5[1], byArray);
    }

    public static boolean isCanonicalSignature(byte[] byArray) {
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 32);
        byte[] byArray3 = new byte[32];
        Curve25519.divmod(byArray3, byArray2, 32, ORDER, 32);
        for (int i = 0; i < 32; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isCanonicalPublicKey(byte[] byArray) {
        if (byArray.length != 32) {
            return false;
        }
        long10 long102 = new long10();
        Curve25519.unpack(long102, byArray);
        byte[] byArray2 = new byte[32];
        Curve25519.pack(long102, byArray2);
        for (int i = 0; i < 32; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    private static void cpy32(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < 32; ++i) {
            byArray[i] = byArray2[i];
        }
    }

    private static int mula_small(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            byArray[i + n] = (byte)(n4 += (byArray2[i + n] & 0xFF) + n3 * (byArray3[i] & 0xFF));
            n4 >>= 8;
        }
        return n4;
    }

    private static int mula32(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            int n5 = n2 * (byArray3[n3] & 0xFF);
            byArray[n3 + 31] = (byte)(n4 += Curve25519.mula_small(byArray, byArray, n3, byArray2, 31, n5) + (byArray[n3 + 31] & 0xFF) + n5 * (byArray2[31] & 0xFF));
            n4 >>= 8;
        }
        byArray[n3 + 31] = (byte)(n4 + (byArray[n3 + 31] & 0xFF));
        return n4 >> 8;
    }

    private static void divmod(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2) {
        int n3 = 0;
        int n4 = (byArray3[n2 - 1] & 0xFF) << 8;
        if (n2 > 1) {
            n4 |= byArray3[n2 - 2] & 0xFF;
        }
        while (n-- >= n2) {
            int n5 = n3 << 16 | (byArray2[n] & 0xFF) << 8;
            if (n > 0) {
                n5 |= byArray2[n - 1] & 0xFF;
            }
            byArray[n - n2 + 1] = (byte)(n5 + (n3 += Curve25519.mula_small(byArray2, byArray2, n - n2 + 1, byArray3, n2, -(n5 /= n4))) & 0xFF);
            Curve25519.mula_small(byArray2, byArray2, n - n2 + 1, byArray3, n2, -n3);
            n3 = byArray2[n] & 0xFF;
            byArray2[n] = 0;
        }
        byArray2[n2 - 1] = (byte)n3;
    }

    private static int numsize(byte[] byArray, int n) {
        while (n-- != 0 && byArray[n] == 0) {
        }
        return n + 1;
    }

    private static byte[] egcd32(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n = 32;
        for (int i = 0; i < 32; ++i) {
            byArray2[i] = 0;
            byArray[i] = 0;
        }
        byArray[0] = 1;
        int n2 = Curve25519.numsize(byArray3, 32);
        if (n2 == 0) {
            return byArray2;
        }
        byte[] byArray5 = new byte[32];
        while (true) {
            int n3 = n - n2 + 1;
            Curve25519.divmod(byArray5, byArray4, n, byArray3, n2);
            n = Curve25519.numsize(byArray4, n);
            if (n == 0) {
                return byArray;
            }
            Curve25519.mula32(byArray2, byArray, byArray5, n3, -1);
            n3 = n2 - n + 1;
            Curve25519.divmod(byArray5, byArray3, n2, byArray4, n);
            n2 = Curve25519.numsize(byArray3, n2);
            if (n2 == 0) {
                return byArray2;
            }
            Curve25519.mula32(byArray, byArray2, byArray5, n3, -1);
        }
    }

    private static void unpack(long10 long102, byte[] byArray) {
        long102._0 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF & 3) << 24;
        long102._1 = (byArray[3] & 0xFF & 0xFFFFFFFC) >> 2 | (byArray[4] & 0xFF) << 6 | (byArray[5] & 0xFF) << 14 | (byArray[6] & 0xFF & 7) << 22;
        long102._2 = (byArray[6] & 0xFF & 0xFFFFFFF8) >> 3 | (byArray[7] & 0xFF) << 5 | (byArray[8] & 0xFF) << 13 | (byArray[9] & 0xFF & 0x1F) << 21;
        long102._3 = (byArray[9] & 0xFF & 0xFFFFFFE0) >> 5 | (byArray[10] & 0xFF) << 3 | (byArray[11] & 0xFF) << 11 | (byArray[12] & 0xFF & 0x3F) << 19;
        long102._4 = (byArray[12] & 0xFF & 0xFFFFFFC0) >> 6 | (byArray[13] & 0xFF) << 2 | (byArray[14] & 0xFF) << 10 | (byArray[15] & 0xFF) << 18;
        long102._5 = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8 | (byArray[18] & 0xFF) << 16 | (byArray[19] & 0xFF & 1) << 24;
        long102._6 = (byArray[19] & 0xFF & 0xFFFFFFFE) >> 1 | (byArray[20] & 0xFF) << 7 | (byArray[21] & 0xFF) << 15 | (byArray[22] & 0xFF & 7) << 23;
        long102._7 = (byArray[22] & 0xFF & 0xFFFFFFF8) >> 3 | (byArray[23] & 0xFF) << 5 | (byArray[24] & 0xFF) << 13 | (byArray[25] & 0xFF & 0xF) << 21;
        long102._8 = (byArray[25] & 0xFF & 0xFFFFFFF0) >> 4 | (byArray[26] & 0xFF) << 4 | (byArray[27] & 0xFF) << 12 | (byArray[28] & 0xFF & 0x3F) << 20;
        long102._9 = (byArray[28] & 0xFF & 0xFFFFFFC0) >> 6 | (byArray[29] & 0xFF) << 2 | (byArray[30] & 0xFF) << 10 | (byArray[31] & 0xFF) << 18;
    }

    private static boolean is_overflow(long10 long102) {
        return long102._0 > 67108844L && (long102._1 & long102._3 & long102._5 & long102._7 & long102._9) == 0x1FFFFFFL && (long102._2 & long102._4 & long102._6 & long102._8) == 0x3FFFFFFL || long102._9 > 0x1FFFFFFL;
    }

    private static void pack(long10 long102, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        n = (Curve25519.is_overflow(long102) ? 1 : 0) - (long102._9 < 0L ? 1 : 0);
        n2 = n * -33554432;
        long l = (long)(n *= 19) + long102._0 + (long102._1 << 26);
        byArray[0] = (byte)l;
        byArray[1] = (byte)(l >> 8);
        byArray[2] = (byte)(l >> 16);
        byArray[3] = (byte)(l >> 24);
        l = (l >> 32) + (long102._2 << 19);
        byArray[4] = (byte)l;
        byArray[5] = (byte)(l >> 8);
        byArray[6] = (byte)(l >> 16);
        byArray[7] = (byte)(l >> 24);
        l = (l >> 32) + (long102._3 << 13);
        byArray[8] = (byte)l;
        byArray[9] = (byte)(l >> 8);
        byArray[10] = (byte)(l >> 16);
        byArray[11] = (byte)(l >> 24);
        l = (l >> 32) + (long102._4 << 6);
        byArray[12] = (byte)l;
        byArray[13] = (byte)(l >> 8);
        byArray[14] = (byte)(l >> 16);
        byArray[15] = (byte)(l >> 24);
        l = (l >> 32) + long102._5 + (long102._6 << 25);
        byArray[16] = (byte)l;
        byArray[17] = (byte)(l >> 8);
        byArray[18] = (byte)(l >> 16);
        byArray[19] = (byte)(l >> 24);
        l = (l >> 32) + (long102._7 << 19);
        byArray[20] = (byte)l;
        byArray[21] = (byte)(l >> 8);
        byArray[22] = (byte)(l >> 16);
        byArray[23] = (byte)(l >> 24);
        l = (l >> 32) + (long102._8 << 12);
        byArray[24] = (byte)l;
        byArray[25] = (byte)(l >> 8);
        byArray[26] = (byte)(l >> 16);
        byArray[27] = (byte)(l >> 24);
        l = (l >> 32) + (long102._9 + (long)n2 << 6);
        byArray[28] = (byte)l;
        byArray[29] = (byte)(l >> 8);
        byArray[30] = (byte)(l >> 16);
        byArray[31] = (byte)(l >> 24);
    }

    private static void cpy(long10 long102, long10 long103) {
        long102._0 = long103._0;
        long102._1 = long103._1;
        long102._2 = long103._2;
        long102._3 = long103._3;
        long102._4 = long103._4;
        long102._5 = long103._5;
        long102._6 = long103._6;
        long102._7 = long103._7;
        long102._8 = long103._8;
        long102._9 = long103._9;
    }

    private static void set(long10 long102, int n) {
        long102._0 = n;
        long102._1 = 0L;
        long102._2 = 0L;
        long102._3 = 0L;
        long102._4 = 0L;
        long102._5 = 0L;
        long102._6 = 0L;
        long102._7 = 0L;
        long102._8 = 0L;
        long102._9 = 0L;
    }

    private static void add(long10 long102, long10 long103, long10 long104) {
        long102._0 = long103._0 + long104._0;
        long102._1 = long103._1 + long104._1;
        long102._2 = long103._2 + long104._2;
        long102._3 = long103._3 + long104._3;
        long102._4 = long103._4 + long104._4;
        long102._5 = long103._5 + long104._5;
        long102._6 = long103._6 + long104._6;
        long102._7 = long103._7 + long104._7;
        long102._8 = long103._8 + long104._8;
        long102._9 = long103._9 + long104._9;
    }

    private static void sub(long10 long102, long10 long103, long10 long104) {
        long102._0 = long103._0 - long104._0;
        long102._1 = long103._1 - long104._1;
        long102._2 = long103._2 - long104._2;
        long102._3 = long103._3 - long104._3;
        long102._4 = long103._4 - long104._4;
        long102._5 = long103._5 - long104._5;
        long102._6 = long103._6 - long104._6;
        long102._7 = long103._7 - long104._7;
        long102._8 = long103._8 - long104._8;
        long102._9 = long103._9 - long104._9;
    }

    private static long10 mul_small(long10 long102, long10 long103, long l) {
        long l2 = long103._8 * l;
        long102._8 = l2 & 0x3FFFFFFL;
        l2 = (l2 >> 26) + long103._9 * l;
        long102._9 = l2 & 0x1FFFFFFL;
        l2 = 19L * (l2 >> 25) + long103._0 * l;
        long102._0 = l2 & 0x3FFFFFFL;
        l2 = (l2 >> 26) + long103._1 * l;
        long102._1 = l2 & 0x1FFFFFFL;
        l2 = (l2 >> 25) + long103._2 * l;
        long102._2 = l2 & 0x3FFFFFFL;
        l2 = (l2 >> 26) + long103._3 * l;
        long102._3 = l2 & 0x1FFFFFFL;
        l2 = (l2 >> 25) + long103._4 * l;
        long102._4 = l2 & 0x3FFFFFFL;
        l2 = (l2 >> 26) + long103._5 * l;
        long102._5 = l2 & 0x1FFFFFFL;
        l2 = (l2 >> 25) + long103._6 * l;
        long102._6 = l2 & 0x3FFFFFFL;
        l2 = (l2 >> 26) + long103._7 * l;
        long102._7 = l2 & 0x1FFFFFFL;
        l2 = (l2 >> 25) + long102._8;
        long102._8 = l2 & 0x3FFFFFFL;
        long102._9 += l2 >> 26;
        return long102;
    }

    private static long10 mul(long10 long102, long10 long103, long10 long104) {
        long l = long103._0;
        long l2 = long103._1;
        long l3 = long103._2;
        long l4 = long103._3;
        long l5 = long103._4;
        long l6 = long103._5;
        long l7 = long103._6;
        long l8 = long103._7;
        long l9 = long103._8;
        long l10 = long103._9;
        long l11 = long104._0;
        long l12 = long104._1;
        long l13 = long104._2;
        long l14 = long104._3;
        long l15 = long104._4;
        long l16 = long104._5;
        long l17 = long104._6;
        long l18 = long104._7;
        long l19 = long104._8;
        long l20 = long104._9;
        long l21 = l * l19 + l3 * l17 + l5 * l15 + l7 * l13 + l9 * l11 + 2L * (l2 * l18 + l4 * l16 + l6 * l14 + l8 * l12) + 38L * (l10 * l20);
        long102._8 = l21 & 0x3FFFFFFL;
        l21 = (l21 >> 26) + l * l20 + l2 * l19 + l3 * l18 + l4 * l17 + l5 * l16 + l6 * l15 + l7 * l14 + l8 * l13 + l9 * l12 + l10 * l11;
        long102._9 = l21 & 0x1FFFFFFL;
        l21 = l * l11 + 19L * ((l21 >> 25) + l3 * l19 + l5 * l17 + l7 * l15 + l9 * l13) + 38L * (l2 * l20 + l4 * l18 + l6 * l16 + l8 * l14 + l10 * l12);
        long102._0 = l21 & 0x3FFFFFFL;
        l21 = (l21 >> 26) + l * l12 + l2 * l11 + 19L * (l3 * l20 + l4 * l19 + l5 * l18 + l6 * l17 + l7 * l16 + l8 * l15 + l9 * l14 + l10 * l13);
        long102._1 = l21 & 0x1FFFFFFL;
        l21 = (l21 >> 25) + l * l13 + l3 * l11 + 19L * (l5 * l19 + l7 * l17 + l9 * l15) + 2L * (l2 * l12) + 38L * (l4 * l20 + l6 * l18 + l8 * l16 + l10 * l14);
        long102._2 = l21 & 0x3FFFFFFL;
        l21 = (l21 >> 26) + l * l14 + l2 * l13 + l3 * l12 + l4 * l11 + 19L * (l5 * l20 + l6 * l19 + l7 * l18 + l8 * l17 + l9 * l16 + l10 * l15);
        long102._3 = l21 & 0x1FFFFFFL;
        l21 = (l21 >> 25) + l * l15 + l3 * l13 + l5 * l11 + 19L * (l7 * l19 + l9 * l17) + 2L * (l2 * l14 + l4 * l12) + 38L * (l6 * l20 + l8 * l18 + l10 * l16);
        long102._4 = l21 & 0x3FFFFFFL;
        l21 = (l21 >> 26) + l * l16 + l2 * l15 + l3 * l14 + l4 * l13 + l5 * l12 + l6 * l11 + 19L * (l7 * l20 + l8 * l19 + l9 * l18 + l10 * l17);
        long102._5 = l21 & 0x1FFFFFFL;
        l21 = (l21 >> 25) + l * l17 + l3 * l15 + l5 * l13 + l7 * l11 + 19L * (l9 * l19) + 2L * (l2 * l16 + l4 * l14 + l6 * l12) + 38L * (l8 * l20 + l10 * l18);
        long102._6 = l21 & 0x3FFFFFFL;
        l21 = (l21 >> 26) + l * l18 + l2 * l17 + l3 * l16 + l4 * l15 + l5 * l14 + l6 * l13 + l7 * l12 + l8 * l11 + 19L * (l9 * l20 + l10 * l19);
        long102._7 = l21 & 0x1FFFFFFL;
        l21 = (l21 >> 25) + long102._8;
        long102._8 = l21 & 0x3FFFFFFL;
        long102._9 += l21 >> 26;
        return long102;
    }

    private static long10 sqr(long10 long102, long10 long103) {
        long l = long103._0;
        long l2 = long103._1;
        long l3 = long103._2;
        long l4 = long103._3;
        long l5 = long103._4;
        long l6 = long103._5;
        long l7 = long103._6;
        long l8 = long103._7;
        long l9 = long103._8;
        long l10 = long103._9;
        long l11 = l5 * l5 + 2L * (l * l9 + l3 * l7) + 38L * (l10 * l10) + 4L * (l2 * l8 + l4 * l6);
        long102._8 = l11 & 0x3FFFFFFL;
        l11 = (l11 >> 26) + 2L * (l * l10 + l2 * l9 + l3 * l8 + l4 * l7 + l5 * l6);
        long102._9 = l11 & 0x1FFFFFFL;
        l11 = 19L * (l11 >> 25) + l * l + 38L * (l3 * l9 + l5 * l7 + l6 * l6) + 76L * (l2 * l10 + l4 * l8);
        long102._0 = l11 & 0x3FFFFFFL;
        l11 = (l11 >> 26) + 2L * (l * l2) + 38L * (l3 * l10 + l4 * l9 + l5 * l8 + l6 * l7);
        long102._1 = l11 & 0x1FFFFFFL;
        l11 = (l11 >> 25) + 19L * (l7 * l7) + 2L * (l * l3 + l2 * l2) + 38L * (l5 * l9) + 76L * (l4 * l10 + l6 * l8);
        long102._2 = l11 & 0x3FFFFFFL;
        l11 = (l11 >> 26) + 2L * (l * l4 + l2 * l3) + 38L * (l5 * l10 + l6 * l9 + l7 * l8);
        long102._3 = l11 & 0x1FFFFFFL;
        l11 = (l11 >> 25) + l3 * l3 + 2L * (l * l5) + 38L * (l7 * l9 + l8 * l8) + 4L * (l2 * l4) + 76L * (l6 * l10);
        long102._4 = l11 & 0x3FFFFFFL;
        l11 = (l11 >> 26) + 2L * (l * l6 + l2 * l5 + l3 * l4) + 38L * (l7 * l10 + l8 * l9);
        long102._5 = l11 & 0x1FFFFFFL;
        l11 = (l11 >> 25) + 19L * (l9 * l9) + 2L * (l * l7 + l3 * l5 + l4 * l4) + 4L * (l2 * l6) + 76L * (l8 * l10);
        long102._6 = l11 & 0x3FFFFFFL;
        l11 = (l11 >> 26) + 2L * (l * l8 + l2 * l7 + l3 * l6 + l4 * l5) + 38L * (l9 * l10);
        long102._7 = l11 & 0x1FFFFFFL;
        l11 = (l11 >> 25) + long102._8;
        long102._8 = l11 & 0x3FFFFFFL;
        long102._9 += l11 >> 26;
        return long102;
    }

    private static void recip(long10 long102, long10 long103, int n) {
        int n2;
        long10 long104 = new long10();
        long10 long105 = new long10();
        long10 long106 = new long10();
        long10 long107 = new long10();
        long10 long108 = new long10();
        Curve25519.sqr(long105, long103);
        Curve25519.sqr(long106, long105);
        Curve25519.sqr(long104, long106);
        Curve25519.mul(long106, long104, long103);
        Curve25519.mul(long104, long106, long105);
        Curve25519.sqr(long105, long104);
        Curve25519.mul(long107, long105, long106);
        Curve25519.sqr(long105, long107);
        Curve25519.sqr(long106, long105);
        Curve25519.sqr(long105, long106);
        Curve25519.sqr(long106, long105);
        Curve25519.sqr(long105, long106);
        Curve25519.mul(long106, long105, long107);
        Curve25519.sqr(long105, long106);
        Curve25519.sqr(long107, long105);
        for (n2 = 1; n2 < 5; ++n2) {
            Curve25519.sqr(long105, long107);
            Curve25519.sqr(long107, long105);
        }
        Curve25519.mul(long105, long107, long106);
        Curve25519.sqr(long107, long105);
        Curve25519.sqr(long108, long107);
        for (n2 = 1; n2 < 10; ++n2) {
            Curve25519.sqr(long107, long108);
            Curve25519.sqr(long108, long107);
        }
        Curve25519.mul(long107, long108, long105);
        for (n2 = 0; n2 < 5; ++n2) {
            Curve25519.sqr(long105, long107);
            Curve25519.sqr(long107, long105);
        }
        Curve25519.mul(long105, long107, long106);
        Curve25519.sqr(long106, long105);
        Curve25519.sqr(long107, long106);
        for (n2 = 1; n2 < 25; ++n2) {
            Curve25519.sqr(long106, long107);
            Curve25519.sqr(long107, long106);
        }
        Curve25519.mul(long106, long107, long105);
        Curve25519.sqr(long107, long106);
        Curve25519.sqr(long108, long107);
        for (n2 = 1; n2 < 50; ++n2) {
            Curve25519.sqr(long107, long108);
            Curve25519.sqr(long108, long107);
        }
        Curve25519.mul(long107, long108, long106);
        for (n2 = 0; n2 < 25; ++n2) {
            Curve25519.sqr(long108, long107);
            Curve25519.sqr(long107, long108);
        }
        Curve25519.mul(long106, long107, long105);
        Curve25519.sqr(long105, long106);
        Curve25519.sqr(long106, long105);
        if (n != 0) {
            Curve25519.mul(long102, long103, long106);
        } else {
            Curve25519.sqr(long105, long106);
            Curve25519.sqr(long106, long105);
            Curve25519.sqr(long105, long106);
            Curve25519.mul(long102, long105, long104);
        }
    }

    private static int is_negative(long10 long102) {
        return (int)((long)(Curve25519.is_overflow(long102) || long102._9 < 0L ? 1 : 0) ^ long102._0 & 1L);
    }

    private static void sqrt(long10 long102, long10 long103) {
        long10 long104 = new long10();
        long10 long105 = new long10();
        long10 long106 = new long10();
        Curve25519.add(long105, long103, long103);
        Curve25519.recip(long104, long105, 1);
        Curve25519.sqr(long102, long104);
        Curve25519.mul(long106, long105, long102);
        --long106._0;
        Curve25519.mul(long105, long104, long106);
        Curve25519.mul(long102, long103, long105);
    }

    private static void mont_prep(long10 long102, long10 long103, long10 long104, long10 long105) {
        Curve25519.add(long102, long104, long105);
        Curve25519.sub(long103, long104, long105);
    }

    private static void mont_add(long10 long102, long10 long103, long10 long104, long10 long105, long10 long106, long10 long107, long10 long108) {
        Curve25519.mul(long106, long103, long104);
        Curve25519.mul(long107, long102, long105);
        Curve25519.add(long102, long106, long107);
        Curve25519.sub(long103, long106, long107);
        Curve25519.sqr(long106, long102);
        Curve25519.sqr(long102, long103);
        Curve25519.mul(long107, long102, long108);
    }

    private static void mont_dbl(long10 long102, long10 long103, long10 long104, long10 long105, long10 long106, long10 long107) {
        Curve25519.sqr(long102, long104);
        Curve25519.sqr(long103, long105);
        Curve25519.mul(long106, long102, long103);
        Curve25519.sub(long103, long102, long103);
        Curve25519.mul_small(long107, long103, 121665L);
        Curve25519.add(long102, long102, long107);
        Curve25519.mul(long107, long102, long103);
    }

    private static void x_to_y2(long10 long102, long10 long103, long10 long104) {
        Curve25519.sqr(long102, long104);
        Curve25519.mul_small(long103, long104, 486662L);
        Curve25519.add(long102, long102, long103);
        ++long102._0;
        Curve25519.mul(long103, long102, long104);
    }

    private static void core(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        Object object;
        long10 long102 = new long10();
        long10 long103 = new long10();
        long10 long104 = new long10();
        long10 long105 = new long10();
        long10 long106 = new long10();
        long10[] long10Array = new long10[]{new long10(), new long10()};
        long10[] long10Array2 = new long10[]{new long10(), new long10()};
        if (byArray4 != null) {
            Curve25519.unpack(long102, byArray4);
        } else {
            Curve25519.set(long102, 9);
        }
        Curve25519.set(long10Array[0], 1);
        Curve25519.set(long10Array2[0], 0);
        Curve25519.cpy(long10Array[1], long102);
        Curve25519.set(long10Array2[1], 1);
        int n = 32;
        while (n-- != 0) {
            if (n == 0) {
                n = 0;
            }
            int n2 = 8;
            while (n2-- != 0) {
                int n3 = (byArray3[n] & 0xFF) >> n2 & 1;
                int n4 = ~(byArray3[n] & 0xFF) >> n2 & 1;
                object = long10Array[n4];
                long10 long107 = long10Array2[n4];
                long10 long108 = long10Array[n3];
                long10 long109 = long10Array2[n3];
                Curve25519.mont_prep(long103, long104, (long10)object, long107);
                Curve25519.mont_prep(long105, long106, long108, long109);
                Curve25519.mont_add(long103, long104, long105, long106, (long10)object, long107, long102);
                Curve25519.mont_dbl(long103, long104, long105, long106, long108, long109);
            }
        }
        Curve25519.recip(long103, long10Array2[0], 0);
        Curve25519.mul(long102, long10Array[0], long103);
        Curve25519.pack(long102, byArray);
        if (byArray2 != null) {
            Curve25519.x_to_y2(long104, long103, long102);
            Curve25519.recip(long105, long10Array2[1], 0);
            Curve25519.mul(long104, long10Array[1], long105);
            Curve25519.add(long104, long104, long102);
            long104._0 += 486671L;
            long102._0 -= 9L;
            Curve25519.sqr(long105, long102);
            Curve25519.mul(long102, long104, long105);
            Curve25519.sub(long102, long102, long103);
            long102._0 -= 39420360L;
            Curve25519.mul(long103, long102, BASE_R2Y);
            if (Curve25519.is_negative(long103) != 0) {
                Curve25519.cpy32(byArray2, byArray3);
            } else {
                Curve25519.mula_small(byArray2, ORDER_TIMES_8, 0, byArray3, 32, -1);
            }
            byte[] byArray5 = new byte[32];
            byte[] byArray6 = new byte[64];
            object = new byte[64];
            Curve25519.cpy32(byArray5, ORDER);
            Curve25519.cpy32(byArray2, Curve25519.egcd32(byArray6, (byte[])object, byArray2, byArray5));
            if ((byArray2[31] & 0x80) != 0) {
                Curve25519.mula_small(byArray2, byArray2, 0, ORDER, 32, 1);
            }
        }
    }

    private static final class long10 {
        public long _0;
        public long _1;
        public long _2;
        public long _3;
        public long _4;
        public long _5;
        public long _6;
        public long _7;
        public long _8;
        public long _9;

        public long10() {
        }

        public long10(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10) {
            this._0 = l;
            this._1 = l2;
            this._2 = l3;
            this._3 = l4;
            this._4 = l5;
            this._5 = l6;
            this._6 = l7;
            this._7 = l8;
            this._8 = l9;
            this._9 = l10;
        }
    }
}

