/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Generator;
import nxt.addons.AbstractEncryptedConfig;
import nxt.crypto.Crypto;
import nxt.http.APITag;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class ForgingEncryptedConfig
extends AbstractEncryptedConfig {
    public static final String CONFIG_FILE_NAME = "forgers";

    @Override
    protected String getAPIRequestName() {
        return "Forging";
    }

    @Override
    protected APITag getAPITag() {
        return APITag.FORGING;
    }

    @Override
    protected String getDataParameter() {
        return "passphrases";
    }

    @Override
    protected JSONStreamAware processDecrypted(BufferedReader bufferedReader) throws IOException {
        Object object;
        String string;
        int n = 0;
        long l = 0L;
        while ((string = bufferedReader.readLine()) != null && !string.trim().isEmpty()) {
            object = string.trim();
            Generator.startForging((String)object);
            byte[] byArray = Crypto.getPublicKey((String)object);
            Account account = Account.getAccount(byArray);
            if (account == null) {
                Logger.logWarningMessage("Forge request in startForgingEncrypted for nonexistent account " + Convert.toHexString(byArray));
            } else {
                l += account.getEffectiveBalanceNXT();
            }
            ++n;
        }
        object = new JSONObject();
        object.put((Object)"forgersStarted", (Object)n);
        object.put((Object)"totalEffectiveBalance", (Object)String.valueOf(l));
        return object;
    }

    @Override
    protected List<String> getExtraParameters() {
        return Collections.singletonList("minEffectiveBalanceNXT");
    }

    @Override
    protected String getSaveData(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = ParameterParser.getParameter(httpServletRequest, "passphrases");
        long l = ParameterParser.getLong(httpServletRequest, "minEffectiveBalanceNXT", 0L, 1000000000L, false);
        StringWriter stringWriter = new StringWriter();
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
             BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);){
            String string2;
            HashSet<Long> hashSet = new HashSet<Long>();
            while ((string2 = bufferedReader.readLine()) != null) {
                Account account = Account.getAccount(Crypto.getPublicKey(string2));
                if (account == null || account.getEffectiveBalanceNXT() < l || !hashSet.add(account.getId())) continue;
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
        return stringWriter.toString();
    }

    @Override
    protected String getDefaultFilename() {
        return CONFIG_FILE_NAME;
    }
}

