/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nxt.Nxt;
import nxt.addons.AddOn;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.util.Logger;

public final class AddOns {
    private static final List<AddOn> addOns;

    public static void init() {
    }

    public static void shutdown() {
        addOns.forEach(addOn -> {
            Logger.logShutdownMessage("Shutting down " + addOn.getClass().getName());
            addOn.shutdown();
        });
    }

    public static void registerAPIRequestHandlers(Map<String, APIServlet.APIRequestHandler> map) {
        for (AddOn addOn : addOns) {
            Map<String, APIServlet.APIRequestHandler> map2 = addOn.getAPIRequests();
            if (map2 != null) {
                map2 = new LinkedHashMap<String, APIServlet.APIRequestHandler>(map2);
            }
            APIServlet.APIRequestHandler aPIRequestHandler = addOn.getAPIRequestHandler();
            String string = addOn.getAPIRequestType();
            if (aPIRequestHandler != null && string != null) {
                if (map2 == null) {
                    map2 = new HashMap<String, APIServlet.APIRequestHandler>();
                }
                map2.put(string, aPIRequestHandler);
            }
            if (map2 == null) continue;
            for (Map.Entry<String, APIServlet.APIRequestHandler> entry : map2.entrySet()) {
                aPIRequestHandler = entry.getValue();
                if (!aPIRequestHandler.getAPITags().contains((Object)APITag.ADDONS)) {
                    Logger.logErrorMessage("Add-on " + addOn.getClass().getName() + " attempted to register request handler which is not tagged as APITag.ADDONS, skipping");
                    continue;
                }
                String string2 = entry.getKey();
                if (string2 == null) {
                    Logger.logErrorMessage("Add-on " + addOn.getClass().getName() + " requestType not defined");
                    continue;
                }
                if (map.get(string2) != null) {
                    Logger.logErrorMessage("Add-on " + addOn.getClass().getName() + " attempted to override requestType " + string2 + ", skipping");
                    continue;
                }
                Logger.logMessage("Add-on " + addOn.getClass().getName() + " registered new API: " + string2);
                map.put(string2, aPIRequestHandler);
            }
        }
    }

    private AddOns() {
    }

    static {
        ArrayList arrayList = new ArrayList();
        Nxt.getStringListProperty("nxt.addOns").forEach(object -> {
            Class<?> clazz = null;
            try {
                block6: {
                    try {
                        clazz = Class.forName((String)object);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (((String)object).indexOf(46) != -1) break block6;
                        object = "nxt.addons." + (String)object;
                        clazz = Class.forName((String)object);
                    }
                }
                if (clazz == null) {
                    Logger.logErrorMessage("Add-on %s not found", object);
                } else {
                    arrayList.add((AddOn)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Logger.logErrorMessage(reflectiveOperationException.getMessage(), reflectiveOperationException);
            }
        });
        addOns = Collections.unmodifiableList(arrayList);
        if (!addOns.isEmpty() && !Nxt.getBooleanProperty("nxt.disableSecurityPolicy")) {
            System.setProperty("java.security.policy", Nxt.isDesktopApplicationEnabled() ? "nxtdesktop.policy" : "nxt.policy");
            Logger.logMessage("Setting security manager with policy " + System.getProperty("java.security.policy"));
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkConnect(String string, int n) {
                }

                @Override
                public void checkConnect(String string, int n, Object object) {
                }
            });
        }
        addOns.forEach(addOn -> {
            Logger.logInfoMessage("Initializing " + addOn.getClass().getName());
            addOn.init();
        });
    }
}

