/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import nxt.Account;
import nxt.AccountRestrictions;
import nxt.Appendix;
import nxt.Attachment;
import nxt.BlockDb;
import nxt.BlockImpl;
import nxt.BlockchainImpl;
import nxt.Constants;
import nxt.Fee;
import nxt.Genesis;
import nxt.Nxt;
import nxt.NxtException;
import nxt.PhasingPoll;
import nxt.Transaction;
import nxt.TransactionProcessorImpl;
import nxt.TransactionType;
import nxt.crypto.Crypto;
import nxt.db.DbKey;
import nxt.util.Convert;
import nxt.util.Filter;
import nxt.util.Logger;
import org.json.simple.JSONObject;

final class TransactionImpl
implements Transaction {
    private final short deadline;
    private volatile byte[] senderPublicKey;
    private final long recipientId;
    private final long amountNQT;
    private final long feeNQT;
    private final byte[] referencedTransactionFullHash;
    private final TransactionType type;
    private final int ecBlockHeight;
    private final long ecBlockId;
    private final byte version;
    private final int timestamp;
    private final byte[] signature;
    private final Attachment.AbstractAttachment attachment;
    private final Appendix.Message message;
    private final Appendix.EncryptedMessage encryptedMessage;
    private final Appendix.EncryptToSelfMessage encryptToSelfMessage;
    private final Appendix.PublicKeyAnnouncement publicKeyAnnouncement;
    private final Appendix.Phasing phasing;
    private final Appendix.PrunablePlainMessage prunablePlainMessage;
    private final Appendix.PrunableEncryptedMessage prunableEncryptedMessage;
    private final List<Appendix.AbstractAppendix> appendages;
    private final int appendagesSize;
    private volatile int height;
    private volatile long blockId;
    private volatile BlockImpl block;
    private volatile int blockTimestamp;
    private volatile short index;
    private volatile long id;
    private volatile String stringId;
    private volatile long senderId;
    private volatile byte[] fullHash;
    private volatile DbKey dbKey;
    private volatile byte[] bytes = null;
    private volatile boolean hasValidSignature = false;

    private TransactionImpl(BuilderImpl builderImpl, String string) throws NxtException.NotValidException {
        this.timestamp = builderImpl.timestamp;
        this.deadline = builderImpl.deadline;
        this.senderPublicKey = builderImpl.senderPublicKey;
        this.recipientId = builderImpl.recipientId;
        this.amountNQT = builderImpl.amountNQT;
        this.referencedTransactionFullHash = builderImpl.referencedTransactionFullHash;
        this.type = builderImpl.type;
        this.version = builderImpl.version;
        this.blockId = builderImpl.blockId;
        this.height = builderImpl.height;
        this.index = builderImpl.index;
        this.id = builderImpl.id;
        this.senderId = builderImpl.senderId;
        this.blockTimestamp = builderImpl.blockTimestamp;
        this.fullHash = builderImpl.fullHash;
        this.ecBlockHeight = builderImpl.ecBlockHeight;
        this.ecBlockId = builderImpl.ecBlockId;
        ArrayList<Appendix.AbstractAppendix> arrayList = new ArrayList<Appendix.AbstractAppendix>();
        this.attachment = builderImpl.attachment;
        if (this.attachment != null) {
            arrayList.add(this.attachment);
        }
        if ((this.message = builderImpl.message) != null) {
            arrayList.add(this.message);
        }
        if ((this.encryptedMessage = builderImpl.encryptedMessage) != null) {
            arrayList.add(this.encryptedMessage);
        }
        if ((this.publicKeyAnnouncement = builderImpl.publicKeyAnnouncement) != null) {
            arrayList.add(this.publicKeyAnnouncement);
        }
        if ((this.encryptToSelfMessage = builderImpl.encryptToSelfMessage) != null) {
            arrayList.add(this.encryptToSelfMessage);
        }
        if ((this.phasing = builderImpl.phasing) != null) {
            arrayList.add(this.phasing);
        }
        if ((this.prunablePlainMessage = builderImpl.prunablePlainMessage) != null) {
            arrayList.add(this.prunablePlainMessage);
        }
        if ((this.prunableEncryptedMessage = builderImpl.prunableEncryptedMessage) != null) {
            arrayList.add(this.prunableEncryptedMessage);
        }
        this.appendages = Collections.unmodifiableList(arrayList);
        int n = 0;
        for (Appendix appendix : this.appendages) {
            if (string != null && appendix instanceof Appendix.Encryptable) {
                ((Appendix.Encryptable)((Object)appendix)).encrypt(string);
            }
            n += appendix.getSize();
        }
        this.appendagesSize = n;
        if (builderImpl.isGenesisBlock) {
            this.feeNQT = builderImpl.feeNQT;
        } else if (builderImpl.feeNQT <= 0L || Constants.correctInvalidFees && builderImpl.signature == null) {
            int n2 = this.height < Integer.MAX_VALUE ? this.height : Nxt.getBlockchain().getHeight();
            long l = this.getMinimumFeeNQT(n2);
            this.feeNQT = Math.max(l, builderImpl.feeNQT);
        } else {
            this.feeNQT = builderImpl.feeNQT;
        }
        if (builderImpl.signature != null && string != null) {
            throw new NxtException.NotValidException("Transaction is already signed");
        }
        if (builderImpl.signature != null) {
            this.signature = builderImpl.signature;
        } else if (string != null) {
            if (this.getSenderPublicKey() != null && !Arrays.equals(this.senderPublicKey, Crypto.getPublicKey(string))) {
                throw new NxtException.NotValidException("Secret phrase doesn't match transaction sender public key");
            }
            this.signature = Crypto.sign(this.bytes(), string);
            this.bytes = null;
        } else {
            this.signature = null;
        }
    }

    @Override
    public short getDeadline() {
        return this.deadline;
    }

    @Override
    public byte[] getSenderPublicKey() {
        if (this.senderPublicKey == null) {
            this.senderPublicKey = Account.getPublicKey(this.senderId);
        }
        return this.senderPublicKey;
    }

    @Override
    public long getRecipientId() {
        return this.recipientId;
    }

    @Override
    public long getAmountNQT() {
        return this.amountNQT;
    }

    @Override
    public long getFeeNQT() {
        return this.feeNQT;
    }

    long[] getBackFees() {
        return this.type.getBackFees(this);
    }

    @Override
    public String getReferencedTransactionFullHash() {
        return Convert.toHexString(this.referencedTransactionFullHash);
    }

    byte[] referencedTransactionFullHash() {
        return this.referencedTransactionFullHash;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    void setHeight(int n) {
        this.height = n;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public TransactionType getType() {
        return this.type;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public long getBlockId() {
        return this.blockId;
    }

    @Override
    public BlockImpl getBlock() {
        if (this.block == null && this.blockId != 0L) {
            this.block = BlockchainImpl.getInstance().getBlock(this.blockId);
        }
        return this.block;
    }

    void setBlock(BlockImpl blockImpl) {
        this.block = blockImpl;
        this.blockId = blockImpl.getId();
        this.height = blockImpl.getHeight();
        this.blockTimestamp = blockImpl.getTimestamp();
    }

    void unsetBlock() {
        this.block = null;
        this.blockId = 0L;
        this.blockTimestamp = -1;
        this.index = (short)-1;
    }

    @Override
    public short getIndex() {
        if (this.index == -1) {
            throw new IllegalStateException("Transaction index has not been set");
        }
        return this.index;
    }

    void setIndex(int n) {
        this.index = (short)n;
    }

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getBlockTimestamp() {
        return this.blockTimestamp;
    }

    @Override
    public int getExpiration() {
        return this.timestamp + this.deadline * 60;
    }

    @Override
    public Attachment.AbstractAttachment getAttachment() {
        this.attachment.loadPrunable(this);
        return this.attachment;
    }

    public List<Appendix.AbstractAppendix> getAppendages() {
        return this.getAppendages(false);
    }

    public List<Appendix.AbstractAppendix> getAppendages(boolean bl) {
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            abstractAppendix.loadPrunable(this, bl);
        }
        return this.appendages;
    }

    public List<Appendix> getAppendages(Filter<Appendix> filter, boolean bl) {
        ArrayList<Appendix> arrayList = new ArrayList<Appendix>();
        this.appendages.forEach(abstractAppendix -> {
            if (filter.ok((Appendix)abstractAppendix)) {
                abstractAppendix.loadPrunable(this, bl);
                arrayList.add((Appendix)abstractAppendix);
            }
        });
        return arrayList;
    }

    @Override
    public long getId() {
        if (this.id == 0L) {
            if (this.signature == null) {
                throw new IllegalStateException("Transaction is not signed yet");
            }
            byte[] byArray = this.zeroSignature(this.getBytes());
            byte[] byArray2 = Crypto.sha256().digest(this.signature);
            MessageDigest messageDigest = Crypto.sha256();
            messageDigest.update(byArray);
            this.fullHash = messageDigest.digest(byArray2);
            BigInteger bigInteger = new BigInteger(1, new byte[]{this.fullHash[7], this.fullHash[6], this.fullHash[5], this.fullHash[4], this.fullHash[3], this.fullHash[2], this.fullHash[1], this.fullHash[0]});
            this.id = bigInteger.longValue();
            this.stringId = bigInteger.toString();
        }
        return this.id;
    }

    @Override
    public String getStringId() {
        if (this.stringId == null) {
            this.getId();
            if (this.stringId == null) {
                this.stringId = Long.toUnsignedString(this.id);
            }
        }
        return this.stringId;
    }

    @Override
    public String getFullHash() {
        return Convert.toHexString(this.fullHash());
    }

    byte[] fullHash() {
        if (this.fullHash == null) {
            this.getId();
        }
        return this.fullHash;
    }

    @Override
    public long getSenderId() {
        if (this.senderId == 0L) {
            this.senderId = Account.getId(this.getSenderPublicKey());
        }
        return this.senderId;
    }

    DbKey getDbKey() {
        if (this.dbKey == null) {
            this.dbKey = TransactionProcessorImpl.getInstance().unconfirmedTransactionDbKeyFactory.newKey(this.getId());
        }
        return this.dbKey;
    }

    @Override
    public Appendix.Message getMessage() {
        return this.message;
    }

    @Override
    public Appendix.EncryptedMessage getEncryptedMessage() {
        return this.encryptedMessage;
    }

    @Override
    public Appendix.EncryptToSelfMessage getEncryptToSelfMessage() {
        return this.encryptToSelfMessage;
    }

    @Override
    public Appendix.Phasing getPhasing() {
        return this.phasing;
    }

    boolean attachmentIsPhased() {
        return this.attachment.isPhased(this);
    }

    Appendix.PublicKeyAnnouncement getPublicKeyAnnouncement() {
        return this.publicKeyAnnouncement;
    }

    @Override
    public Appendix.PrunablePlainMessage getPrunablePlainMessage() {
        if (this.prunablePlainMessage != null) {
            this.prunablePlainMessage.loadPrunable(this);
        }
        return this.prunablePlainMessage;
    }

    boolean hasPrunablePlainMessage() {
        return this.prunablePlainMessage != null;
    }

    @Override
    public Appendix.PrunableEncryptedMessage getPrunableEncryptedMessage() {
        if (this.prunableEncryptedMessage != null) {
            this.prunableEncryptedMessage.loadPrunable(this);
        }
        return this.prunableEncryptedMessage;
    }

    boolean hasPrunableEncryptedMessage() {
        return this.prunableEncryptedMessage != null;
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes(), this.bytes.length);
    }

    byte[] bytes() {
        if (this.bytes == null) {
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.getSize());
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.put(this.type.getType());
                byteBuffer.put((byte)(this.version << 4 | this.type.getSubtype()));
                byteBuffer.putInt(this.timestamp);
                byteBuffer.putShort(this.deadline);
                byteBuffer.put(this.getSenderPublicKey());
                byteBuffer.putLong(this.type.canHaveRecipient() ? this.recipientId : Genesis.CREATOR_ID);
                byteBuffer.putLong(this.amountNQT);
                byteBuffer.putLong(this.feeNQT);
                if (this.referencedTransactionFullHash != null) {
                    byteBuffer.put(this.referencedTransactionFullHash);
                } else {
                    byteBuffer.put(new byte[32]);
                }
                byteBuffer.put(this.signature != null ? this.signature : new byte[64]);
                byteBuffer.putInt(this.getFlags());
                byteBuffer.putInt(this.ecBlockHeight);
                byteBuffer.putLong(this.ecBlockId);
                for (Appendix appendix : this.appendages) {
                    appendix.putBytes(byteBuffer);
                }
                this.bytes = byteBuffer.array();
            }
            catch (RuntimeException runtimeException) {
                if (this.signature != null) {
                    Logger.logDebugMessage("Failed to get transaction bytes for transaction: " + this.getJSONObject().toJSONString());
                }
                throw runtimeException;
            }
        }
        return this.bytes;
    }

    static BuilderImpl newTransactionBuilder(byte[] byArray) throws NxtException.NotValidException {
        try {
            int n;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byte by = byteBuffer.get();
            byte by2 = byteBuffer.get();
            byte by3 = (byte)((by2 & 0xF0) >> 4);
            by2 = (byte)(by2 & 0xF);
            int n2 = byteBuffer.getInt();
            short s = byteBuffer.getShort();
            byte[] byArray2 = new byte[32];
            byteBuffer.get(byArray2);
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            long l3 = byteBuffer.getLong();
            byte[] byArray3 = new byte[32];
            byteBuffer.get(byArray3);
            byArray3 = Convert.emptyToNull(byArray3);
            byte[] byArray4 = new byte[64];
            byteBuffer.get(byArray4);
            byArray4 = Convert.emptyToNull(byArray4);
            int n3 = 0;
            int n4 = 0;
            long l4 = 0L;
            if (by3 > 0) {
                n3 = byteBuffer.getInt();
                n4 = byteBuffer.getInt();
                l4 = byteBuffer.getLong();
            }
            TransactionType transactionType = TransactionType.findTransactionType(by, by2);
            BuilderImpl builderImpl = new BuilderImpl(by3, byArray2, l2, l3, s, transactionType.parseAttachment(byteBuffer)).timestamp(n2).referencedTransactionFullHash(byArray3).signature(byArray4).ecBlockHeight(n4).ecBlockId(l4);
            if (transactionType.canHaveRecipient()) {
                builderImpl.recipientId(l);
            }
            if ((n3 & (n = 1)) != 0 || by3 == 0 && transactionType == TransactionType.Messaging.ARBITRARY_MESSAGE) {
                builderImpl.appendix(new Appendix.Message(byteBuffer));
            }
            if ((n3 & (n <<= 1)) != 0) {
                builderImpl.appendix(new Appendix.EncryptedMessage(byteBuffer));
            }
            if ((n3 & (n <<= 1)) != 0) {
                builderImpl.appendix(new Appendix.PublicKeyAnnouncement(byteBuffer));
            }
            if ((n3 & (n <<= 1)) != 0) {
                builderImpl.appendix(new Appendix.EncryptToSelfMessage(byteBuffer));
            }
            if ((n3 & (n <<= 1)) != 0) {
                builderImpl.appendix(new Appendix.Phasing(byteBuffer));
            }
            if ((n3 & (n <<= 1)) != 0) {
                builderImpl.appendix(new Appendix.PrunablePlainMessage(byteBuffer));
            }
            if ((n3 & (n <<= 1)) != 0) {
                builderImpl.appendix(new Appendix.PrunableEncryptedMessage(byteBuffer));
            }
            if (byteBuffer.hasRemaining()) {
                throw new NxtException.NotValidException("Transaction bytes too long, " + byteBuffer.remaining() + " extra bytes");
            }
            return builderImpl;
        }
        catch (RuntimeException | NxtException.NotValidException exception) {
            Logger.logDebugMessage("Failed to parse transaction bytes: " + Convert.toHexString(byArray));
            throw exception;
        }
    }

    static BuilderImpl newTransactionBuilder(byte[] byArray, JSONObject jSONObject) throws NxtException.NotValidException {
        BuilderImpl builderImpl = TransactionImpl.newTransactionBuilder(byArray);
        if (jSONObject != null) {
            Appendix.PrunableEncryptedMessage prunableEncryptedMessage;
            Appendix.PrunablePlainMessage prunablePlainMessage;
            Attachment.TaggedDataExtend taggedDataExtend;
            Attachment.TaggedDataUpload taggedDataUpload;
            Attachment.ShufflingProcessing shufflingProcessing = Attachment.ShufflingProcessing.parse(jSONObject);
            if (shufflingProcessing != null) {
                builderImpl.appendix(shufflingProcessing);
            }
            if ((taggedDataUpload = Attachment.TaggedDataUpload.parse(jSONObject)) != null) {
                builderImpl.appendix(taggedDataUpload);
            }
            if ((taggedDataExtend = Attachment.TaggedDataExtend.parse(jSONObject)) != null) {
                builderImpl.appendix(taggedDataExtend);
            }
            if ((prunablePlainMessage = Appendix.PrunablePlainMessage.parse(jSONObject)) != null) {
                builderImpl.appendix(prunablePlainMessage);
            }
            if ((prunableEncryptedMessage = Appendix.PrunableEncryptedMessage.parse(jSONObject)) != null) {
                builderImpl.appendix(prunableEncryptedMessage);
            }
        }
        return builderImpl;
    }

    @Override
    public byte[] getUnsignedBytes() {
        return this.zeroSignature(this.getBytes());
    }

    @Override
    public JSONObject getJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"type", (Object)this.type.getType());
        jSONObject.put((Object)"subtype", (Object)this.type.getSubtype());
        jSONObject.put((Object)"timestamp", (Object)this.timestamp);
        jSONObject.put((Object)"deadline", (Object)this.deadline);
        jSONObject.put((Object)"senderPublicKey", (Object)Convert.toHexString(this.getSenderPublicKey()));
        if (this.type.canHaveRecipient()) {
            jSONObject.put((Object)"recipient", (Object)Long.toUnsignedString(this.recipientId));
        }
        jSONObject.put((Object)"amountNQT", (Object)this.amountNQT);
        jSONObject.put((Object)"feeNQT", (Object)this.feeNQT);
        if (this.referencedTransactionFullHash != null) {
            jSONObject.put((Object)"referencedTransactionFullHash", (Object)Convert.toHexString(this.referencedTransactionFullHash));
        }
        jSONObject.put((Object)"ecBlockHeight", (Object)this.ecBlockHeight);
        jSONObject.put((Object)"ecBlockId", (Object)Long.toUnsignedString(this.ecBlockId));
        jSONObject.put((Object)"signature", (Object)Convert.toHexString(this.signature));
        JSONObject jSONObject2 = new JSONObject();
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            abstractAppendix.loadPrunable(this);
            jSONObject2.putAll((Map)abstractAppendix.getJSONObject());
        }
        if (!jSONObject2.isEmpty()) {
            jSONObject.put((Object)"attachment", (Object)jSONObject2);
        }
        jSONObject.put((Object)"version", (Object)this.version);
        return jSONObject;
    }

    @Override
    public JSONObject getPrunableAttachmentJSON() {
        JSONObject jSONObject = null;
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            if (!(abstractAppendix instanceof Appendix.Prunable)) continue;
            abstractAppendix.loadPrunable(this);
            if (jSONObject == null) {
                jSONObject = abstractAppendix.getJSONObject();
                continue;
            }
            jSONObject.putAll((Map)abstractAppendix.getJSONObject());
        }
        return jSONObject;
    }

    static TransactionImpl parseTransaction(JSONObject jSONObject) throws NxtException.NotValidException {
        TransactionImpl transactionImpl = TransactionImpl.newTransactionBuilder(jSONObject).build();
        if (transactionImpl.getSignature() != null && !transactionImpl.checkSignature()) {
            throw new NxtException.NotValidException("Invalid transaction signature for transaction " + transactionImpl.getJSONObject().toJSONString());
        }
        return transactionImpl;
    }

    static BuilderImpl newTransactionBuilder(JSONObject jSONObject) throws NxtException.NotValidException {
        try {
            TransactionType transactionType;
            byte by = ((Long)jSONObject.get((Object)"type")).byteValue();
            byte by2 = ((Long)jSONObject.get((Object)"subtype")).byteValue();
            int n = ((Long)jSONObject.get((Object)"timestamp")).intValue();
            short s = ((Long)jSONObject.get((Object)"deadline")).shortValue();
            byte[] byArray = Convert.parseHexString((String)jSONObject.get((Object)"senderPublicKey"));
            long l = Convert.parseLong(jSONObject.get((Object)"amountNQT"));
            long l2 = Convert.parseLong(jSONObject.get((Object)"feeNQT"));
            String string = (String)jSONObject.get((Object)"referencedTransactionFullHash");
            byte[] byArray2 = Convert.parseHexString((String)jSONObject.get((Object)"signature"));
            Long l3 = (Long)jSONObject.get((Object)"version");
            byte by3 = l3 == null ? (byte)0 : l3.byteValue();
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"attachment");
            int n2 = 0;
            long l4 = 0L;
            if (by3 > 0) {
                n2 = ((Long)jSONObject.get((Object)"ecBlockHeight")).intValue();
                l4 = Convert.parseUnsignedLong((String)jSONObject.get((Object)"ecBlockId"));
            }
            if ((transactionType = TransactionType.findTransactionType(by, by2)) == null) {
                throw new NxtException.NotValidException("Invalid transaction type: " + by + ", " + by2);
            }
            BuilderImpl builderImpl = new BuilderImpl(by3, byArray, l, l2, s, transactionType.parseAttachment(jSONObject2)).timestamp(n).referencedTransactionFullHash(string).signature(byArray2).ecBlockHeight(n2).ecBlockId(l4);
            if (transactionType.canHaveRecipient()) {
                long l5 = Convert.parseUnsignedLong((String)jSONObject.get((Object)"recipient"));
                builderImpl.recipientId(l5);
            }
            if (jSONObject2 != null) {
                builderImpl.appendix(Appendix.Message.parse(jSONObject2));
                builderImpl.appendix(Appendix.EncryptedMessage.parse(jSONObject2));
                builderImpl.appendix(Appendix.PublicKeyAnnouncement.parse(jSONObject2));
                builderImpl.appendix(Appendix.EncryptToSelfMessage.parse(jSONObject2));
                builderImpl.appendix(Appendix.Phasing.parse(jSONObject2));
                builderImpl.appendix(Appendix.PrunablePlainMessage.parse(jSONObject2));
                builderImpl.appendix(Appendix.PrunableEncryptedMessage.parse(jSONObject2));
            }
            return builderImpl;
        }
        catch (RuntimeException | NxtException.NotValidException exception) {
            Logger.logDebugMessage("Failed to parse transaction: " + jSONObject.toJSONString());
            throw exception;
        }
    }

    @Override
    public int getECBlockHeight() {
        return this.ecBlockHeight;
    }

    @Override
    public long getECBlockId() {
        return this.ecBlockId;
    }

    public boolean equals(Object object) {
        return object instanceof TransactionImpl && this.getId() == ((Transaction)object).getId();
    }

    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    @Override
    public boolean verifySignature() {
        return this.checkSignature() && Account.setOrVerify(this.getSenderId(), this.getSenderPublicKey());
    }

    private boolean checkSignature() {
        if (!this.hasValidSignature) {
            this.hasValidSignature = this.signature != null && Crypto.verify(this.signature, this.zeroSignature(this.getBytes()), this.getSenderPublicKey());
        }
        return this.hasValidSignature;
    }

    private int getSize() {
        return this.signatureOffset() + 64 + 4 + 4 + 8 + this.appendagesSize;
    }

    @Override
    public int getFullSize() {
        int n = this.getSize() - this.appendagesSize;
        for (Appendix.AbstractAppendix abstractAppendix : this.getAppendages()) {
            n += abstractAppendix.getFullSize();
        }
        return n;
    }

    private int signatureOffset() {
        return 96;
    }

    private byte[] zeroSignature(byte[] byArray) {
        int n;
        for (int i = n = this.signatureOffset(); i < n + 64; ++i) {
            byArray[i] = 0;
        }
        return byArray;
    }

    private int getFlags() {
        int n = 0;
        int n2 = 1;
        if (this.message != null) {
            n |= n2;
        }
        n2 <<= 1;
        if (this.encryptedMessage != null) {
            n |= n2;
        }
        n2 <<= 1;
        if (this.publicKeyAnnouncement != null) {
            n |= n2;
        }
        n2 <<= 1;
        if (this.encryptToSelfMessage != null) {
            n |= n2;
        }
        n2 <<= 1;
        if (this.phasing != null) {
            n |= n2;
        }
        n2 <<= 1;
        if (this.prunablePlainMessage != null) {
            n |= n2;
        }
        n2 <<= 1;
        if (this.prunableEncryptedMessage != null) {
            n |= n2;
        }
        return n;
    }

    private static void assertFalse(boolean bl, Supplier<String> supplier) throws NxtException.NotValidException {
        if (bl) {
            throw new NxtException.NotValidException(supplier.get());
        }
    }

    @Override
    public void validate() throws NxtException.ValidationException {
        if (this.timestamp == 0) {
            TransactionImpl.assertFalse(this.deadline != 0, () -> String.format("Invalid transaction parameters:\n timestamp == 0 && deadline(%s) != 0", this.deadline));
            TransactionImpl.assertFalse(this.feeNQT != 0L, () -> String.format("Invalid transaction parameters:\n timestamp == 0 && feeNQT(%s) != 0", this.feeNQT));
        } else {
            TransactionImpl.assertFalse(this.deadline < 1, () -> String.format("Invalid transaction parameters:\n timestamp(%s) != 0 && deadline(%s) < 1", this.timestamp, this.deadline));
            TransactionImpl.assertFalse(this.feeNQT <= 0L, () -> String.format("Invalid transaction parameters:\n timestamp(%s) != 0 && feeNQT(%s) <= 0", this.timestamp, this.feeNQT));
        }
        TransactionImpl.assertFalse(this.feeNQT > 100000000000000000L, () -> String.format("Invalid transaction parameters:\n feeNQT(%s) > Constants.MAX_BALANCE_NQT(%s)", this.feeNQT, 100000000000000000L));
        TransactionImpl.assertFalse(this.amountNQT < 0L, () -> String.format("Invalid transaction parameters:\n amountNQT(%s) < 0", this.amountNQT));
        TransactionImpl.assertFalse(this.amountNQT > 100000000000000000L, () -> String.format("Invalid transaction parameters:\n amountNQT(%s) > Constants.MAX_BALANCE_NQT(%s)", this.amountNQT, 100000000000000000L));
        TransactionImpl.assertFalse(this.type == null, () -> "Invalid transaction parameters:\n type: null");
        if (this.referencedTransactionFullHash != null && this.referencedTransactionFullHash.length != 32) {
            throw new NxtException.NotValidException("Invalid referenced transaction full hash " + Convert.toHexString(this.referencedTransactionFullHash));
        }
        if (this.attachment == null || this.type != this.attachment.getTransactionType()) {
            throw new NxtException.NotValidException("Invalid attachment " + this.attachment + " for transaction of type " + this.type);
        }
        if (!(this.type.canHaveRecipient() || this.recipientId == 0L && this.getAmountNQT() == 0L)) {
            throw new NxtException.NotValidException("Transactions of this type must have recipient == 0, amount == 0");
        }
        if (this.type.mustHaveRecipient() && this.recipientId == 0L) {
            throw new NxtException.NotValidException("Transactions of this type must have a valid recipient");
        }
        boolean bl = this.phasing != null && this.getSignature() != null && PhasingPoll.getPoll(this.getId()) != null;
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            abstractAppendix.loadPrunable(this);
            if (!abstractAppendix.verifyVersion()) {
                throw new NxtException.NotValidException("Invalid attachment version " + abstractAppendix.getVersion());
            }
            if (bl) {
                abstractAppendix.validateAtFinish(this);
                continue;
            }
            abstractAppendix.validate(this);
        }
        if (this.getFullSize() > Constants.MAX_PAYLOAD_LENGTH) {
            throw new NxtException.NotValidException("Transaction size " + this.getFullSize() + " exceeds maximum payload size");
        }
        int n = Nxt.getBlockchain().getHeight();
        if (!bl) {
            long l = this.getMinimumFeeNQT(n);
            if (this.feeNQT < l) {
                throw new NxtException.NotCurrentlyValidException(String.format("Transaction fee %f %s less than minimum fee %f %s at height %d", (double)this.feeNQT / 1.0E8, "GMD", (double)l / 1.0E8, "GMD", n));
            }
            if (this.ecBlockId != 0L) {
                if (n < this.ecBlockHeight) {
                    throw new NxtException.NotCurrentlyValidException("ecBlockHeight " + this.ecBlockHeight + " exceeds blockchain height " + n);
                }
                if (BlockDb.findBlockIdAtHeight(this.ecBlockHeight) != this.ecBlockId) {
                    throw new NxtException.NotCurrentlyValidException("ecBlockHeight " + this.ecBlockHeight + " does not match ecBlockId " + Long.toUnsignedString(this.ecBlockId) + ", transaction was generated on a fork");
                }
            }
            AccountRestrictions.checkTransaction(this);
        }
    }

    boolean applyUnconfirmed() {
        Account account = Account.getAccount(this.getSenderId());
        return account != null && this.type.applyUnconfirmed(this, account);
    }

    void apply() {
        Account account = Account.getAccount(this.getSenderId());
        account.apply(this.getSenderPublicKey());
        Account account2 = null;
        if (this.recipientId != 0L && (account2 = Account.getAccount(this.recipientId)) == null) {
            account2 = Account.addOrGetAccount(this.recipientId);
        }
        if (this.referencedTransactionFullHash != null) {
            account.addToUnconfirmedBalanceNQT(this.getType().getLedgerEvent(), this.getId(), 0L, Constants.UNCONFIRMED_POOL_DEPOSIT_NQT);
        }
        if (this.attachmentIsPhased()) {
            account.addToBalanceNQT(this.getType().getLedgerEvent(), this.getId(), 0L, -this.feeNQT);
        }
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            if (abstractAppendix.isPhased(this)) continue;
            abstractAppendix.loadPrunable(this);
            abstractAppendix.apply(this, account, account2);
        }
    }

    void undoUnconfirmed() {
        Account account = Account.getAccount(this.getSenderId());
        this.type.undoUnconfirmed(this, account);
    }

    boolean attachmentIsDuplicate(Map<TransactionType, Map<String, Integer>> map, boolean bl) {
        if (!this.attachmentIsPhased() && !bl) {
            return false;
        }
        if (bl) {
            if (AccountRestrictions.isBlockDuplicate(this, map)) {
                return true;
            }
            if (this.type.isBlockDuplicate(this, map)) {
                return true;
            }
            if (this.attachmentIsPhased()) {
                return false;
            }
        }
        return this.type.isDuplicate(this, map);
    }

    boolean isUnconfirmedDuplicate(Map<TransactionType, Map<String, Integer>> map) {
        return this.type.isUnconfirmedDuplicate(this, map);
    }

    private long getMinimumFeeNQT(int n) {
        long l = 0L;
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            abstractAppendix.loadPrunable(this);
            if (n < abstractAppendix.getBaselineFeeHeight()) {
                return 0L;
            }
            Fee fee = n >= abstractAppendix.getNextFeeHeight() ? abstractAppendix.getNextFee(this) : abstractAppendix.getBaselineFee(this);
            l = Math.addExact(l, fee.getFee(this, abstractAppendix));
        }
        if (this.referencedTransactionFullHash != null) {
            l = Math.addExact(l, 100000000L);
        }
        return l;
    }

    static final class BuilderImpl
    implements Transaction.Builder {
        private final short deadline;
        private final byte[] senderPublicKey;
        private final long amountNQT;
        private final long feeNQT;
        private final TransactionType type;
        private final byte version;
        private Attachment.AbstractAttachment attachment;
        private long recipientId;
        private byte[] referencedTransactionFullHash;
        private byte[] signature;
        private Appendix.Message message;
        private Appendix.EncryptedMessage encryptedMessage;
        private Appendix.EncryptToSelfMessage encryptToSelfMessage;
        private Appendix.PublicKeyAnnouncement publicKeyAnnouncement;
        private Appendix.Phasing phasing;
        private Appendix.PrunablePlainMessage prunablePlainMessage;
        private Appendix.PrunableEncryptedMessage prunableEncryptedMessage;
        private long blockId;
        private int height = Integer.MAX_VALUE;
        private long id;
        private long senderId;
        private int timestamp = Integer.MAX_VALUE;
        private int blockTimestamp = -1;
        private byte[] fullHash;
        private boolean ecBlockSet = false;
        private int ecBlockHeight;
        private long ecBlockId;
        private short index = (short)-1;
        private boolean isGenesisBlock;

        BuilderImpl(byte by, byte[] byArray, long l, long l2, short s, Attachment.AbstractAttachment abstractAttachment) {
            this.version = by;
            this.deadline = s;
            this.senderPublicKey = byArray;
            this.amountNQT = l;
            this.feeNQT = l2;
            this.attachment = abstractAttachment;
            this.type = abstractAttachment.getTransactionType();
        }

        @Override
        public TransactionImpl build(String string) throws NxtException.NotValidException {
            if (this.timestamp == Integer.MAX_VALUE) {
                this.timestamp = Nxt.getEpochTime();
            }
            if (!this.ecBlockSet) {
                BlockImpl blockImpl = BlockchainImpl.getInstance().getECBlock(this.timestamp);
                this.ecBlockHeight = blockImpl.getHeight();
                this.ecBlockId = blockImpl.getId();
            }
            return new TransactionImpl(this, string);
        }

        @Override
        public TransactionImpl build() throws NxtException.NotValidException {
            return this.build(null);
        }

        @Override
        public BuilderImpl recipientId(long l) {
            this.recipientId = l;
            return this;
        }

        @Override
        public BuilderImpl referencedTransactionFullHash(String string) {
            this.referencedTransactionFullHash = Convert.parseHexString(string);
            return this;
        }

        BuilderImpl referencedTransactionFullHash(byte[] byArray) {
            this.referencedTransactionFullHash = byArray;
            return this;
        }

        BuilderImpl appendix(Attachment.AbstractAttachment abstractAttachment) {
            this.attachment = abstractAttachment;
            return this;
        }

        @Override
        public BuilderImpl appendix(Appendix.Message message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl appendix(Appendix.EncryptedMessage encryptedMessage) {
            this.encryptedMessage = encryptedMessage;
            return this;
        }

        @Override
        public BuilderImpl appendix(Appendix.EncryptToSelfMessage encryptToSelfMessage) {
            this.encryptToSelfMessage = encryptToSelfMessage;
            return this;
        }

        @Override
        public BuilderImpl appendix(Appendix.PublicKeyAnnouncement publicKeyAnnouncement) {
            this.publicKeyAnnouncement = publicKeyAnnouncement;
            return this;
        }

        @Override
        public BuilderImpl appendix(Appendix.PrunablePlainMessage prunablePlainMessage) {
            this.prunablePlainMessage = prunablePlainMessage;
            return this;
        }

        @Override
        public BuilderImpl appendix(Appendix.PrunableEncryptedMessage prunableEncryptedMessage) {
            this.prunableEncryptedMessage = prunableEncryptedMessage;
            return this;
        }

        @Override
        public BuilderImpl appendix(Appendix.Phasing phasing) {
            this.phasing = phasing;
            return this;
        }

        @Override
        public BuilderImpl timestamp(int n) {
            this.timestamp = n;
            return this;
        }

        @Override
        public BuilderImpl ecBlockHeight(int n) {
            this.ecBlockHeight = n;
            this.ecBlockSet = true;
            return this;
        }

        @Override
        public BuilderImpl ecBlockId(long l) {
            this.ecBlockId = l;
            this.ecBlockSet = true;
            return this;
        }

        BuilderImpl id(long l) {
            this.id = l;
            return this;
        }

        BuilderImpl signature(byte[] byArray) {
            this.signature = byArray;
            return this;
        }

        BuilderImpl blockId(long l) {
            this.blockId = l;
            return this;
        }

        BuilderImpl height(int n) {
            this.height = n;
            return this;
        }

        BuilderImpl senderId(long l) {
            this.senderId = l;
            return this;
        }

        BuilderImpl fullHash(byte[] byArray) {
            this.fullHash = byArray;
            return this;
        }

        BuilderImpl blockTimestamp(int n) {
            this.blockTimestamp = n;
            return this;
        }

        BuilderImpl index(short s) {
            this.index = s;
            return this;
        }

        public BuilderImpl isGenesisBlock(boolean bl) {
            this.isGenesisBlock = bl;
            return this;
        }
    }
}

