/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.util.List;
import nxt.Appendix;
import nxt.Attachment;
import nxt.Block;
import nxt.NxtException;
import nxt.TransactionType;
import nxt.util.Filter;
import org.json.simple.JSONObject;

public interface Transaction {
    public long getId();

    public String getStringId();

    public long getSenderId();

    public byte[] getSenderPublicKey();

    public long getRecipientId();

    public int getHeight();

    public long getBlockId();

    public Block getBlock();

    public short getIndex();

    public int getTimestamp();

    public int getBlockTimestamp();

    public short getDeadline();

    public int getExpiration();

    public long getAmountNQT();

    public long getFeeNQT();

    public String getReferencedTransactionFullHash();

    public byte[] getSignature();

    public String getFullHash();

    public TransactionType getType();

    public Attachment getAttachment();

    public boolean verifySignature();

    public void validate() throws NxtException.ValidationException;

    public byte[] getBytes();

    public byte[] getUnsignedBytes();

    public JSONObject getJSONObject();

    public JSONObject getPrunableAttachmentJSON();

    public byte getVersion();

    public int getFullSize();

    public Appendix.Message getMessage();

    public Appendix.EncryptedMessage getEncryptedMessage();

    public Appendix.EncryptToSelfMessage getEncryptToSelfMessage();

    public Appendix.Phasing getPhasing();

    public Appendix.PrunablePlainMessage getPrunablePlainMessage();

    public Appendix.PrunableEncryptedMessage getPrunableEncryptedMessage();

    public List<? extends Appendix> getAppendages();

    public List<? extends Appendix> getAppendages(boolean var1);

    public List<? extends Appendix> getAppendages(Filter<Appendix> var1, boolean var2);

    public int getECBlockHeight();

    public long getECBlockId();

    public static interface Builder {
        public Builder recipientId(long var1);

        public Builder referencedTransactionFullHash(String var1);

        public Builder appendix(Appendix.Message var1);

        public Builder appendix(Appendix.EncryptedMessage var1);

        public Builder appendix(Appendix.EncryptToSelfMessage var1);

        public Builder appendix(Appendix.PublicKeyAnnouncement var1);

        public Builder appendix(Appendix.PrunablePlainMessage var1);

        public Builder appendix(Appendix.PrunableEncryptedMessage var1);

        public Builder appendix(Appendix.Phasing var1);

        public Builder timestamp(int var1);

        public Builder ecBlockHeight(int var1);

        public Builder ecBlockId(long var1);

        public Transaction build() throws NxtException.NotValidException;

        public Transaction build(String var1) throws NxtException.NotValidException;
    }
}

