/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import nxt.Constants;
import nxt.Nxt;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.PrunableDbTable;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;

public final class ShufflingParticipant {
    private static final Listeners<ShufflingParticipant, Event> listeners = new Listeners();
    private static final DbKey.LinkKeyFactory<ShufflingParticipant> shufflingParticipantDbKeyFactory = new DbKey.LinkKeyFactory<ShufflingParticipant>("shuffling_id", "account_id"){

        @Override
        public DbKey newKey(ShufflingParticipant shufflingParticipant) {
            return shufflingParticipant.dbKey;
        }
    };
    private static final VersionedEntityDbTable<ShufflingParticipant> shufflingParticipantTable = new VersionedEntityDbTable<ShufflingParticipant>("shuffling_participant", shufflingParticipantDbKeyFactory){

        @Override
        protected ShufflingParticipant load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new ShufflingParticipant(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, ShufflingParticipant shufflingParticipant) throws SQLException {
            shufflingParticipant.save(connection);
        }
    };
    private static final DbKey.LinkKeyFactory<ShufflingData> shufflingDataDbKeyFactory = new DbKey.LinkKeyFactory<ShufflingData>("shuffling_id", "account_id"){

        @Override
        public DbKey newKey(ShufflingData shufflingData) {
            return shufflingData.dbKey;
        }
    };
    private static final PrunableDbTable<ShufflingData> shufflingDataTable = new PrunableDbTable<ShufflingData>("shuffling_data", shufflingDataDbKeyFactory){

        @Override
        protected ShufflingData load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new ShufflingData(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, ShufflingData shufflingData) throws SQLException {
            shufflingData.save(connection);
        }
    };
    private final long shufflingId;
    private final long accountId;
    private final DbKey dbKey;
    private final int index;
    private long nextAccountId;
    private State state;
    private byte[][] blameData;
    private byte[][] keySeeds;
    private byte[] dataTransactionFullHash;

    public static boolean addListener(Listener<ShufflingParticipant> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<ShufflingParticipant> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static DbIterator<ShufflingParticipant> getParticipants(long l) {
        return shufflingParticipantTable.getManyBy((DbClause)new DbClause.LongClause("shuffling_id", l), 0, -1, " ORDER BY participant_index ");
    }

    public static ShufflingParticipant getParticipant(long l, long l2) {
        return (ShufflingParticipant)shufflingParticipantTable.get(shufflingParticipantDbKeyFactory.newKey(l, l2));
    }

    static ShufflingParticipant getLastParticipant(long l) {
        return (ShufflingParticipant)shufflingParticipantTable.getBy(new DbClause.LongClause("shuffling_id", l).and(new DbClause.NullClause("next_account_id")));
    }

    static void addParticipant(long l, long l2, int n) {
        ShufflingParticipant shufflingParticipant = new ShufflingParticipant(l, l2, n);
        shufflingParticipantTable.insert(shufflingParticipant);
        listeners.notify(shufflingParticipant, Event.PARTICIPANT_REGISTERED);
    }

    static int getVerifiedCount(long l) {
        return shufflingParticipantTable.getCount(new DbClause.LongClause("shuffling_id", l).and(new DbClause.ByteClause("state", State.VERIFIED.getCode())));
    }

    static void init() {
    }

    private ShufflingParticipant(long l, long l2, int n) {
        this.shufflingId = l;
        this.accountId = l2;
        this.dbKey = shufflingParticipantDbKeyFactory.newKey(l, l2);
        this.index = n;
        this.state = State.REGISTERED;
        this.blameData = Convert.EMPTY_BYTES;
        this.keySeeds = Convert.EMPTY_BYTES;
    }

    private ShufflingParticipant(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.shufflingId = resultSet.getLong("shuffling_id");
        this.accountId = resultSet.getLong("account_id");
        this.dbKey = dbKey;
        this.nextAccountId = resultSet.getLong("next_account_id");
        this.index = resultSet.getInt("participant_index");
        this.state = State.get(resultSet.getByte("state"));
        this.blameData = (byte[][])DbUtils.getArray(resultSet, "blame_data", byte[][].class, Convert.EMPTY_BYTES);
        this.keySeeds = (byte[][])DbUtils.getArray(resultSet, "key_seeds", byte[][].class, Convert.EMPTY_BYTES);
        this.dataTransactionFullHash = resultSet.getBytes("data_transaction_full_hash");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO shuffling_participant (shuffling_id, account_id, next_account_id, participant_index, state, blame_data, key_seeds, data_transaction_full_hash, height, latest) KEY (shuffling_id, account_id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.shufflingId);
            preparedStatement.setLong(++n, this.accountId);
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.nextAccountId);
            preparedStatement.setInt(++n, this.index);
            preparedStatement.setByte(++n, this.getState().getCode());
            DbUtils.setArrayEmptyToNull(preparedStatement, ++n, this.blameData);
            DbUtils.setArrayEmptyToNull(preparedStatement, ++n, this.keySeeds);
            DbUtils.setBytes(preparedStatement, ++n, this.dataTransactionFullHash);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getShufflingId() {
        return this.shufflingId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getNextAccountId() {
        return this.nextAccountId;
    }

    void setNextAccountId(long l) {
        if (this.nextAccountId != 0L) {
            throw new IllegalStateException("nextAccountId already set to " + Long.toUnsignedString(this.nextAccountId));
        }
        this.nextAccountId = l;
        shufflingParticipantTable.insert(this);
    }

    public int getIndex() {
        return this.index;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        if (!this.state.canBecome(state)) {
            throw new IllegalStateException(String.format("Shuffling participant in state %s cannot go to state %s", new Object[]{this.state, state}));
        }
        this.state = state;
        Logger.logDebugMessage("Shuffling participant %s changed state to %s", new Object[]{Long.toUnsignedString(this.accountId), this.state});
    }

    public byte[][] getData() {
        return ShufflingParticipant.getData(this.shufflingId, this.accountId);
    }

    static byte[][] getData(long l, long l2) {
        ShufflingData shufflingData = (ShufflingData)shufflingDataTable.get(shufflingDataDbKeyFactory.newKey(l, l2));
        return shufflingData != null ? shufflingData.data : null;
    }

    void setData(byte[][] byArray, int n) {
        if (byArray != null && Nxt.getEpochTime() - n < Constants.MAX_PRUNABLE_LIFETIME && this.getData() == null) {
            shufflingDataTable.insert(new ShufflingData(this.shufflingId, this.accountId, byArray, n, Nxt.getBlockchain().getHeight()));
        }
    }

    static void restoreData(long l, long l2, byte[][] byArray, int n, int n2) {
        if (byArray != null && ShufflingParticipant.getData(l, l2) == null) {
            shufflingDataTable.insert(new ShufflingData(l, l2, byArray, n, n2));
        }
    }

    public byte[][] getBlameData() {
        return this.blameData;
    }

    public byte[][] getKeySeeds() {
        return this.keySeeds;
    }

    void cancel(byte[][] byArray, byte[][] byArray2) {
        if (this.keySeeds.length > 0) {
            throw new IllegalStateException("keySeeds already set");
        }
        this.blameData = byArray;
        this.keySeeds = byArray2;
        this.setState(State.CANCELLED);
        shufflingParticipantTable.insert(this);
        listeners.notify(this, Event.PARTICIPANT_CANCELLED);
    }

    public byte[] getDataTransactionFullHash() {
        return this.dataTransactionFullHash;
    }

    void setProcessed(byte[] byArray) {
        if (this.dataTransactionFullHash != null) {
            throw new IllegalStateException("dataTransactionFullHash already set");
        }
        this.setState(State.PROCESSED);
        this.dataTransactionFullHash = byArray;
        shufflingParticipantTable.insert(this);
        listeners.notify(this, Event.PARTICIPANT_PROCESSED);
    }

    public ShufflingParticipant getPreviousParticipant() {
        if (this.index == 0) {
            return null;
        }
        return (ShufflingParticipant)shufflingParticipantTable.getBy(new DbClause.LongClause("shuffling_id", this.shufflingId).and(new DbClause.IntClause("participant_index", this.index - 1)));
    }

    void verify() {
        this.setState(State.VERIFIED);
        shufflingParticipantTable.insert(this);
        listeners.notify(this, Event.PARTICIPANT_VERIFIED);
    }

    void delete() {
        shufflingParticipantTable.delete(this);
    }

    private static final class ShufflingData {
        private final long shufflingId;
        private final long accountId;
        private final DbKey dbKey;
        private final byte[][] data;
        private final int transactionTimestamp;
        private final int height;

        private ShufflingData(long l, long l2, byte[][] byArray, int n, int n2) {
            this.shufflingId = l;
            this.accountId = l2;
            this.dbKey = shufflingDataDbKeyFactory.newKey(l, l2);
            this.data = byArray;
            this.transactionTimestamp = n;
            this.height = n2;
        }

        private ShufflingData(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.shufflingId = resultSet.getLong("shuffling_id");
            this.accountId = resultSet.getLong("account_id");
            this.dbKey = dbKey;
            this.data = (byte[][])DbUtils.getArray(resultSet, "data", byte[][].class, Convert.EMPTY_BYTES);
            this.transactionTimestamp = resultSet.getInt("transaction_timestamp");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO shuffling_data (shuffling_id, account_id, data, transaction_timestamp, height) VALUES (?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.shufflingId);
                preparedStatement.setLong(++n, this.accountId);
                DbUtils.setArrayEmptyToNull(preparedStatement, ++n, this.data);
                preparedStatement.setInt(++n, this.transactionTimestamp);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }
    }

    public static enum Event {
        PARTICIPANT_REGISTERED,
        PARTICIPANT_PROCESSED,
        PARTICIPANT_VERIFIED,
        PARTICIPANT_CANCELLED;

    }

    public static enum State {
        REGISTERED(0, new byte[]{1}),
        PROCESSED(1, new byte[]{2, 3}),
        VERIFIED(2, new byte[]{3}),
        CANCELLED(3, new byte[0]);

        private final byte code;
        private final byte[] allowedNext;

        private State(byte by, byte[] byArray) {
            this.code = by;
            this.allowedNext = byArray;
        }

        static State get(byte by) {
            for (State state : State.values()) {
                if (state.code != by) continue;
                return state;
            }
            throw new IllegalArgumentException("No matching state for " + by);
        }

        public byte getCode() {
            return this.code;
        }

        public boolean canBecome(State state) {
            return Arrays.binarySearch(this.allowedNext, state.code) >= 0;
        }
    }
}

