/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Attachment;
import nxt.Block;
import nxt.BlockDb;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Db;
import nxt.HoldingType;
import nxt.Nxt;
import nxt.ShufflingParticipant;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.crypto.AnonymouslyEncryptedData;
import nxt.crypto.Crypto;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;

public final class Shuffling {
    private static final boolean deleteFinished = Nxt.getBooleanProperty("nxt.deleteFinishedShufflings");
    private static final Listeners<Shuffling, Event> listeners = new Listeners();
    private static final DbKey.LongKeyFactory<Shuffling> shufflingDbKeyFactory = new DbKey.LongKeyFactory<Shuffling>("id"){

        @Override
        public DbKey newKey(Shuffling shuffling) {
            return shuffling.dbKey;
        }
    };
    private static final VersionedEntityDbTable<Shuffling> shufflingTable = new VersionedEntityDbTable<Shuffling>("shuffling", shufflingDbKeyFactory){

        @Override
        protected Shuffling load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Shuffling(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Shuffling shuffling) throws SQLException {
            shuffling.save(connection);
        }
    };
    private final long id;
    private final DbKey dbKey;
    private final long holdingId;
    private final HoldingType holdingType;
    private final long issuerId;
    private final long amount;
    private final byte participantCount;
    private short blocksRemaining;
    private byte registrantCount;
    private Stage stage;
    private long assigneeAccountId;
    private byte[][] recipientPublicKeys;

    public static boolean addListener(Listener<Shuffling> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Shuffling> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static int getCount() {
        return shufflingTable.getCount();
    }

    public static int getActiveCount() {
        return shufflingTable.getCount(new DbClause.NotNullClause("blocks_remaining"));
    }

    public static DbIterator<Shuffling> getAll(int n, int n2) {
        return shufflingTable.getAll(n, n2, " ORDER BY blocks_remaining NULLS LAST, height DESC ");
    }

    public static DbIterator<Shuffling> getActiveShufflings(int n, int n2) {
        return shufflingTable.getManyBy((DbClause)new DbClause.NotNullClause("blocks_remaining"), n, n2, " ORDER BY blocks_remaining, height DESC ");
    }

    public static DbIterator<Shuffling> getFinishedShufflings(int n, int n2) {
        return shufflingTable.getManyBy((DbClause)new DbClause.NullClause("blocks_remaining"), n, n2, " ORDER BY height DESC ");
    }

    public static Shuffling getShuffling(long l) {
        return (Shuffling)shufflingTable.get(shufflingDbKeyFactory.newKey(l));
    }

    public static Shuffling getShuffling(byte[] byArray) {
        long l = Convert.fullHashToId(byArray);
        Shuffling shuffling = (Shuffling)shufflingTable.get(shufflingDbKeyFactory.newKey(l));
        if (shuffling != null && !Arrays.equals(shuffling.getFullHash(), byArray)) {
            Logger.logDebugMessage("Shuffling with different hash %s but same id found for hash %s", Convert.toHexString(shuffling.getFullHash()), Convert.toHexString(byArray));
            return null;
        }
        return shuffling;
    }

    public static int getHoldingShufflingCount(long l, boolean bl) {
        DbClause dbClause;
        DbClause dbClause2 = dbClause = l != 0L ? new DbClause.LongClause("holding_id", l) : new DbClause.NullClause("holding_id");
        if (!bl) {
            dbClause = dbClause.and(new DbClause.NotNullClause("blocks_remaining"));
        }
        return shufflingTable.getCount(dbClause);
    }

    public static DbIterator<Shuffling> getHoldingShufflings(long l, Stage stage, boolean bl, int n, int n2) {
        DbClause dbClause;
        DbClause dbClause2 = dbClause = l != 0L ? new DbClause.LongClause("holding_id", l) : new DbClause.NullClause("holding_id");
        if (!bl) {
            dbClause = dbClause.and(new DbClause.NotNullClause("blocks_remaining"));
        }
        if (stage != null) {
            dbClause = dbClause.and(new DbClause.ByteClause("stage", stage.getCode()));
        }
        return shufflingTable.getManyBy(dbClause, n, n2, " ORDER BY blocks_remaining NULLS LAST, height DESC ");
    }

    public static DbIterator<Shuffling> getAccountShufflings(long l, boolean bl, int n, int n2) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT shuffling.* FROM shuffling, shuffling_participant WHERE shuffling_participant.account_id = ? AND shuffling.id = shuffling_participant.shuffling_id " + (bl ? "" : "AND shuffling.blocks_remaining IS NOT NULL ") + "AND shuffling.latest = TRUE AND shuffling_participant.latest = TRUE ORDER BY blocks_remaining NULLS LAST, height DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return shufflingTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static DbIterator<Shuffling> getAssignedShufflings(long l, int n, int n2) {
        return shufflingTable.getManyBy(new DbClause.LongClause("assignee_account_id", l).and(new DbClause.ByteClause("stage", Stage.PROCESSING.getCode())), n, n2, " ORDER BY blocks_remaining NULLS LAST, height DESC ");
    }

    static void addShuffling(Transaction transaction, Attachment.ShufflingCreation shufflingCreation) {
        Shuffling shuffling = new Shuffling(transaction, shufflingCreation);
        shufflingTable.insert(shuffling);
        ShufflingParticipant.addParticipant(shuffling.getId(), transaction.getSenderId(), 0);
        listeners.notify(shuffling, Event.SHUFFLING_CREATED);
    }

    static void init() {
    }

    private Shuffling(Transaction transaction, Attachment.ShufflingCreation shufflingCreation) {
        this.id = transaction.getId();
        this.dbKey = shufflingDbKeyFactory.newKey(this.id);
        this.holdingId = shufflingCreation.getHoldingId();
        this.holdingType = shufflingCreation.getHoldingType();
        this.issuerId = transaction.getSenderId();
        this.amount = shufflingCreation.getAmount();
        this.participantCount = shufflingCreation.getParticipantCount();
        this.blocksRemaining = shufflingCreation.getRegistrationPeriod();
        this.stage = Stage.REGISTRATION;
        this.assigneeAccountId = this.issuerId;
        this.recipientPublicKeys = Convert.EMPTY_BYTES;
        this.registrantCount = 1;
    }

    private Shuffling(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.holdingId = resultSet.getLong("holding_id");
        this.holdingType = HoldingType.get(resultSet.getByte("holding_type"));
        this.issuerId = resultSet.getLong("issuer_id");
        this.amount = resultSet.getLong("amount");
        this.participantCount = resultSet.getByte("participant_count");
        this.blocksRemaining = resultSet.getShort("blocks_remaining");
        this.stage = Stage.get(resultSet.getByte("stage"));
        this.assigneeAccountId = resultSet.getLong("assignee_account_id");
        this.recipientPublicKeys = (byte[][])DbUtils.getArray(resultSet, "recipient_public_keys", byte[][].class, Convert.EMPTY_BYTES);
        this.registrantCount = resultSet.getByte("registrant_count");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO shuffling (id, holding_id, holding_type, issuer_id, amount, participant_count, blocks_remaining, stage, assignee_account_id, recipient_public_keys, registrant_count, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.holdingId);
            preparedStatement.setByte(++n, this.holdingType.getCode());
            preparedStatement.setLong(++n, this.issuerId);
            preparedStatement.setLong(++n, this.amount);
            preparedStatement.setByte(++n, this.participantCount);
            DbUtils.setShortZeroToNull(preparedStatement, ++n, this.blocksRemaining);
            preparedStatement.setByte(++n, this.getStage().getCode());
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.assigneeAccountId);
            DbUtils.setArrayEmptyToNull(preparedStatement, ++n, this.recipientPublicKeys);
            preparedStatement.setByte(++n, this.registrantCount);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getHoldingId() {
        return this.holdingId;
    }

    public HoldingType getHoldingType() {
        return this.holdingType;
    }

    public long getIssuerId() {
        return this.issuerId;
    }

    public long getAmount() {
        return this.amount;
    }

    public byte getParticipantCount() {
        return this.participantCount;
    }

    public byte getRegistrantCount() {
        return this.registrantCount;
    }

    public short getBlocksRemaining() {
        return this.blocksRemaining;
    }

    public Stage getStage() {
        return this.stage;
    }

    private void setStage(Stage stage, long l, short s) {
        if (!this.stage.canBecome(stage)) {
            throw new IllegalStateException(String.format("Shuffling in stage %s cannot go to stage %s", new Object[]{this.stage, stage}));
        }
        if ((stage == Stage.VERIFICATION || stage == Stage.DONE) && l != 0L) {
            throw new IllegalArgumentException(String.format("Invalid assigneeAccountId %s for stage %s", new Object[]{Long.toUnsignedString(l), stage}));
        }
        if ((stage == Stage.REGISTRATION || stage == Stage.PROCESSING || stage == Stage.BLAME) && l == 0L) {
            throw new IllegalArgumentException(String.format("In stage %s assigneeAccountId cannot be 0", new Object[]{stage}));
        }
        if ((stage == Stage.DONE || stage == Stage.CANCELLED) && s != 0) {
            throw new IllegalArgumentException(String.format("For stage %s remaining blocks cannot be %s", new Object[]{stage, s}));
        }
        this.stage = stage;
        this.assigneeAccountId = l;
        this.blocksRemaining = s;
        Logger.logDebugMessage("Shuffling %s entered stage %s, assignee %s, remaining blocks %s", new Object[]{Long.toUnsignedString(this.id), this.stage, Long.toUnsignedString(this.assigneeAccountId), this.blocksRemaining});
    }

    public long getAssigneeAccountId() {
        return this.assigneeAccountId;
    }

    public byte[][] getRecipientPublicKeys() {
        return this.recipientPublicKeys;
    }

    public ShufflingParticipant getParticipant(long l) {
        return ShufflingParticipant.getParticipant(this.id, l);
    }

    public ShufflingParticipant getLastParticipant() {
        return ShufflingParticipant.getLastParticipant(this.id);
    }

    public byte[] getStateHash() {
        return this.stage.getHash(this);
    }

    public byte[] getFullHash() {
        return TransactionDb.getFullHash(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Attachment.ShufflingAttachment process(long l, String string, byte[] byArray) {
        void var11_16;
        Object object;
        Object object2;
        Object object3;
        int n;
        byte[][] byArray2 = Convert.EMPTY_BYTES;
        byte[] byArray3 = null;
        int n2 = 0;
        ArrayList<ShufflingParticipant> arrayList = new ArrayList<ShufflingParticipant>();
        Nxt.getBlockchain().readLock();
        try (DbIterator<ShufflingParticipant> dbIterator = ShufflingParticipant.getParticipants(this.id);){
            for (ShufflingParticipant object32 : dbIterator) {
                arrayList.add(object32);
                if (object32.getNextAccountId() != l) continue;
                byArray2 = object32.getData();
                byArray3 = object32.getDataTransactionFullHash();
                n2 = arrayList.size();
            }
            if (byArray3 == null) {
                byArray3 = Shuffling.getParticipantsHash(arrayList);
            }
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
        boolean bl = n2 == this.participantCount - 1;
        ArrayList arrayList2 = new ArrayList();
        byte[][] byArray4 = byArray2;
        int n3 = byArray4.length;
        for (n = 0; n < n3; ++n) {
            object3 = byArray4[n];
            object2 = AnonymouslyEncryptedData.readEncryptedData((byte[])object3);
            try {
                object = ((AnonymouslyEncryptedData)object2).decrypt(string);
                arrayList2.add(object);
                continue;
            }
            catch (Exception exception) {
                Logger.logMessage("Decryption failed", exception);
                return bl ? new Attachment.ShufflingRecipients(this.id, Convert.EMPTY_BYTES, byArray3) : new Attachment.ShufflingProcessing(this.id, Convert.EMPTY_BYTES, byArray3);
            }
        }
        byte[] byArray5 = byArray;
        byte[] byArray6 = Convert.toBytes(this.id);
        for (n = arrayList.size() - 1; n > n2; --n) {
            object3 = (ShufflingParticipant)arrayList.get(n);
            object2 = Account.getPublicKey(((ShufflingParticipant)object3).getAccountId());
            object = AnonymouslyEncryptedData.encrypt((byte[])var11_16, string, (byte[])object2, byArray6);
            byte[] byArray7 = ((AnonymouslyEncryptedData)object).getBytes();
        }
        arrayList2.add(var11_16);
        arrayList2.sort(Convert.byteArrayComparator);
        if (bl) {
            HashSet<Long> hashSet = new HashSet<Long>(this.participantCount);
            object3 = arrayList2.iterator();
            while (object3.hasNext()) {
                object2 = (byte[])object3.next();
                if (Crypto.isCanonicalPublicKey((byte[])object2) && hashSet.add(Account.getId((byte[])object2))) continue;
                Logger.logDebugMessage("Invalid recipient public key " + Convert.toHexString((byte[])object2));
                return new Attachment.ShufflingRecipients(this.id, Convert.EMPTY_BYTES, byArray3);
            }
            return new Attachment.ShufflingRecipients(this.id, (byte[][])arrayList2.toArray((T[])new byte[arrayList2.size()][]), byArray3);
        }
        Object object4 = null;
        object3 = arrayList2.iterator();
        while (object3.hasNext()) {
            object2 = (byte[])object3.next();
            if (object4 != null && Arrays.equals((byte[])object2, object4)) {
                Logger.logDebugMessage("Duplicate decrypted data");
                return new Attachment.ShufflingProcessing(this.id, Convert.EMPTY_BYTES, byArray3);
            }
            if (((Object)object2).length != 32 + 64 * (this.participantCount - n2 - 1)) {
                Logger.logDebugMessage("Invalid encrypted data length in process " + ((Object)object2).length);
                return new Attachment.ShufflingProcessing(this.id, Convert.EMPTY_BYTES, byArray3);
            }
            object4 = object2;
        }
        return new Attachment.ShufflingProcessing(this.id, (byte[][])arrayList2.toArray((T[])new byte[arrayList2.size()][]), byArray3);
    }

    public Attachment.ShufflingCancellation revealKeySeeds(String string, long l, byte[] byArray) {
        Nxt.getBlockchain().readLock();
        try {
            DbIterator<ShufflingParticipant> dbIterator = ShufflingParticipant.getParticipants(this.id);
            try {
                Object object;
                Object object2;
                if (l != this.assigneeAccountId) {
                    throw new RuntimeException(String.format("Current shuffling cancellingAccountId %s does not match %s", Long.toUnsignedString(this.assigneeAccountId), Long.toUnsignedString(l)));
                }
                if (byArray == null || !Arrays.equals(byArray, this.getStateHash())) {
                    throw new RuntimeException("Current shuffling state hash does not match");
                }
                long l2 = Account.getId(Crypto.getPublicKey(string));
                byte[][] byArray2 = null;
                while (dbIterator.hasNext()) {
                    object2 = dbIterator.next();
                    if (((ShufflingParticipant)object2).getAccountId() != l2) continue;
                    byArray2 = ((ShufflingParticipant)object2).getData();
                    break;
                }
                if (!dbIterator.hasNext()) {
                    throw new RuntimeException("Last participant cannot have keySeeds to reveal");
                }
                if (byArray2 == null) {
                    throw new RuntimeException("Account " + Long.toUnsignedString(l2) + " has not submitted data");
                }
                object2 = Convert.toBytes(this.id);
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                byte[] byArray3 = Account.getPublicKey(dbIterator.next().getAccountId());
                byte[] byArray4 = Crypto.getKeySeed(string, byArray3, (byte[])object2);
                arrayList.add(byArray4);
                byte[] byArray5 = Crypto.getPublicKey(byArray4);
                byte[] byArray6 = null;
                for (byte[] byArray7 : byArray2) {
                    AnonymouslyEncryptedData anonymouslyEncryptedData = AnonymouslyEncryptedData.readEncryptedData(byArray7);
                    if (!Arrays.equals(anonymouslyEncryptedData.getPublicKey(), byArray5)) continue;
                    try {
                        byArray6 = anonymouslyEncryptedData.decrypt(byArray4, byArray3);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (byArray6 == null) {
                    throw new RuntimeException("None of the encrypted data could be decrypted");
                }
                while (dbIterator.hasNext()) {
                    byArray3 = Account.getPublicKey(dbIterator.next().getAccountId());
                    byArray4 = Crypto.getKeySeed(string, byArray3, (byte[])object2);
                    arrayList.add(byArray4);
                    object = AnonymouslyEncryptedData.readEncryptedData(byArray6);
                    byArray6 = ((AnonymouslyEncryptedData)object).decrypt(byArray4, byArray3);
                }
                object = new Attachment.ShufflingCancellation(this.id, byArray2, (byte[][])arrayList.toArray((T[])new byte[arrayList.size()][]), byArray, l);
                if (dbIterator != null) {
                    dbIterator.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                if (dbIterator != null) {
                    try {
                        dbIterator.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
    }

    void addParticipant(long l) {
        ShufflingParticipant shufflingParticipant = ShufflingParticipant.getParticipant(this.id, this.assigneeAccountId);
        shufflingParticipant.setNextAccountId(l);
        ShufflingParticipant.addParticipant(this.id, l, this.registrantCount);
        this.registrantCount = (byte)(this.registrantCount + 1);
        if (this.registrantCount == this.participantCount) {
            this.setStage(Stage.PROCESSING, this.issuerId, Constants.SHUFFLING_PROCESSING_DEADLINE);
        } else {
            this.assigneeAccountId = l;
        }
        shufflingTable.insert(this);
        if (this.stage == Stage.PROCESSING) {
            listeners.notify(this, Event.SHUFFLING_PROCESSING_ASSIGNED);
        }
    }

    void updateParticipantData(Transaction transaction, Attachment.ShufflingProcessing shufflingProcessing) {
        long l = transaction.getSenderId();
        byte[][] byArray = shufflingProcessing.getData();
        ShufflingParticipant shufflingParticipant = ShufflingParticipant.getParticipant(this.id, l);
        shufflingParticipant.setData(byArray, transaction.getTimestamp());
        shufflingParticipant.setProcessed(((TransactionImpl)transaction).fullHash());
        if (byArray != null && byArray.length == 0) {
            this.cancelBy(shufflingParticipant);
            return;
        }
        this.assigneeAccountId = shufflingParticipant.getNextAccountId();
        this.blocksRemaining = Constants.SHUFFLING_PROCESSING_DEADLINE;
        shufflingTable.insert(this);
        listeners.notify(this, Event.SHUFFLING_PROCESSING_ASSIGNED);
    }

    void updateRecipients(Transaction transaction, Attachment.ShufflingRecipients shufflingRecipients) {
        long l = transaction.getSenderId();
        this.recipientPublicKeys = shufflingRecipients.getRecipientPublicKeys();
        ShufflingParticipant shufflingParticipant = ShufflingParticipant.getParticipant(this.id, l);
        shufflingParticipant.setProcessed(((TransactionImpl)transaction).fullHash());
        if (this.recipientPublicKeys.length == 0) {
            this.cancelBy(shufflingParticipant);
            return;
        }
        shufflingParticipant.verify();
        for (byte[] byArray : this.recipientPublicKeys) {
            long l2 = Account.getId(byArray);
            if (!Account.setOrVerify(l2, byArray)) continue;
            Account.addOrGetAccount(l2).apply(byArray);
        }
        this.setStage(Stage.VERIFICATION, 0L, (short)(Constants.SHUFFLING_PROCESSING_DEADLINE + this.participantCount));
        shufflingTable.insert(this);
        listeners.notify(this, Event.SHUFFLING_PROCESSING_FINISHED);
    }

    void verify(long l) {
        ShufflingParticipant.getParticipant(this.id, l).verify();
        if (ShufflingParticipant.getVerifiedCount(this.id) == this.participantCount) {
            this.distribute();
        }
    }

    void cancelBy(ShufflingParticipant shufflingParticipant, byte[][] byArray, byte[][] byArray2) {
        boolean bl;
        shufflingParticipant.cancel(byArray, byArray2);
        boolean bl2 = bl = this.stage != Stage.BLAME;
        if (bl) {
            this.setStage(Stage.BLAME, shufflingParticipant.getAccountId(), (short)(Constants.SHUFFLING_PROCESSING_DEADLINE + this.participantCount));
        }
        shufflingTable.insert(this);
        if (bl) {
            listeners.notify(this, Event.SHUFFLING_BLAME_STARTED);
        }
    }

    private void cancelBy(ShufflingParticipant shufflingParticipant) {
        this.cancelBy(shufflingParticipant, Convert.EMPTY_BYTES, Convert.EMPTY_BYTES);
    }

    private void distribute() {
        Object object;
        Object object2;
        if (this.recipientPublicKeys.length != this.participantCount) {
            this.cancelBy(this.getLastParticipant());
            return;
        }
        Object object3 = this.recipientPublicKeys;
        int n = ((byte[][])object3).length;
        for (int i = 0; i < n; ++i) {
            object2 = object3[i];
            object = Account.getPublicKey(Account.getId(object2));
            if (object == null || Arrays.equals(object, object2)) continue;
            this.cancelBy(this.getLastParticipant());
            return;
        }
        object3 = (Object)AccountLedger.LedgerEvent.SHUFFLING_DISTRIBUTION;
        try (Object object4 = ShufflingParticipant.getParticipants(this.id);){
            Iterator<ShufflingParticipant> iterator = ((DbIterator)object4).iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = Account.getAccount(object2.getAccountId());
                this.holdingType.addToBalance((Account)object, (AccountLedger.LedgerEvent)((Object)object3), this.id, this.holdingId, -this.amount);
                if (this.holdingType == HoldingType.NXT) continue;
                object.addToBalanceNQT((AccountLedger.LedgerEvent)((Object)object3), this.id, -Constants.SHUFFLING_DEPOSIT_NQT);
            }
        }
        object4 = this.recipientPublicKeys;
        int n2 = ((Object)object4).length;
        for (int i = 0; i < n2; ++i) {
            object = object4[i];
            long l = Account.getId(object);
            Account account = Account.addOrGetAccount(l);
            account.apply((byte[])object);
            this.holdingType.addToBalanceAndUnconfirmedBalance(account, (AccountLedger.LedgerEvent)((Object)object3), this.id, this.holdingId, this.amount);
            if (this.holdingType == HoldingType.NXT) continue;
            account.addToBalanceAndUnconfirmedBalanceNQT((AccountLedger.LedgerEvent)((Object)object3), this.id, Constants.SHUFFLING_DEPOSIT_NQT);
        }
        this.setStage(Stage.DONE, 0L, (short)0);
        shufflingTable.insert(this);
        listeners.notify(this, Event.SHUFFLING_DONE);
        if (deleteFinished) {
            this.delete();
        }
        Logger.logDebugMessage("Shuffling %s was distributed", Long.toUnsignedString(this.id));
    }

    private void cancel(Block block) {
        Account account;
        AccountLedger.LedgerEvent ledgerEvent = AccountLedger.LedgerEvent.SHUFFLING_CANCELLATION;
        long l = this.blame();
        try (DbIterator<ShufflingParticipant> dbIterator = ShufflingParticipant.getParticipants(this.id);){
            for (ShufflingParticipant shufflingParticipant : dbIterator) {
                account = Account.getAccount(shufflingParticipant.getAccountId());
                this.holdingType.addToUnconfirmedBalance(account, ledgerEvent, this.id, this.holdingId, this.amount);
                if (account.getId() != l) {
                    if (this.holdingType == HoldingType.NXT) continue;
                    account.addToUnconfirmedBalanceNQT(ledgerEvent, this.id, Constants.SHUFFLING_DEPOSIT_NQT);
                    continue;
                }
                if (this.holdingType == HoldingType.NXT) {
                    account.addToUnconfirmedBalanceNQT(ledgerEvent, this.id, -Constants.SHUFFLING_DEPOSIT_NQT);
                }
                account.addToBalanceNQT(ledgerEvent, this.id, -Constants.SHUFFLING_DEPOSIT_NQT);
            }
        }
        if (l != 0L) {
            long l2 = Constants.SHUFFLING_DEPOSIT_NQT / 4L;
            for (int i = 0; i < 3; ++i) {
                account = Account.getAccount(BlockDb.findBlockAtHeight(block.getHeight() - i - 1).getGeneratorId());
                account.addToBalanceAndUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.BLOCK_GENERATED, block.getId(), l2);
                account.addToForgedBalanceNQT(l2);
                Logger.logDebugMessage("Shuffling penalty %f %s awarded to forger at height %d", (double)l2 / 1.0E8, "GMD", block.getHeight() - i - 1);
            }
            l2 = Constants.SHUFFLING_DEPOSIT_NQT - 3L * l2;
            Account account2 = Account.getAccount(block.getGeneratorId());
            account2.addToBalanceAndUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.BLOCK_GENERATED, block.getId(), l2);
            account2.addToForgedBalanceNQT(l2);
            Logger.logDebugMessage("Shuffling penalty %f %s awarded to forger at height %d", (double)l2 / 1.0E8, "GMD", block.getHeight());
        }
        this.setStage(Stage.CANCELLED, l, (short)0);
        shufflingTable.insert(this);
        listeners.notify(this, Event.SHUFFLING_CANCELLED);
        if (deleteFinished) {
            this.delete();
        }
        Logger.logDebugMessage("Shuffling %s was cancelled, blaming account %s", Long.toUnsignedString(this.id), Long.toUnsignedString(l));
    }

    private long blame() {
        if (this.stage == Stage.REGISTRATION) {
            Logger.logDebugMessage("Registration never completed for shuffling %s", Long.toUnsignedString(this.id));
            return 0L;
        }
        if (this.stage == Stage.PROCESSING) {
            Logger.logDebugMessage("Participant %s did not submit processing", Long.toUnsignedString(this.assigneeAccountId));
            return this.assigneeAccountId;
        }
        ArrayList<ShufflingParticipant> arrayList = new ArrayList<ShufflingParticipant>();
        try (Object object = ShufflingParticipant.getParticipants(this.id);){
            while (((DbIterator)object).hasNext()) {
                arrayList.add((ShufflingParticipant)((DbIterator)object).next());
            }
        }
        if (this.stage == Stage.VERIFICATION) {
            for (ShufflingParticipant shufflingParticipant : arrayList) {
                if (shufflingParticipant.getState() == ShufflingParticipant.State.VERIFIED) continue;
                Logger.logDebugMessage("Participant %s did not submit verification", Long.toUnsignedString(shufflingParticipant.getAccountId()));
                return shufflingParticipant.getAccountId();
            }
            throw new RuntimeException("All participants submitted data and verifications, blame phase should not have been entered");
        }
        object = new HashSet(this.participantCount);
        block9: for (int i = 0; i < this.participantCount - 1; ++i) {
            byte[] byArray;
            ShufflingParticipant shufflingParticipant = (ShufflingParticipant)arrayList.get(i);
            byte[][] byArray2 = shufflingParticipant.getKeySeeds();
            if (byArray2.length == 0) {
                Logger.logDebugMessage("Participant %s did not reveal keys", Long.toUnsignedString(shufflingParticipant.getAccountId()));
                return shufflingParticipant.getAccountId();
            }
            byte[] byArray3 = Crypto.getPublicKey(byArray2[0]);
            AnonymouslyEncryptedData anonymouslyEncryptedData = null;
            byte[][] byArray4 = shufflingParticipant.getBlameData();
            int n = byArray4.length;
            for (int j = 0; j < n && !Arrays.equals(byArray3, (anonymouslyEncryptedData = AnonymouslyEncryptedData.readEncryptedData(byArray = byArray4[j])).getPublicKey()); ++j) {
            }
            if (anonymouslyEncryptedData == null || !Arrays.equals(byArray3, anonymouslyEncryptedData.getPublicKey())) {
                Logger.logDebugMessage("Participant %s did not submit blame data, or revealed invalid keys", Long.toUnsignedString(shufflingParticipant.getAccountId()));
                return shufflingParticipant.getAccountId();
            }
            for (int j = i + 1; j < this.participantCount; ++j) {
                boolean bl;
                byte[] byArray5;
                ShufflingParticipant shufflingParticipant2 = (ShufflingParticipant)arrayList.get(j);
                byte[] byArray6 = Account.getPublicKey(shufflingParticipant2.getAccountId());
                byArray = byArray2[j - i - 1];
                try {
                    byArray5 = anonymouslyEncryptedData.decrypt(byArray, byArray6);
                }
                catch (Exception exception) {
                    Logger.logDebugMessage("Could not decrypt data from participant %s", Long.toUnsignedString(shufflingParticipant.getAccountId()));
                    return shufflingParticipant.getAccountId();
                }
                boolean bl2 = bl = j == this.participantCount - 1;
                if (bl) {
                    if (!Crypto.isCanonicalPublicKey(byArray3)) {
                        Logger.logDebugMessage("Participant %s submitted invalid recipient public key", Long.toUnsignedString(shufflingParticipant.getAccountId()));
                        return shufflingParticipant.getAccountId();
                    }
                    byte[] byArray7 = Account.getPublicKey(Account.getId(byArray5));
                    if (byArray7 != null && !Arrays.equals(byArray7, byArray5)) {
                        Logger.logDebugMessage("Participant %s submitted colliding recipient public key", Long.toUnsignedString(shufflingParticipant.getAccountId()));
                        return shufflingParticipant.getAccountId();
                    }
                    if (!object.add(Account.getId(byArray5))) {
                        Logger.logDebugMessage("Participant %s submitted duplicate recipient public key", Long.toUnsignedString(shufflingParticipant.getAccountId()));
                        return shufflingParticipant.getAccountId();
                    }
                }
                if (shufflingParticipant2.getState() == ShufflingParticipant.State.CANCELLED && shufflingParticipant2.getBlameData().length == 0) continue block9;
                boolean bl3 = false;
                for (byte[] byArray8 : bl ? this.recipientPublicKeys : shufflingParticipant2.getBlameData()) {
                    if (!Arrays.equals(byArray5, byArray8)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    Logger.logDebugMessage("Participant %s did not include previous data", Long.toUnsignedString(shufflingParticipant2.getAccountId()));
                    return shufflingParticipant2.getAccountId();
                }
                if (bl) continue;
                anonymouslyEncryptedData = AnonymouslyEncryptedData.readEncryptedData(byArray5);
            }
        }
        return this.assigneeAccountId;
    }

    private void delete() {
        try (DbIterator<ShufflingParticipant> dbIterator = ShufflingParticipant.getParticipants(this.id);){
            for (ShufflingParticipant shufflingParticipant : dbIterator) {
                shufflingParticipant.delete();
            }
        }
        shufflingTable.delete(this);
    }

    private boolean isFull(Block block) {
        int n = 176;
        n = this.stage == Stage.REGISTRATION ? (n += 33) : 16384;
        return block.getPayloadLength() + n > Constants.MAX_PAYLOAD_LENGTH;
    }

    private static byte[] getParticipantsHash(Iterable<ShufflingParticipant> iterable) {
        MessageDigest messageDigest = Crypto.sha256();
        iterable.forEach(shufflingParticipant -> messageDigest.update(Convert.toBytes(shufflingParticipant.getAccountId())));
        return messageDigest.digest();
    }

    static {
        Nxt.getBlockchainProcessor().addListener(block -> {
            if (block.getTransactions().size() == Constants.MAX_NUMBER_OF_TRANSACTIONS || block.getPayloadLength() > Constants.MAX_PAYLOAD_LENGTH - 176) {
                return;
            }
            ArrayList<Shuffling> arrayList = new ArrayList<Shuffling>();
            try (DbIterator<Shuffling> dbIterator = Shuffling.getActiveShufflings(0, -1);){
                for (Shuffling shuffling2 : dbIterator) {
                    if (shuffling2.isFull((Block)block)) continue;
                    arrayList.add(shuffling2);
                }
            }
            arrayList.forEach(shuffling -> {
                shuffling.blocksRemaining = (short)(shuffling.blocksRemaining - 1);
                if (shuffling.blocksRemaining <= 0) {
                    shuffling.cancel((Block)block);
                } else {
                    shufflingTable.insert((Shuffling)shuffling);
                }
            });
        }, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
    }

    public static enum Stage {
        REGISTRATION(0, new byte[]{1, 4}){

            @Override
            byte[] getHash(Shuffling shuffling) {
                return shuffling.getFullHash();
            }
        }
        ,
        PROCESSING(1, new byte[]{2, 3, 4}){

            @Override
            byte[] getHash(Shuffling shuffling) {
                if (shuffling.assigneeAccountId == shuffling.issuerId) {
                    try (DbIterator<ShufflingParticipant> dbIterator = ShufflingParticipant.getParticipants(shuffling.id);){
                        byte[] byArray = Shuffling.getParticipantsHash(dbIterator);
                        return byArray;
                    }
                }
                ShufflingParticipant shufflingParticipant = shuffling.getParticipant(shuffling.assigneeAccountId);
                return shufflingParticipant.getPreviousParticipant().getDataTransactionFullHash();
            }
        }
        ,
        VERIFICATION(2, new byte[]{3, 4, 5}){

            @Override
            byte[] getHash(Shuffling shuffling) {
                return shuffling.getLastParticipant().getDataTransactionFullHash();
            }
        }
        ,
        BLAME(3, new byte[]{4}){

            @Override
            byte[] getHash(Shuffling shuffling) {
                return shuffling.getParticipant(shuffling.assigneeAccountId).getDataTransactionFullHash();
            }
        }
        ,
        CANCELLED(4, new byte[0]){

            @Override
            byte[] getHash(Shuffling shuffling) {
                byte[] byArray = shuffling.getLastParticipant().getDataTransactionFullHash();
                if (byArray != null && byArray.length > 0) {
                    return byArray;
                }
                try (DbIterator<ShufflingParticipant> dbIterator = ShufflingParticipant.getParticipants(shuffling.id);){
                    byte[] byArray2 = Shuffling.getParticipantsHash(dbIterator);
                    return byArray2;
                }
            }
        }
        ,
        DONE(5, new byte[0]){

            @Override
            byte[] getHash(Shuffling shuffling) {
                return shuffling.getLastParticipant().getDataTransactionFullHash();
            }
        };

        private final byte code;
        private final byte[] allowedNext;

        private Stage(byte by, byte[] byArray) {
            this.code = by;
            this.allowedNext = byArray;
        }

        public static Stage get(byte by) {
            for (Stage stage : Stage.values()) {
                if (stage.code != by) continue;
                return stage;
            }
            throw new IllegalArgumentException("No matching stage for " + by);
        }

        public byte getCode() {
            return this.code;
        }

        public boolean canBecome(Stage stage) {
            return Arrays.binarySearch(this.allowedNext, stage.code) >= 0;
        }

        abstract byte[] getHash(Shuffling var1);
    }

    public static enum Event {
        SHUFFLING_CREATED,
        SHUFFLING_PROCESSING_ASSIGNED,
        SHUFFLING_PROCESSING_FINISHED,
        SHUFFLING_BLAME_STARTED,
        SHUFFLING_CANCELLED,
        SHUFFLING_DONE;

    }
}

