/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Attachment;
import nxt.Nxt;
import nxt.Trade;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;

public abstract class Order {
    private final long id;
    private final long accountId;
    private final long assetId;
    private final long priceNQT;
    private final int creationHeight;
    private final short transactionIndex;
    private final int transactionHeight;
    private long quantityQNT;

    private static void matchOrders(long l) {
        Bid bid;
        Ask ask;
        while ((ask = Ask.getNextOrder(l)) != null && (bid = Bid.getNextOrder(l)) != null && ask.getPriceNQT() <= bid.getPriceNQT()) {
            Trade trade = Trade.addTrade(l, ask, bid);
            ask.updateQuantityQNT(Math.subtractExact(ask.getQuantityQNT(), trade.getQuantityQNT()));
            Account account = Account.getAccount(ask.getAccountId());
            account.addToBalanceAndUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.ASSET_TRADE, ask.getId(), Math.multiplyExact(trade.getQuantityQNT(), trade.getPriceNQT()));
            account.addToAssetBalanceQNT(AccountLedger.LedgerEvent.ASSET_TRADE, ask.getId(), l, -trade.getQuantityQNT());
            bid.updateQuantityQNT(Math.subtractExact(bid.getQuantityQNT(), trade.getQuantityQNT()));
            Account account2 = Account.getAccount(bid.getAccountId());
            account2.addToAssetAndUnconfirmedAssetBalanceQNT(AccountLedger.LedgerEvent.ASSET_TRADE, bid.getId(), l, trade.getQuantityQNT());
            account2.addToBalanceNQT(AccountLedger.LedgerEvent.ASSET_TRADE, bid.getId(), -Math.multiplyExact(trade.getQuantityQNT(), trade.getPriceNQT()));
            account2.addToUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.ASSET_TRADE, bid.getId(), Math.multiplyExact(trade.getQuantityQNT(), bid.getPriceNQT() - trade.getPriceNQT()));
        }
    }

    static void init() {
        Ask.init();
        Bid.init();
    }

    private Order(Transaction transaction, Attachment.ColoredCoinsOrderPlacement coloredCoinsOrderPlacement) {
        this.id = transaction.getId();
        this.accountId = transaction.getSenderId();
        this.assetId = coloredCoinsOrderPlacement.getAssetId();
        this.quantityQNT = coloredCoinsOrderPlacement.getQuantityQNT();
        this.priceNQT = coloredCoinsOrderPlacement.getPriceNQT();
        this.creationHeight = Nxt.getBlockchain().getHeight();
        this.transactionIndex = transaction.getIndex();
        this.transactionHeight = transaction.getHeight();
    }

    private Order(ResultSet resultSet) throws SQLException {
        this.id = resultSet.getLong("id");
        this.accountId = resultSet.getLong("account_id");
        this.assetId = resultSet.getLong("asset_id");
        this.priceNQT = resultSet.getLong("price");
        this.quantityQNT = resultSet.getLong("quantity");
        this.creationHeight = resultSet.getInt("creation_height");
        this.transactionIndex = resultSet.getShort("transaction_index");
        this.transactionHeight = resultSet.getInt("transaction_height");
    }

    private void save(Connection connection, String string) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO " + string + " (id, account_id, asset_id, price, quantity, creation_height, transaction_index, transaction_height, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setLong(++n, this.assetId);
            preparedStatement.setLong(++n, this.priceNQT);
            preparedStatement.setLong(++n, this.quantityQNT);
            preparedStatement.setInt(++n, this.creationHeight);
            preparedStatement.setShort(++n, this.transactionIndex);
            preparedStatement.setInt(++n, this.transactionHeight);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public final long getId() {
        return this.id;
    }

    public final long getAccountId() {
        return this.accountId;
    }

    public final long getAssetId() {
        return this.assetId;
    }

    public final long getPriceNQT() {
        return this.priceNQT;
    }

    public final long getQuantityQNT() {
        return this.quantityQNT;
    }

    public final int getHeight() {
        return this.creationHeight;
    }

    public final int getTransactionIndex() {
        return this.transactionIndex;
    }

    public final int getTransactionHeight() {
        return this.transactionHeight;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " id: " + Long.toUnsignedString(this.id) + " account: " + Long.toUnsignedString(this.accountId) + " asset: " + Long.toUnsignedString(this.assetId) + " price: " + this.priceNQT + " quantity: " + this.quantityQNT + " height: " + this.creationHeight + " transactionIndex: " + this.transactionIndex + " transactionHeight: " + this.transactionHeight;
    }

    private void setQuantityQNT(long l) {
        this.quantityQNT = l;
    }

    public static final class Bid
    extends Order {
        private static final DbKey.LongKeyFactory<Bid> bidOrderDbKeyFactory = new DbKey.LongKeyFactory<Bid>("id"){

            @Override
            public DbKey newKey(Bid bid) {
                return bid.dbKey;
            }
        };
        private static final VersionedEntityDbTable<Bid> bidOrderTable = new VersionedEntityDbTable<Bid>("bid_order", bidOrderDbKeyFactory){

            @Override
            protected Bid load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Bid(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Bid bid) throws SQLException {
                bid.save(connection, this.table);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY creation_height DESC ";
            }
        };
        private final DbKey dbKey;

        public static int getCount() {
            return bidOrderTable.getCount();
        }

        public static Bid getBidOrder(long l) {
            return (Bid)bidOrderTable.get(bidOrderDbKeyFactory.newKey(l));
        }

        public static DbIterator<Bid> getAll(int n, int n2) {
            return bidOrderTable.getAll(n, n2);
        }

        public static DbIterator<Bid> getBidOrdersByAccount(long l, int n, int n2) {
            return bidOrderTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
        }

        public static DbIterator<Bid> getBidOrdersByAsset(long l, int n, int n2) {
            return bidOrderTable.getManyBy(new DbClause.LongClause("asset_id", l), n, n2);
        }

        public static DbIterator<Bid> getBidOrdersByAccountAsset(long l, long l2, int n, int n2) {
            DbClause dbClause = new DbClause.LongClause("account_id", l).and(new DbClause.LongClause("asset_id", l2));
            return bidOrderTable.getManyBy(dbClause, n, n2);
        }

        public static DbIterator<Bid> getSortedOrders(long l, int n, int n2) {
            return bidOrderTable.getManyBy((DbClause)new DbClause.LongClause("asset_id", l), n, n2, " ORDER BY price DESC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
        }

        /*
         * Exception decompiling
         */
        private static Bid getNextOrder(long var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        static void addOrder(Transaction transaction, Attachment.ColoredCoinsBidOrderPlacement coloredCoinsBidOrderPlacement) {
            Bid bid = new Bid(transaction, coloredCoinsBidOrderPlacement);
            bidOrderTable.insert(bid);
            Order.matchOrders(coloredCoinsBidOrderPlacement.getAssetId());
        }

        static void removeOrder(long l) {
            bidOrderTable.delete(Bid.getBidOrder(l));
        }

        static void init() {
        }

        private Bid(Transaction transaction, Attachment.ColoredCoinsBidOrderPlacement coloredCoinsBidOrderPlacement) {
            super(transaction, coloredCoinsBidOrderPlacement);
            this.dbKey = bidOrderDbKeyFactory.newKey(this.id);
        }

        private Bid(ResultSet resultSet, DbKey dbKey) throws SQLException {
            super(resultSet);
            this.dbKey = dbKey;
        }

        @Override
        private void save(Connection connection, String string) throws SQLException {
            super.save(connection, string);
        }

        private void updateQuantityQNT(long l) {
            super.setQuantityQNT(l);
            if (l > 0L) {
                bidOrderTable.insert(this);
            } else if (l == 0L) {
                bidOrderTable.delete(this);
            } else {
                throw new IllegalArgumentException("Negative quantity: " + l + " for order: " + Long.toUnsignedString(this.getId()));
            }
        }
    }

    public static final class Ask
    extends Order {
        private static final DbKey.LongKeyFactory<Ask> askOrderDbKeyFactory = new DbKey.LongKeyFactory<Ask>("id"){

            @Override
            public DbKey newKey(Ask ask) {
                return ask.dbKey;
            }
        };
        private static final VersionedEntityDbTable<Ask> askOrderTable = new VersionedEntityDbTable<Ask>("ask_order", askOrderDbKeyFactory){

            @Override
            protected Ask load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Ask(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Ask ask) throws SQLException {
                ask.save(connection, this.table);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY creation_height DESC ";
            }
        };
        private final DbKey dbKey;

        public static int getCount() {
            return askOrderTable.getCount();
        }

        public static Ask getAskOrder(long l) {
            return (Ask)askOrderTable.get(askOrderDbKeyFactory.newKey(l));
        }

        public static DbIterator<Ask> getAll(int n, int n2) {
            return askOrderTable.getAll(n, n2);
        }

        public static DbIterator<Ask> getAskOrdersByAccount(long l, int n, int n2) {
            return askOrderTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
        }

        public static DbIterator<Ask> getAskOrdersByAsset(long l, int n, int n2) {
            return askOrderTable.getManyBy(new DbClause.LongClause("asset_id", l), n, n2);
        }

        public static DbIterator<Ask> getAskOrdersByAccountAsset(long l, long l2, int n, int n2) {
            DbClause dbClause = new DbClause.LongClause("account_id", l).and(new DbClause.LongClause("asset_id", l2));
            return askOrderTable.getManyBy(dbClause, n, n2);
        }

        public static DbIterator<Ask> getSortedOrders(long l, int n, int n2) {
            return askOrderTable.getManyBy((DbClause)new DbClause.LongClause("asset_id", l), n, n2, " ORDER BY price ASC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
        }

        /*
         * Exception decompiling
         */
        private static Ask getNextOrder(long var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        static void addOrder(Transaction transaction, Attachment.ColoredCoinsAskOrderPlacement coloredCoinsAskOrderPlacement) {
            Ask ask = new Ask(transaction, coloredCoinsAskOrderPlacement);
            askOrderTable.insert(ask);
            Order.matchOrders(coloredCoinsAskOrderPlacement.getAssetId());
        }

        static void removeOrder(long l) {
            askOrderTable.delete(Ask.getAskOrder(l));
        }

        static void init() {
        }

        private Ask(Transaction transaction, Attachment.ColoredCoinsAskOrderPlacement coloredCoinsAskOrderPlacement) {
            super(transaction, coloredCoinsAskOrderPlacement);
            this.dbKey = askOrderDbKeyFactory.newKey(this.id);
        }

        private Ask(ResultSet resultSet, DbKey dbKey) throws SQLException {
            super(resultSet);
            this.dbKey = dbKey;
        }

        @Override
        private void save(Connection connection, String string) throws SQLException {
            super.save(connection, string);
        }

        private void updateQuantityQNT(long l) {
            super.setQuantityQNT(l);
            if (l > 0L) {
                askOrderTable.insert(this);
            } else if (l == 0L) {
                askOrderTable.delete(this);
            } else {
                throw new IllegalArgumentException("Negative quantity: " + l + " for order: " + Long.toUnsignedString(this.getId()));
            }
        }
    }
}

