/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import nxt.Account;
import nxt.BlockImpl;
import nxt.Constants;
import nxt.Db;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public final class Genesis {
    private static final byte[] CREATOR_PUBLIC_KEY;
    public static final long CREATOR_ID;
    public static final long EPOCH_BEGINNING;
    private static JSONObject genesisAccountsJSON;

    private static byte[] loadGenesisAccountsJSON() {
        MessageDigest messageDigest = Crypto.sha256();
        try (InputStreamReader inputStreamReader = new InputStreamReader(new DigestInputStream(ClassLoader.getSystemResourceAsStream("data/genesisAccounts" + (Constants.isTestnet ? "-testnet.json" : ".json")), messageDigest));){
            genesisAccountsJSON = (JSONObject)JSONValue.parseWithException((Reader)inputStreamReader);
        }
        catch (IOException | ParseException throwable) {
            throw new RuntimeException("Failed to process genesis recipients accounts", throwable);
        }
        messageDigest.update((byte)(Constants.isTestnet ? 1 : 0));
        messageDigest.update(Convert.toBytes(EPOCH_BEGINNING));
        return messageDigest.digest();
    }

    static BlockImpl newGenesisBlock() {
        return new BlockImpl(CREATOR_PUBLIC_KEY, Genesis.loadGenesisAccountsJSON());
    }

    static void apply() {
        Object object;
        if (genesisAccountsJSON == null) {
            Genesis.loadGenesisAccountsJSON();
        }
        int n = 0;
        JSONArray jSONArray = (JSONArray)genesisAccountsJSON.get((Object)"publicKeys");
        Logger.logDebugMessage("Loading public keys");
        for (Object e : jSONArray) {
            byte[] byArray = Convert.parseHexString((String)e);
            object = Account.addOrGetAccount(Account.getId(byArray));
            ((Account)object).apply(byArray);
            if (n++ % 100 != 0) continue;
            Db.db.commitTransaction();
        }
        Logger.logDebugMessage("Loaded " + jSONArray.size() + " public keys");
        n = 0;
        Iterator iterator = (JSONObject)genesisAccountsJSON.get((Object)"balances");
        Logger.logDebugMessage("Loading genesis amounts");
        long l = 0L;
        for (Map.Entry entry : iterator.entrySet()) {
            Account account = Account.addOrGetAccount(Convert.parseAccountId((String)entry.getKey()));
            account.addToBalanceAndUnconfirmedBalanceNQT(null, 0L, (Long)entry.getValue());
            l += ((Long)entry.getValue()).longValue();
            if (n++ % 100 != 0) continue;
            Db.db.commitTransaction();
        }
        if (l > 100000000000000000L) {
            throw new RuntimeException("Total balance " + l + " exceeds maximum allowed 100000000000000000");
        }
        Logger.logDebugMessage("Total balance %f %s", (double)l / 1.0E8, "GMD");
        object = Account.addOrGetAccount(CREATOR_ID);
        ((Account)object).apply(CREATOR_PUBLIC_KEY);
        ((Account)object).addToBalanceAndUnconfirmedBalanceNQT(null, 0L, -l);
        genesisAccountsJSON = null;
    }

    private Genesis() {
    }

    static {
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream("data/genesisParameters.json");){
            JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)new InputStreamReader(inputStream));
            CREATOR_PUBLIC_KEY = Convert.parseHexString((String)jSONObject.get((Object)"genesisPublicKey"));
            CREATOR_ID = Account.getId(CREATOR_PUBLIC_KEY);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            EPOCH_BEGINNING = simpleDateFormat.parse((String)jSONObject.get((Object)"epochBeginning")).getTime();
        }
        catch (IOException | java.text.ParseException | ParseException throwable) {
            throw new RuntimeException("Failed to load genesis parameters", throwable);
        }
        genesisAccountsJSON = null;
    }
}

