/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Attachment;
import nxt.BlockchainProcessor;
import nxt.CurrencyBuyOffer;
import nxt.CurrencySellOffer;
import nxt.Exchange;
import nxt.Nxt;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;

public abstract class CurrencyExchangeOffer {
    static final DbClause availableOnlyDbClause;
    final long id;
    private final long currencyId;
    private final long accountId;
    private final long rateNQT;
    private long limit;
    private long supply;
    private final int expirationHeight;
    private final int creationHeight;
    private final short transactionIndex;
    private final int transactionHeight;

    static void publishOffer(Transaction transaction, Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer) {
        CurrencyBuyOffer currencyBuyOffer = CurrencyBuyOffer.getOffer(monetarySystemPublishExchangeOffer.getCurrencyId(), transaction.getSenderId());
        if (currencyBuyOffer != null) {
            CurrencyExchangeOffer.removeOffer(AccountLedger.LedgerEvent.CURRENCY_OFFER_REPLACED, currencyBuyOffer);
        }
        CurrencyBuyOffer.addOffer(transaction, monetarySystemPublishExchangeOffer);
        CurrencySellOffer.addOffer(transaction, monetarySystemPublishExchangeOffer);
    }

    private static AvailableOffers calculateTotal(List<CurrencyExchangeOffer> list, long l) {
        long l2 = 0L;
        long l3 = l;
        long l4 = 0L;
        for (CurrencyExchangeOffer currencyExchangeOffer : list) {
            if (l3 == 0L) break;
            l4 = currencyExchangeOffer.getRateNQT();
            long l5 = Math.min(Math.min(l3, currencyExchangeOffer.getSupply()), currencyExchangeOffer.getLimit());
            long l6 = Math.multiplyExact(l5, currencyExchangeOffer.getRateNQT());
            l2 = Math.addExact(l2, l6);
            l3 = Math.subtractExact(l3, l5);
        }
        return new AvailableOffers(l4, Math.subtractExact(l, l3), l2);
    }

    public static AvailableOffers getAvailableToSell(long l, long l2) {
        return CurrencyExchangeOffer.calculateTotal(CurrencyExchangeOffer.getAvailableBuyOffers(l, 0L), l2);
    }

    private static List<CurrencyExchangeOffer> getAvailableBuyOffers(long l, long l2) {
        ArrayList<CurrencyExchangeOffer> arrayList = new ArrayList<CurrencyExchangeOffer>();
        DbClause dbClause = new DbClause.LongClause("currency_id", l).and(availableOnlyDbClause);
        if (l2 > 0L) {
            dbClause = dbClause.and(new DbClause.LongClause("rate", DbClause.Op.GTE, l2));
        }
        try (DbIterator<CurrencyBuyOffer> dbIterator = CurrencyBuyOffer.getOffers(dbClause, 0, -1, " ORDER BY rate DESC, creation_height ASC, transaction_height ASC, transaction_index ASC ");){
            for (CurrencyBuyOffer currencyBuyOffer : dbIterator) {
                arrayList.add(currencyBuyOffer);
            }
        }
        return arrayList;
    }

    static void exchangeCurrencyForNXT(Transaction transaction, Account account, long l, long l2, long l3) {
        List<CurrencyExchangeOffer> list = CurrencyExchangeOffer.getAvailableBuyOffers(l, l2);
        long l4 = 0L;
        long l5 = l3;
        for (CurrencyExchangeOffer currencyExchangeOffer : list) {
            if (l5 == 0L) break;
            long l6 = Math.min(Math.min(l5, currencyExchangeOffer.getSupply()), currencyExchangeOffer.getLimit());
            long l7 = Math.multiplyExact(l6, currencyExchangeOffer.getRateNQT());
            l4 = Math.addExact(l4, l7);
            l5 = Math.subtractExact(l5, l6);
            currencyExchangeOffer.decreaseLimitAndSupply(l6);
            long l8 = currencyExchangeOffer.getCounterOffer().increaseSupply(l6);
            Account account2 = Account.getAccount(currencyExchangeOffer.getAccountId());
            account2.addToBalanceNQT(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, currencyExchangeOffer.getId(), -l7);
            account2.addToCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, currencyExchangeOffer.getId(), l, l6);
            account2.addToUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, currencyExchangeOffer.getId(), l, l8);
            Exchange.addExchange(transaction, l, currencyExchangeOffer, account.getId(), currencyExchangeOffer.getAccountId(), l6);
        }
        long l9 = transaction.getId();
        account.addToBalanceAndUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, l9, l4);
        account.addToCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, l9, l, -(l3 - l5));
        account.addToUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, l9, l, l5);
    }

    public static AvailableOffers getAvailableToBuy(long l, long l2) {
        return CurrencyExchangeOffer.calculateTotal(CurrencyExchangeOffer.getAvailableSellOffers(l, 0L), l2);
    }

    private static List<CurrencyExchangeOffer> getAvailableSellOffers(long l, long l2) {
        ArrayList<CurrencyExchangeOffer> arrayList = new ArrayList<CurrencyExchangeOffer>();
        DbClause dbClause = new DbClause.LongClause("currency_id", l).and(availableOnlyDbClause);
        if (l2 > 0L) {
            dbClause = dbClause.and(new DbClause.LongClause("rate", DbClause.Op.LTE, l2));
        }
        try (DbIterator<CurrencySellOffer> dbIterator = CurrencySellOffer.getOffers(dbClause, 0, -1, " ORDER BY rate ASC, creation_height ASC, transaction_height ASC, transaction_index ASC ");){
            for (CurrencySellOffer currencySellOffer : dbIterator) {
                arrayList.add(currencySellOffer);
            }
        }
        return arrayList;
    }

    static void exchangeNXTForCurrency(Transaction transaction, Account account, long l, long l2, long l3) {
        List<CurrencyExchangeOffer> list = CurrencyExchangeOffer.getAvailableSellOffers(l, l2);
        long l4 = 0L;
        long l5 = l3;
        for (CurrencyExchangeOffer currencyExchangeOffer : list) {
            if (l5 == 0L) break;
            long l6 = Math.min(Math.min(l5, currencyExchangeOffer.getSupply()), currencyExchangeOffer.getLimit());
            long l7 = Math.multiplyExact(l6, currencyExchangeOffer.getRateNQT());
            l4 = Math.addExact(l4, l7);
            l5 = Math.subtractExact(l5, l6);
            currencyExchangeOffer.decreaseLimitAndSupply(l6);
            long l8 = currencyExchangeOffer.getCounterOffer().increaseSupply(l6);
            Account account2 = Account.getAccount(currencyExchangeOffer.getAccountId());
            account2.addToBalanceNQT(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, currencyExchangeOffer.getId(), l7);
            account2.addToUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, currencyExchangeOffer.getId(), Math.addExact(Math.multiplyExact(l6 - l8, currencyExchangeOffer.getRateNQT() - currencyExchangeOffer.getCounterOffer().getRateNQT()), Math.multiplyExact(l8, currencyExchangeOffer.getRateNQT())));
            account2.addToCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, currencyExchangeOffer.getId(), l, -l6);
            Exchange.addExchange(transaction, l, currencyExchangeOffer, currencyExchangeOffer.getAccountId(), account.getId(), l6);
        }
        long l9 = transaction.getId();
        account.addToCurrencyAndUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, l9, l, Math.subtractExact(l3, l5));
        account.addToBalanceNQT(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, l9, -l4);
        account.addToUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, l9, Math.multiplyExact(l3, l2) - l4);
    }

    static void removeOffer(AccountLedger.LedgerEvent ledgerEvent, CurrencyBuyOffer currencyBuyOffer) {
        CurrencySellOffer currencySellOffer = currencyBuyOffer.getCounterOffer();
        CurrencyBuyOffer.remove(currencyBuyOffer);
        CurrencySellOffer.remove(currencySellOffer);
        Account account = Account.getAccount(currencyBuyOffer.getAccountId());
        account.addToUnconfirmedBalanceNQT(ledgerEvent, currencyBuyOffer.getId(), Math.multiplyExact(currencyBuyOffer.getSupply(), currencyBuyOffer.getRateNQT()));
        account.addToUnconfirmedCurrencyUnits(ledgerEvent, currencyBuyOffer.getId(), currencyBuyOffer.getCurrencyId(), currencySellOffer.getSupply());
    }

    CurrencyExchangeOffer(long l, long l2, long l3, long l4, long l5, long l6, int n, int n2, short s) {
        this.id = l;
        this.currencyId = l2;
        this.accountId = l3;
        this.rateNQT = l4;
        this.limit = l5;
        this.supply = l6;
        this.expirationHeight = n;
        this.creationHeight = Nxt.getBlockchain().getHeight();
        this.transactionIndex = s;
        this.transactionHeight = n2;
    }

    CurrencyExchangeOffer(ResultSet resultSet) throws SQLException {
        this.id = resultSet.getLong("id");
        this.currencyId = resultSet.getLong("currency_id");
        this.accountId = resultSet.getLong("account_id");
        this.rateNQT = resultSet.getLong("rate");
        this.limit = resultSet.getLong("unit_limit");
        this.supply = resultSet.getLong("supply");
        this.expirationHeight = resultSet.getInt("expiration_height");
        this.creationHeight = resultSet.getInt("creation_height");
        this.transactionIndex = resultSet.getShort("transaction_index");
        this.transactionHeight = resultSet.getInt("transaction_height");
    }

    void save(Connection connection, String string) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO " + string + " (id, currency_id, account_id, rate, unit_limit, supply, expiration_height, creation_height, transaction_index, transaction_height, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.currencyId);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setLong(++n, this.rateNQT);
            preparedStatement.setLong(++n, this.limit);
            preparedStatement.setLong(++n, this.supply);
            preparedStatement.setInt(++n, this.expirationHeight);
            preparedStatement.setInt(++n, this.creationHeight);
            preparedStatement.setShort(++n, this.transactionIndex);
            preparedStatement.setInt(++n, this.transactionHeight);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getRateNQT() {
        return this.rateNQT;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getSupply() {
        return this.supply;
    }

    public int getExpirationHeight() {
        return this.expirationHeight;
    }

    public int getHeight() {
        return this.creationHeight;
    }

    protected abstract CurrencyExchangeOffer getCounterOffer();

    long increaseSupply(long l) {
        long l2 = Math.max(Math.addExact(this.supply, Math.subtractExact(l, this.limit)), 0L);
        this.supply += l - l2;
        return l2;
    }

    void decreaseLimitAndSupply(long l) {
        this.limit -= l;
        this.supply -= l;
    }

    static {
        Nxt.getBlockchainProcessor().addListener(block -> {
            ArrayList<CurrencyBuyOffer> arrayList = new ArrayList<CurrencyBuyOffer>();
            try (DbIterator<CurrencyBuyOffer> dbIterator = CurrencyBuyOffer.getOffers(new DbClause.IntClause("expiration_height", block.getHeight()), 0, -1);){
                for (CurrencyBuyOffer currencyBuyOffer2 : dbIterator) {
                    arrayList.add(currencyBuyOffer2);
                }
            }
            arrayList.forEach(currencyBuyOffer -> CurrencyExchangeOffer.removeOffer(AccountLedger.LedgerEvent.CURRENCY_OFFER_EXPIRED, currencyBuyOffer));
        }, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
        availableOnlyDbClause = new DbClause.LongClause("unit_limit", DbClause.Op.NE, 0L).and(new DbClause.LongClause("supply", DbClause.Op.NE, 0L));
    }

    public static final class AvailableOffers {
        private final long rateNQT;
        private final long units;
        private final long amountNQT;

        private AvailableOffers(long l, long l2, long l3) {
            this.rateNQT = l;
            this.units = l2;
            this.amountNQT = l3;
        }

        public long getRateNQT() {
            return this.rateNQT;
        }

        public long getUnits() {
            return this.units;
        }

        public long getAmountNQT() {
            return this.amountNQT;
        }
    }
}

