/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Account;
import nxt.Attachment;
import nxt.Currency;
import nxt.CurrencyExchangeOffer;
import nxt.CurrencySellOffer;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;

public final class CurrencyBuyOffer
extends CurrencyExchangeOffer {
    private static final DbKey.LongKeyFactory<CurrencyBuyOffer> buyOfferDbKeyFactory = new DbKey.LongKeyFactory<CurrencyBuyOffer>("id"){

        @Override
        public DbKey newKey(CurrencyBuyOffer currencyBuyOffer) {
            return currencyBuyOffer.dbKey;
        }
    };
    private static final VersionedEntityDbTable<CurrencyBuyOffer> buyOfferTable = new VersionedEntityDbTable<CurrencyBuyOffer>("buy_offer", buyOfferDbKeyFactory){

        @Override
        protected CurrencyBuyOffer load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new CurrencyBuyOffer(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, CurrencyBuyOffer currencyBuyOffer) throws SQLException {
            currencyBuyOffer.save(connection, this.table);
        }
    };
    private final DbKey dbKey;

    public static int getCount() {
        return buyOfferTable.getCount();
    }

    public static CurrencyBuyOffer getOffer(long l) {
        return (CurrencyBuyOffer)buyOfferTable.get(buyOfferDbKeyFactory.newKey(l));
    }

    public static DbIterator<CurrencyBuyOffer> getAll(int n, int n2) {
        return buyOfferTable.getAll(n, n2);
    }

    public static DbIterator<CurrencyBuyOffer> getOffers(Currency currency, int n, int n2) {
        return CurrencyBuyOffer.getCurrencyOffers(currency.getId(), false, n, n2);
    }

    public static DbIterator<CurrencyBuyOffer> getCurrencyOffers(long l, boolean bl, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("currency_id", l);
        if (bl) {
            dbClause = dbClause.and(availableOnlyDbClause);
        }
        return buyOfferTable.getManyBy(dbClause, n, n2, " ORDER BY rate DESC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
    }

    public static DbIterator<CurrencyBuyOffer> getAccountOffers(long l, boolean bl, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("account_id", l);
        if (bl) {
            dbClause = dbClause.and(availableOnlyDbClause);
        }
        return buyOfferTable.getManyBy(dbClause, n, n2, " ORDER BY rate DESC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
    }

    public static CurrencyBuyOffer getOffer(Currency currency, Account account) {
        return CurrencyBuyOffer.getOffer(currency.getId(), account.getId());
    }

    public static CurrencyBuyOffer getOffer(long l, long l2) {
        return (CurrencyBuyOffer)buyOfferTable.getBy(new DbClause.LongClause("currency_id", l).and(new DbClause.LongClause("account_id", l2)));
    }

    public static DbIterator<CurrencyBuyOffer> getOffers(DbClause dbClause, int n, int n2) {
        return buyOfferTable.getManyBy(dbClause, n, n2);
    }

    public static DbIterator<CurrencyBuyOffer> getOffers(DbClause dbClause, int n, int n2, String string) {
        return buyOfferTable.getManyBy(dbClause, n, n2, string);
    }

    static void addOffer(Transaction transaction, Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer) {
        buyOfferTable.insert(new CurrencyBuyOffer(transaction, monetarySystemPublishExchangeOffer));
    }

    static void remove(CurrencyBuyOffer currencyBuyOffer) {
        buyOfferTable.delete(currencyBuyOffer);
    }

    static void init() {
    }

    private CurrencyBuyOffer(Transaction transaction, Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer) {
        super(transaction.getId(), monetarySystemPublishExchangeOffer.getCurrencyId(), transaction.getSenderId(), monetarySystemPublishExchangeOffer.getBuyRateNQT(), monetarySystemPublishExchangeOffer.getTotalBuyLimit(), monetarySystemPublishExchangeOffer.getInitialBuySupply(), monetarySystemPublishExchangeOffer.getExpirationHeight(), transaction.getHeight(), transaction.getIndex());
        this.dbKey = buyOfferDbKeyFactory.newKey(this.id);
    }

    private CurrencyBuyOffer(ResultSet resultSet, DbKey dbKey) throws SQLException {
        super(resultSet);
        this.dbKey = dbKey;
    }

    @Override
    public CurrencySellOffer getCounterOffer() {
        return CurrencySellOffer.getOffer(this.id);
    }

    @Override
    long increaseSupply(long l) {
        long l2 = super.increaseSupply(l);
        buyOfferTable.insert(this);
        return l2;
    }

    @Override
    void decreaseLimitAndSupply(long l) {
        super.decreaseLimitAndSupply(l);
        buyOfferTable.insert(this);
    }
}

