/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.math.BigInteger;
import nxt.Nxt;

public final class Constants {
    public static final boolean isTestnet = Nxt.getBooleanProperty("nxt.isTestnet");
    public static final boolean isOffline = Nxt.getBooleanProperty("nxt.isOffline");
    public static final boolean isLightClient = Nxt.getBooleanProperty("nxt.isLightClient");
    public static final boolean isAutomatedTest = isTestnet && Nxt.getBooleanProperty("nxt.isAutomatedTest");
    public static final String customLoginWarning = Nxt.getStringProperty("nxt.customLoginWarning", null, false, "UTF-8");
    public static final String COIN_SYMBOL = "GMD";
    public static final String ACCOUNT_PREFIX = "GMD";
    public static final String PROJECT_NAME = "CoopNetwork";
    public static final int MAX_NUMBER_OF_TRANSACTIONS = Nxt.getIntProperty("nxt.maxNumberOfTransactions", 255);
    public static final int MIN_TRANSACTION_SIZE = 176;
    public static final int MAX_PAYLOAD_LENGTH = MAX_NUMBER_OF_TRANSACTIONS * 176;
    public static final long MAX_BALANCE_NXT = 1000000000L;
    public static final long ONE_NXT = 100000000L;
    public static final long ONE_GMD = 100000000L;
    public static final long MAX_BALANCE_NQT = 100000000000000000L;
    public static final int BLOCK_TIME = 60;
    public static final long INITIAL_BASE_TARGET = BigInteger.valueOf(2L).pow(63).divide(BigInteger.valueOf(60000000000L)).longValue();
    public static final long MAX_BASE_TARGET = INITIAL_BASE_TARGET * (isTestnet ? 1000000000L : 50L);
    public static final long MIN_BASE_TARGET = INITIAL_BASE_TARGET * 9L / 10L;
    public static final int MIN_BLOCKTIME_LIMIT = 53;
    public static final int MAX_BLOCKTIME_LIMIT = 67;
    public static final int BASE_TARGET_GAMMA = 64;
    public static final int MAX_ROLLBACK = Math.max(Nxt.getIntProperty("nxt.maxRollback"), 720);
    public static final int GUARANTEED_BALANCE_CONFIRMATIONS = isTestnet ? Nxt.getIntProperty("nxt.testnetGuaranteedBalanceConfirmations", 1440) : 1440;
    public static final int LEASING_DELAY = isTestnet ? Nxt.getIntProperty("nxt.testnetLeasingDelay", 1440) : 1440;
    public static final long MIN_FORGING_BALANCE_NQT = 100000000000L;
    public static final int MAX_TIMEDRIFT = 15;
    public static final int FORGING_DELAY = Nxt.getIntProperty("nxt.forgingDelay");
    public static final int FORGING_SPEEDUP = Nxt.getIntProperty("nxt.forgingSpeedup");
    public static final int BATCH_COMMIT_SIZE = Nxt.getIntProperty("nxt.batchCommitSize", Integer.MAX_VALUE);
    public static final byte MAX_PHASING_VOTE_TRANSACTIONS = 10;
    public static final byte MAX_PHASING_WHITELIST_SIZE = 10;
    public static final byte MAX_PHASING_LINKED_TRANSACTIONS = 10;
    public static final int MAX_PHASING_DURATION = 20160;
    public static final int MAX_PHASING_REVEALED_SECRET_LENGTH = 100;
    public static final int MAX_ALIAS_URI_LENGTH = 1000;
    public static final int MAX_ALIAS_LENGTH = 100;
    public static final int MAX_ARBITRARY_MESSAGE_LENGTH = 160;
    public static final int MAX_ENCRYPTED_MESSAGE_LENGTH = 176;
    public static final int MAX_PRUNABLE_MESSAGE_LENGTH = 43008;
    public static final int MAX_PRUNABLE_ENCRYPTED_MESSAGE_LENGTH = 43008;
    public static final long MESSAGE_FEE_PER_32_UNITS = 10000L;
    public static final int MIN_PRUNABLE_LIFETIME = isTestnet ? 86400 : 1209600;
    public static final int MAX_PRUNABLE_LIFETIME;
    public static final boolean ENABLE_PRUNING;
    public static final boolean INCLUDE_EXPIRED_PRUNABLE;
    public static final int MAX_ACCOUNT_NAME_LENGTH = 100;
    public static final int MAX_ACCOUNT_DESCRIPTION_LENGTH = 1000;
    public static final int MAX_ACCOUNT_PROPERTY_NAME_LENGTH = 32;
    public static final int MAX_ACCOUNT_PROPERTY_VALUE_LENGTH = 160;
    public static final int MAX_ASSET_PROPERTY_NAME_LENGTH = 32;
    public static final int MAX_ASSET_PROPERTY_VALUE_LENGTH = 160;
    public static final long MAX_ASSET_QUANTITY_QNT = 100000000000000000L;
    public static final int MIN_ASSET_NAME_LENGTH = 3;
    public static final int MAX_ASSET_NAME_LENGTH = 10;
    public static final int MAX_ASSET_DESCRIPTION_LENGTH = 1000;
    public static final int MAX_SINGLETON_ASSET_DESCRIPTION_LENGTH = 160;
    public static final int MAX_ASSET_TRANSFER_COMMENT_LENGTH = 1000;
    public static final int MAX_DIVIDEND_PAYMENT_ROLLBACK = 1441;
    public static final int MIN_GMD_BALANCE_ASSET_CREATION = 10000000;
    public static final int MAX_POLL_NAME_LENGTH = 100;
    public static final int MAX_POLL_DESCRIPTION_LENGTH = 1000;
    public static final int MAX_POLL_OPTION_LENGTH = 100;
    public static final int MAX_POLL_OPTION_COUNT = 100;
    public static final int MAX_POLL_DURATION = 20160;
    public static final byte MIN_VOTE_VALUE = -92;
    public static final byte MAX_VOTE_VALUE = 92;
    public static final byte NO_VOTE_VALUE = -128;
    public static final int MAX_DGS_LISTING_QUANTITY = 1000000000;
    public static final int MAX_DGS_LISTING_NAME_LENGTH = 100;
    public static final int MAX_DGS_LISTING_DESCRIPTION_LENGTH = 1000;
    public static final int MAX_DGS_LISTING_TAGS_LENGTH = 100;
    public static final int MAX_DGS_GOODS_LENGTH = 1000;
    public static final int MIN_CURRENCY_NAME_LENGTH = 3;
    public static final int MAX_CURRENCY_NAME_LENGTH = 10;
    public static final int MIN_CURRENCY_CODE_LENGTH = 3;
    public static final int MAX_CURRENCY_CODE_LENGTH = 5;
    public static final int MAX_CURRENCY_DESCRIPTION_LENGTH = 1000;
    public static final long MAX_CURRENCY_TOTAL_SUPPLY = 100000000000000000L;
    public static final int MAX_MINTING_RATIO = 10000;
    public static final byte MIN_NUMBER_OF_SHUFFLING_PARTICIPANTS = 3;
    public static final byte MAX_NUMBER_OF_SHUFFLING_PARTICIPANTS = 30;
    public static final short MAX_SHUFFLING_REGISTRATION_PERIOD = 10080;
    public static final short SHUFFLING_PROCESSING_DEADLINE;
    public static final int MAX_TAGGED_DATA_NAME_LENGTH = 100;
    public static final int MAX_TAGGED_DATA_DESCRIPTION_LENGTH = 1000;
    public static final int MAX_TAGGED_DATA_TAGS_LENGTH = 100;
    public static final int MAX_TAGGED_DATA_TYPE_LENGTH = 100;
    public static final int MAX_TAGGED_DATA_CHANNEL_LENGTH = 100;
    public static final int MAX_TAGGED_DATA_FILENAME_LENGTH = 100;
    public static final int MAX_TAGGED_DATA_DATA_LENGTH = 43008;
    public static final int MAX_REFERENCED_TRANSACTION_TIMESPAN = 5184000;
    public static final int CHECKSUM_BLOCK_1 = Integer.MAX_VALUE;
    public static final int LAST_CHECKSUM_BLOCK = 0;
    public static final int LAST_KNOWN_BLOCK;
    public static final int[] MIN_VERSION;
    public static final int[] MIN_PROXY_VERSION;
    static final long UNCONFIRMED_POOL_DEPOSIT_NQT;
    public static final long SHUFFLING_DEPOSIT_NQT;
    public static final boolean correctInvalidFees;
    public static final String ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz";
    public static final String ALLOWED_CURRENCY_CODE_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final boolean DISABLE_FULL_TEXT_SEARCH;
    public static final boolean DISABLE_METADATA_DETECTION;

    private Constants() {
    }

    static {
        int n = Nxt.getIntProperty("nxt.maxPrunableLifetime");
        ENABLE_PRUNING = n >= 0;
        MAX_PRUNABLE_LIFETIME = ENABLE_PRUNING ? Math.max(n, MIN_PRUNABLE_LIFETIME) : Integer.MAX_VALUE;
        INCLUDE_EXPIRED_PRUNABLE = Nxt.getBooleanProperty("nxt.includeExpiredPrunable");
        SHUFFLING_PROCESSING_DEADLINE = (short)(isTestnet ? 10 : 100);
        LAST_KNOWN_BLOCK = isTestnet ? 0 : 0;
        MIN_VERSION = new int[]{1, 12, 1};
        MIN_PROXY_VERSION = new int[]{1, 12, 1};
        UNCONFIRMED_POOL_DEPOSIT_NQT = (long)(isTestnet ? 50 : 100) * 100000000L;
        SHUFFLING_DEPOSIT_NQT = (long)(isTestnet ? 7 : 1000) * 100000000L;
        correctInvalidFees = Nxt.getBooleanProperty("nxt.correctInvalidFees");
        DISABLE_FULL_TEXT_SEARCH = Nxt.getBooleanProperty("nxt.disableFullTextSearch");
        DISABLE_METADATA_DETECTION = Nxt.getBooleanProperty("nxt.disableMetadataDetection");
    }
}

