/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Account;
import nxt.AssetHistory;
import nxt.AssetTransfer;
import nxt.Attachment;
import nxt.Nxt;
import nxt.Trade;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class Asset {
    private static final DbKey.LongKeyFactory<Asset> assetDbKeyFactory = new DbKey.LongKeyFactory<Asset>("id"){

        @Override
        public DbKey newKey(Asset asset) {
            return asset.dbKey;
        }
    };
    private static final VersionedEntityDbTable<Asset> assetTable = new VersionedEntityDbTable<Asset>("asset", assetDbKeyFactory, "name,description"){

        @Override
        protected Asset load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Asset(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Asset asset) throws SQLException {
            asset.save(connection);
        }

        @Override
        public void trim(int n) {
            super.trim(Math.max(0, n - 1441));
        }

        @Override
        public void checkAvailable(int n) {
            if (n + 1441 < Nxt.getBlockchainProcessor().getMinRollbackHeight()) {
                throw new IllegalArgumentException("Historical data as of height " + n + " not available.");
            }
            if (n > Nxt.getBlockchain().getHeight()) {
                throw new IllegalArgumentException("Height " + n + " exceeds blockchain height " + Nxt.getBlockchain().getHeight());
            }
        }
    };
    private static final DbKey.LongKeyFactory<AssetProperty> assetPropertyDbKeyFactory = new DbKey.LongKeyFactory<AssetProperty>("id"){

        @Override
        public DbKey newKey(AssetProperty assetProperty) {
            return assetProperty.dbKey;
        }
    };
    private static final VersionedEntityDbTable<AssetProperty> assetPropertyTable = new VersionedEntityDbTable<AssetProperty>("asset_property", assetPropertyDbKeyFactory){

        @Override
        protected AssetProperty load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new AssetProperty(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, AssetProperty assetProperty) throws SQLException {
            assetProperty.save(connection);
        }
    };
    private final long assetId;
    private final DbKey dbKey;
    private final long accountId;
    private final String name;
    private final String description;
    private final long initialQuantityQNT;
    private long quantityQNT;
    private final byte decimals;
    private static final Listeners<AssetProperty, Event> propertyListeners = new Listeners();

    public static DbIterator<Asset> getAllAssets(int n, int n2) {
        return assetTable.getAll(n, n2);
    }

    public static int getCount() {
        return assetTable.getCount();
    }

    public static Asset getAsset(long l) {
        return (Asset)assetTable.get(assetDbKeyFactory.newKey(l));
    }

    public static Asset getAsset(long l, int n) {
        return (Asset)assetTable.get(assetDbKeyFactory.newKey(l), n);
    }

    public static DbIterator<Asset> getAssetsIssuedBy(long l, int n, int n2) {
        return assetTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    public static DbIterator<Asset> searchAssets(String string, int n, int n2) {
        return assetTable.search(string, DbClause.EMPTY_CLAUSE, n, n2, " ORDER BY ft.score DESC ");
    }

    static void addAsset(Transaction transaction, Attachment.ColoredCoinsAssetIssuance coloredCoinsAssetIssuance) {
        Asset asset = new Asset(transaction, coloredCoinsAssetIssuance);
        assetTable.insert(asset);
        AssetHistory.addAssetIncrease(transaction, asset.getId(), asset.getQuantityQNT());
    }

    static void deleteAsset(Transaction transaction, long l, long l2) {
        Asset asset = Asset.getAsset(l);
        asset.quantityQNT = Math.max(0L, asset.quantityQNT - l2);
        assetTable.insert(asset);
        AssetHistory.addAssetDelete(transaction, l, l2);
    }

    static void increaseAsset(Transaction transaction, long l, long l2) {
        Asset asset = Asset.getAsset(l);
        asset.quantityQNT = Math.addExact(asset.quantityQNT, l2);
        assetTable.insert(asset);
        AssetHistory.addAssetIncrease(transaction, l, l2);
    }

    static void init() {
    }

    private Asset(Transaction transaction, Attachment.ColoredCoinsAssetIssuance coloredCoinsAssetIssuance) {
        this.assetId = transaction.getId();
        this.dbKey = assetDbKeyFactory.newKey(this.assetId);
        this.accountId = transaction.getSenderId();
        this.name = coloredCoinsAssetIssuance.getName();
        this.description = coloredCoinsAssetIssuance.getDescription();
        this.initialQuantityQNT = this.quantityQNT = coloredCoinsAssetIssuance.getQuantityQNT();
        this.decimals = coloredCoinsAssetIssuance.getDecimals();
    }

    private Asset(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.assetId = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.accountId = resultSet.getLong("account_id");
        this.name = resultSet.getString("name");
        this.description = resultSet.getString("description");
        this.initialQuantityQNT = resultSet.getLong("initial_quantity");
        this.quantityQNT = resultSet.getLong("quantity");
        this.decimals = resultSet.getByte("decimals");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO asset (id, account_id, name, description, initial_quantity, quantity, decimals, height, latest) KEY(id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.assetId);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setString(++n, this.name);
            preparedStatement.setString(++n, this.description);
            preparedStatement.setLong(++n, this.initialQuantityQNT);
            preparedStatement.setLong(++n, this.quantityQNT);
            preparedStatement.setByte(++n, this.decimals);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.assetId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getInitialQuantityQNT() {
        return this.initialQuantityQNT;
    }

    public long getQuantityQNT() {
        return this.quantityQNT;
    }

    public byte getDecimals() {
        return this.decimals;
    }

    public DbIterator<Account.AccountAsset> getAccounts(int n, int n2) {
        return Account.getAssetAccounts(this.assetId, n, n2);
    }

    public DbIterator<Account.AccountAsset> getAccounts(int n, int n2, int n3) {
        return Account.getAssetAccounts(this.assetId, n, n2, n3);
    }

    public DbIterator<Trade> getTrades(int n, int n2) {
        return Trade.getAssetTrades(this.assetId, n, n2);
    }

    public DbIterator<AssetTransfer> getAssetTransfers(int n, int n2) {
        return AssetTransfer.getAssetTransfers(this.assetId, n, n2);
    }

    public static boolean addListener(Listener<AssetProperty> listener, Event event) {
        return propertyListeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<AssetProperty> listener, Event event) {
        return propertyListeners.removeListener(listener, event);
    }

    public void setProperty(long l, Account account, String string, String string2) {
        string2 = Convert.emptyToNull(string2);
        AssetProperty assetProperty = this.getProperty(account.getId(), string);
        if (assetProperty == null) {
            assetProperty = new AssetProperty(l, this.assetId, account.getId(), string, string2);
        } else {
            assetProperty.setValue(string2);
        }
        assetPropertyTable.insert(assetProperty);
        propertyListeners.notify(assetProperty, Event.SET_PROPERTY);
    }

    public static AssetProperty getProperty(long l) {
        return (AssetProperty)assetPropertyTable.get(assetPropertyDbKeyFactory.newKey(l));
    }

    public AssetProperty getProperty(long l, String string) {
        return (AssetProperty)assetPropertyTable.getBy(Asset.getPropertiesClause(this.assetId, l, string));
    }

    public static DbIterator<AssetProperty> getProperties(long l, long l2, String string, int n, int n2) {
        return assetPropertyTable.getManyBy(Asset.getPropertiesClause(l, l2, string), n, n2);
    }

    private static DbClause getPropertiesClause(long l, long l2, String string) {
        if (l == 0L && l2 == 0L) {
            throw new IllegalArgumentException("At least one of assetId and setterId must be specified");
        }
        DbClause dbClause = null;
        if (l != 0L) {
            dbClause = new DbClause.LongClause("asset_id", l);
        }
        if (l2 != 0L) {
            DbClause.LongClause longClause = new DbClause.LongClause("setter_id", l2);
            dbClause = dbClause != null ? dbClause.and(longClause) : longClause;
        }
        if (string != null) {
            dbClause = dbClause.and(new DbClause.StringClause("property", string));
        }
        return dbClause;
    }

    public static void deleteProperty(long l) {
        AssetProperty assetProperty = (AssetProperty)assetPropertyTable.get(assetPropertyDbKeyFactory.newKey(l));
        if (assetProperty == null) {
            return;
        }
        assetPropertyTable.delete(assetProperty);
        propertyListeners.notify(assetProperty, Event.DELETE_PROPERTY);
    }

    public static class AssetProperty {
        private final long id;
        private final DbKey dbKey;
        private final long assetId;
        private final long setterId;
        private final String property;
        private String value;

        public AssetProperty(long l, long l2, long l3, String string, String string2) {
            this.id = l;
            this.dbKey = assetPropertyDbKeyFactory.newKey(l);
            this.assetId = l2;
            this.setterId = l3;
            this.property = string;
            this.value = string2;
        }

        private AssetProperty(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.assetId = resultSet.getLong("asset_id");
            this.setterId = resultSet.getLong("setter_id");
            this.property = resultSet.getString("property");
            this.value = resultSet.getString("value");
        }

        public long getId() {
            return this.id;
        }

        public long getAssetId() {
            return this.assetId;
        }

        public long getSetterId() {
            return this.setterId;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO asset_property (id, asset_id, setter_id, property, value, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setLong(++n, this.assetId);
                preparedStatement.setLong(++n, this.setterId);
                preparedStatement.setString(++n, this.property);
                DbUtils.setString(preparedStatement, ++n, this.value);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public String toString() {
            return "AssetProperty{id=" + this.id + ", assetId=" + this.assetId + ", setterId=" + this.setterId + ", property='" + this.property + "', value='" + this.value + "'}";
        }
    }

    public static enum Event {
        SET_PROPERTY,
        DELETE_PROPERTY;

    }
}

